/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import de.regnis.q.sequence.line.simplifier.QSequenceLineDummySimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineEOLUnifyingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineTeeSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceReducingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceSkippingSimplifier;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;

public class SVNAnnotationGenerator
implements ISVNFileRevisionHandler {
    private File myTmpDirectory;
    private String myPath;
    private long myCurrentRevision;
    private String myCurrentAuthor;
    private Date myCurrentDate;
    private File myPreviousFile;
    private File myCurrentFile;
    private List myLines;
    private SVNDeltaProcessor myDeltaProcessor;
    private ISVNEventHandler myCancelBaton;
    private long myStartRevision;
    private boolean myIsForce;
    private SVNDiffOptions myDiffOptions;
    private QSequenceLineSimplifier mySimplifier;

    public SVNAnnotationGenerator(String path, File tmpDirectory, long startRevision, ISVNEventHandler cancelBaton) {
        this(path, tmpDirectory, startRevision, false, cancelBaton);
    }

    public SVNAnnotationGenerator(String path, File tmpDirectory, long startRevision, boolean force, ISVNEventHandler cancelBaton) {
        this(path, tmpDirectory, startRevision, force, new SVNDiffOptions(), cancelBaton);
    }

    public SVNAnnotationGenerator(String path, File tmpDirectory, long startRevision, boolean force, SVNDiffOptions diffOptions, ISVNEventHandler cancelBaton) {
        this.myTmpDirectory = tmpDirectory;
        this.myCancelBaton = cancelBaton;
        this.myPath = path;
        this.myIsForce = force;
        if (!this.myTmpDirectory.isDirectory()) {
            this.myTmpDirectory.mkdirs();
        }
        this.myLines = new ArrayList();
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myStartRevision = startRevision;
        this.myDiffOptions = diffOptions;
    }

    public void openRevision(SVNFileRevision fileRevision) throws SVNException {
        boolean known;
        Map propDiff = fileRevision.getPropertiesDelta();
        String newMimeType = propDiff != null ? propDiff.get("svn:mime-type") : null;
        if (!this.myIsForce && SVNProperty.isBinaryMimeType(newMimeType)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_BINARY_FILE, "Cannot calculate blame information for binary file ''{0}''", this.myPath);
            SVNErrorManager.error(err);
        }
        this.myCurrentRevision = fileRevision.getRevision();
        boolean bl = known = fileRevision.getRevision() >= this.myStartRevision;
        if (this.myCancelBaton != null) {
            SVNEvent event = SVNEventFactory.createAnnotateEvent(this.myPath, this.myCurrentRevision);
            this.myCancelBaton.handleEvent(event, -1.0);
            this.myCancelBaton.checkCancelled();
        }
        Map props = fileRevision.getRevisionProperties();
        this.myCurrentAuthor = known && props != null && props.get("svn:author") != null ? props.get("svn:author").toString() : null;
        this.myCurrentDate = known && props != null && props.get("svn:date") != null ? SVNTimeUtil.parseDate(fileRevision.getRevisionProperties().get("svn:date").toString()) : null;
        if (this.myPreviousFile == null) {
            this.myPreviousFile = SVNFileUtil.createUniqueFile(this.myTmpDirectory, "annotate", ".tmp");
            SVNFileUtil.createEmptyFile(this.myPreviousFile);
        }
    }

    public void closeRevision(String token) throws SVNException {
    }

    public void applyTextDelta(String token, String baseChecksum) throws SVNException {
        if (this.myCurrentFile != null) {
            this.myCurrentFile.delete();
        } else {
            this.myCurrentFile = SVNFileUtil.createUniqueFile(this.myTmpDirectory, "annotate", ".tmp");
        }
        this.myDeltaProcessor.applyTextDelta(this.myPreviousFile, this.myCurrentFile, false);
    }

    public OutputStream textDeltaChunk(String token, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void textDeltaEnd(String token) throws SVNException {
        block25: {
            IOException e222;
            RandomAccessFile right;
            RandomAccessFile left;
            block23: {
                this.myDeltaProcessor.textDeltaEnd();
                left = null;
                right = null;
                left = new RandomAccessFile(this.myPreviousFile, "r");
                right = new RandomAccessFile(this.myCurrentFile, "r");
                ArrayList<LineInfo> newLines = new ArrayList<LineInfo>();
                int oldStart = 0;
                int newStart = 0;
                QSequenceLineResult result = QSequenceLineMedia.createBlocks(new QSequenceLineRAFileData(left), new QSequenceLineRAFileData(right), this.createSimplifier());
                try {
                    List blocksList = result.getBlocks();
                    for (int i = 0; i < blocksList.size(); ++i) {
                        QSequenceDifferenceBlock block = (QSequenceDifferenceBlock)blocksList.get(i);
                        SVNAnnotationGenerator.copyOldLinesToNewLines(oldStart, newStart, block.getLeftFrom() - oldStart, this.myLines, newLines, result.getRightCache());
                        for (int j = block.getRightFrom(); j <= block.getRightTo(); ++j) {
                            LineInfo line = new LineInfo();
                            line.revision = this.myCurrentDate != null ? this.myCurrentRevision : -1L;
                            line.author = this.myCurrentAuthor;
                            line.line = result.getRightCache().getLine(j).getContentBytes();
                            line.date = this.myCurrentDate;
                            newLines.add(line);
                        }
                        oldStart = block.getLeftTo() + 1;
                        newStart = block.getRightTo() + 1;
                    }
                    SVNAnnotationGenerator.copyOldLinesToNewLines(oldStart, newStart, this.myLines.size() - oldStart, this.myLines, newLines, result.getRightCache());
                    this.myLines = newLines;
                }
                finally {
                    result.close();
                }
                Object var15_16 = null;
                if (left == null) break block23;
                try {
                    left.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (right != null) {
                try {
                    right.close();
                }
                catch (IOException e222) {}
            }
            break block25;
            {
                catch (Throwable e3) {
                    IOException e222;
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Exception while generating annotation: {0}", e3.getMessage());
                    SVNErrorManager.error(err, e3);
                    Object var15_17 = null;
                    if (left != null) {
                        try {
                            left.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (right != null) {
                        try {
                            right.close();
                        }
                        catch (IOException e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var15_18 = null;
                if (left != null) {
                    try {
                        left.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (right != null) {
                    try {
                        right.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        SVNFileUtil.rename(this.myCurrentFile, this.myPreviousFile);
    }

    private static void copyOldLinesToNewLines(int oldStart, int newStart, int count, List oldLines, List newLines, QSequenceLineCache newCache) throws IOException {
        for (int index = 0; index < count; ++index) {
            LineInfo line = (LineInfo)oldLines.get(oldStart + index);
            QSequenceLine sequenceLine = newCache.getLine(newStart + index);
            line.line = sequenceLine.getContentBytes();
            newLines.add(line);
        }
    }

    public void reportAnnotations(ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        if (this.myLines == null || handler == null) {
            return;
        }
        inputEncoding = inputEncoding == null ? System.getProperty("file.encoding") : inputEncoding;
        for (int i = 0; i < this.myLines.size(); ++i) {
            String lineAsString;
            LineInfo info = (LineInfo)this.myLines.get(i);
            byte[] bytes = info.line;
            int length = bytes.length;
            if (bytes.length >= 2 && bytes[length - 2] == 13 && bytes[length - 1] == 10) {
                length -= 2;
            } else if (bytes.length >= 1 && (bytes[length - 1] == 13 || bytes[length - 1] == 10)) {
                --length;
            }
            try {
                lineAsString = new String(info.line, 0, length, inputEncoding);
            }
            catch (UnsupportedEncodingException e) {
                lineAsString = new String(info.line, 0, length);
            }
            handler.handleLine(info.date, info.revision, info.author, lineAsString);
        }
    }

    public void dispose() {
        this.myLines = null;
        if (this.myCurrentFile != null) {
            this.myCurrentFile.delete();
        }
        if (this.myPreviousFile != null) {
            this.myPreviousFile.delete();
        }
    }

    private QSequenceLineSimplifier createSimplifier() {
        if (this.mySimplifier == null) {
            QSequenceLineSimplifier first = this.myDiffOptions.isIgnoreEOLStyle() ? new QSequenceLineEOLUnifyingSimplifier() : new QSequenceLineDummySimplifier();
            QSequenceLineSimplifier second = new QSequenceLineDummySimplifier();
            if (this.myDiffOptions.isIgnoreAllWhitespace()) {
                second = new QSequenceLineWhiteSpaceSkippingSimplifier();
            } else if (this.myDiffOptions.isIgnoreAmountOfWhitespace()) {
                second = new QSequenceLineWhiteSpaceReducingSimplifier();
            }
            this.mySimplifier = new QSequenceLineTeeSimplifier(first, second);
        }
        return this.mySimplifier;
    }

    private static class LineInfo {
        public byte[] line;
        public long revision;
        public String author;
        public Date date;

        private LineInfo() {
        }
    }
}

