/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreGlobal;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class StatusPrinter {
    private static PrintStream ps = System.out;
    static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss,SSS");

    public static void setPrintStream(PrintStream printStream) {
        ps = printStream;
    }

    public static void printIfErrorsOccured(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else if (sm.getLevel() == 2) {
            StatusPrinter.print(sm);
        }
    }

    public static void print(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusPrinter.print(sm);
        }
    }

    public static void print(StatusManager sm) {
        StringBuilder sb = new StringBuilder();
        StatusPrinter.buildStr(sb, sm);
        ps.println(sb.toString());
    }

    public static void buildStr(StringBuilder sb, StatusManager sm) {
        for (Status s : sm.getCopyOfStatusList()) {
            StatusPrinter.buildStr(sb, "", s);
        }
    }

    private static void appendThrowable(StringBuilder sb, Throwable t) {
        String[] stringRep;
        for (String s : stringRep = ThrowableToStringArray.convert(t)) {
            if (!s.startsWith("Caused by: ")) {
                if (Character.isDigit(s.charAt(0))) {
                    sb.append("\t... ");
                } else {
                    sb.append("\tat ");
                }
            }
            sb.append(s).append(CoreGlobal.LINE_SEPARATOR);
        }
    }

    public static void buildStr(StringBuilder sb, String indentation, Status s) {
        String prefix = s.hasChildren() ? indentation + "+ " : indentation + "|-";
        if (simpleDateFormat != null) {
            Date date = new Date(s.getDate());
            String dateStr = simpleDateFormat.format(date);
            sb.append(dateStr).append(" ");
        }
        sb.append(prefix).append(s).append(Layout.LINE_SEP);
        if (s.getThrowable() != null) {
            StatusPrinter.appendThrowable(sb, s.getThrowable());
        }
        if (s.hasChildren()) {
            Iterator<Status> ite = s.iterator();
            while (ite.hasNext()) {
                Status child = ite.next();
                StatusPrinter.buildStr(sb, indentation + "  ", child);
            }
        }
    }
}

