/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNRevisionProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNAddParameters;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNWCClient
extends SVNBasicClient {
    public static ISVNAddParameters DEFAULT_ADD_PARAMETERS = new ISVNAddParameters(){

        public ISVNAddParameters.Action onInconsistentEOLs(File file) {
            return ISVNAddParameters.REPORT_ERROR;
        }
    };
    private ISVNAddParameters myAddParameters;

    public SVNWCClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNWCClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setAddParameters(ISVNAddParameters addParameters) {
        this.myAddParameters = addParameters;
    }

    protected ISVNAddParameters getAddParameters() {
        if (this.myAddParameters == null) {
            return DEFAULT_ADD_PARAMETERS;
        }
        return this.myAddParameters;
    }

    public void doGetFileContents(File path, SVNRevision pegRevision, SVNRevision revision, boolean expandKeywords, OutputStream dst) throws SVNException {
        if (dst == null) {
            return;
        }
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.BASE;
        } else if (revision == SVNRevision.COMMITTED) {
            revision = SVNRevision.BASE;
        }
        if (!(pegRevision.isValid() && pegRevision != SVNRevision.BASE && pegRevision != SVNRevision.WORKING || revision.isValid() && revision != SVNRevision.BASE && revision != SVNRevision.WORKING)) {
            if (pegRevision == null || !pegRevision.isValid()) {
                pegRevision = SVNRevision.BASE;
            } else if (pegRevision == SVNRevision.COMMITTED) {
                pegRevision = SVNRevision.BASE;
            }
            this.doGetLocalFileContents(path, dst, revision, expandKeywords);
        } else {
            SVNRepository repos = this.createRepository(null, path, pegRevision, revision);
            this.checkCancelled();
            long revNumber = this.getRevisionNumber(revision, repos, path);
            SVNNodeKind kind = repos.checkPath("", revNumber);
            if (kind == SVNNodeKind.DIR) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "URL ''{0}'' refers to a directory", repos.getLocation());
                SVNErrorManager.error(err);
            }
            this.checkCancelled();
            if (!expandKeywords) {
                repos.getFile("", revNumber, null, new SVNCancellableOutputStream(dst, this));
            } else {
                HashMap properties = new HashMap();
                repos.getFile("", revNumber, properties, null);
                this.checkCancelled();
                String keywords = (String)properties.get("svn:keywords");
                String eol = (String)properties.get("svn:eol-style");
                if (keywords != null || eol != null) {
                    String cmtRev = (String)properties.get("svn:entry:committed-rev");
                    String cmtDate = (String)properties.get("svn:entry:committed-date");
                    String author = (String)properties.get("svn:entry:last-author");
                    Map keywordsMap = SVNTranslator.computeKeywords(keywords, expandKeywords ? repos.getLocation().toString() : null, author, cmtDate, cmtRev, this.getOptions());
                    SVNTranslatorOutputStream translatingStream = new SVNTranslatorOutputStream(dst, SVNTranslator.getEOL(eol), false, keywordsMap, expandKeywords);
                    repos.getFile("", revNumber, null, new SVNCancellableOutputStream(translatingStream, this.getEventDispatcher()));
                    try {
                        ((OutputStream)translatingStream).close();
                    }
                    catch (IOException e) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()));
                    }
                } else {
                    repos.getFile("", revNumber, null, new SVNCancellableOutputStream(dst, this.getEventDispatcher()));
                }
            }
            try {
                dst.flush();
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()));
            }
        }
    }

    public void doGetFileContents(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean expandKeywords, OutputStream dst) throws SVNException {
        revision = revision == null || !revision.isValid() ? SVNRevision.HEAD : revision;
        SVNRepository repos = this.createRepository(url, null, pegRevision, revision);
        this.checkCancelled();
        long revNumber = this.getRevisionNumber(revision, repos, null);
        this.checkCancelled();
        SVNNodeKind nodeKind = repos.checkPath("", revNumber);
        this.checkCancelled();
        if (nodeKind == SVNNodeKind.DIR) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "URL ''{0}'' refers to a directory", url, 1);
            SVNErrorManager.error(err);
        }
        this.checkCancelled();
        if (!expandKeywords) {
            repos.getFile("", revNumber, null, new SVNCancellableOutputStream(dst, this));
        } else {
            HashMap properties = new HashMap();
            repos.getFile("", revNumber, properties, null);
            this.checkCancelled();
            String keywords = (String)properties.get("svn:keywords");
            String eol = (String)properties.get("svn:eol-style");
            if (keywords != null || eol != null) {
                String cmtRev = (String)properties.get("svn:entry:committed-rev");
                String cmtDate = (String)properties.get("svn:entry:committed-date");
                String author = (String)properties.get("svn:entry:last-author");
                Map keywordsMap = SVNTranslator.computeKeywords(keywords, expandKeywords ? repos.getLocation().toString() : null, author, cmtDate, cmtRev, this.getOptions());
                SVNTranslatorOutputStream translatingStream = new SVNTranslatorOutputStream(dst, SVNTranslator.getEOL(eol), false, keywordsMap, expandKeywords);
                repos.getFile("", revNumber, null, new SVNCancellableOutputStream(translatingStream, this.getEventDispatcher()));
                try {
                    ((OutputStream)translatingStream).close();
                }
                catch (IOException e) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()));
                }
            } else {
                repos.getFile("", revNumber, null, new SVNCancellableOutputStream(dst, this.getEventDispatcher()));
            }
        }
        try {
            dst.flush();
        }
        catch (IOException e) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()));
        }
    }

    public void doCleanup(File path) throws SVNException {
        this.doCleanup(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanup(File path, boolean deleteWCProperties) throws SVNException {
        SVNFileType fType = SVNFileType.getType(path);
        if (fType == SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' does not exist", path);
            SVNErrorManager.error(err);
        } else if (fType == SVNFileType.FILE || fType == SVNFileType.SYMLINK) {
            path = path.getParentFile();
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNAdminArea adminArea = wcAccess.open(path, true, true, 0);
            adminArea.cleanup();
            if (deleteWCProperties) {
                SVNPropertiesManager.deleteWCProperties(adminArea, null, true);
            }
        }
        catch (SVNException e) {
            if (e instanceof SVNCancelException) {
                throw e;
            }
            if (!SVNAdminArea.isSafeCleanup()) {
                throw e;
            }
            SVNDebugLog.getDefaultLog().info("CLEANUP FAILED for " + path);
            SVNDebugLog.getDefaultLog().info(e);
        }
        finally {
            wcAccess.close();
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetProperty(File path, String propName, String propValue, boolean force, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        path = path.getAbsoluteFile();
        if (SVNRevisionProperty.isRevisionProperty(propName = SVNWCClient.validatePropertyName(propName))) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", propName);
            SVNErrorManager.error(err);
        } else if (SVNProperty.isWorkingCopyProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        } else if (SVNProperty.isEntryProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is an entry property, thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        propValue = SVNWCClient.validatePropertyValue(propName, propValue, force);
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNAdminArea area = wcAccess.probeOpen(path, true, recursive ? -1 : 1);
            SVNEntry entry = wcAccess.getEntry(path, false);
            if (entry == null) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
                SVNErrorManager.error(err2);
            }
            this.doSetLocalProperty(area, entry.isDirectory() ? area.getThisDirName() : entry.getName(), propName, propValue, force, recursive, true, handler);
        }
        finally {
            wcAccess.close();
        }
    }

    public void doSetRevisionProperty(File path, SVNRevision revision, String propName, String propValue, boolean force, ISVNPropertyHandler handler) throws SVNException {
        propName = SVNWCClient.validatePropertyName(propName);
        propValue = SVNWCClient.validatePropertyValue(propName, propValue, force);
        SVNURL url = this.getURL(path);
        this.doSetRevisionProperty(url, revision, propName, propValue, force, handler);
    }

    public void doSetRevisionProperty(SVNURL url, SVNRevision revision, String propName, String propValue, boolean force, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        propName = SVNWCClient.validatePropertyName(propName);
        propValue = SVNWCClient.validatePropertyValue(propName, propValue, force);
        if (!force && "svn:author".equals(propName) && propValue != null && propValue.indexOf(10) >= 0) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_REVISION_AUTHOR_CONTAINS_NEWLINE, "Value will not be set unless forced");
            SVNErrorManager.error(err);
        }
        if (propName.startsWith("svn:wc:")) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        SVNRepository repos = this.createRepository(url, null, SVNRevision.UNDEFINED, revision);
        long revNumber = this.getRevisionNumber(revision, repos, null);
        repos.setRevisionPropertyValue(revNumber, propName, propValue);
        if (handler != null) {
            handler.handleProperty(revNumber, new SVNPropertyData(propName, propValue));
        }
    }

    public SVNPropertyData doGetProperty(final File path, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        final SVNPropertyData[] data = new SVNPropertyData[1];
        this.doGetProperty(path, propName, pegRevision, revision, recursive, new ISVNPropertyHandler(){

            public void handleProperty(File file, SVNPropertyData property) {
                if (data[0] == null && path.equals(file)) {
                    data[0] = property;
                }
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) {
            }

            public void handleProperty(long revision, SVNPropertyData property) {
            }
        });
        return data[0];
    }

    public SVNPropertyData doGetProperty(final SVNURL url, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        final SVNPropertyData[] data = new SVNPropertyData[1];
        this.doGetProperty(url, propName, pegRevision, revision, recursive, new ISVNPropertyHandler(){

            public void handleProperty(File file, SVNPropertyData property) {
            }

            public void handleProperty(long revision, SVNPropertyData property) {
            }

            public void handleProperty(SVNURL location, SVNPropertyData property) throws SVNException {
                if (data[0] == null && url.toString().equals(location.toString())) {
                    data[0] = property;
                }
            }
        });
        return data[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetProperty(File path, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        if (propName != null && propName.startsWith("svn:wc:")) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.WORKING;
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNAdminArea area = wcAccess.probeOpen(path, false, recursive ? -1 : 0);
            SVNEntry entry = wcAccess.getEntry(path, false);
            if (entry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", path);
                SVNErrorManager.error(err);
            }
            if (revision != SVNRevision.WORKING && revision != SVNRevision.BASE && revision != SVNRevision.COMMITTED) {
                SVNURL url = entry.getSVNURL();
                SVNRepository repository = this.createRepository(null, path, pegRevision, revision);
                long revisionNumber = this.getRevisionNumber(revision, repository, path);
                revision = SVNRevision.create(revisionNumber);
                this.doGetRemoteProperty(url, "", repository, propName, revision, recursive, handler);
            } else {
                boolean base;
                boolean bl = base = revision == SVNRevision.BASE;
                if (entry.getKind() == SVNNodeKind.DIR && recursive) {
                    this.doGetLocalProperty(area, propName, base, handler);
                } else {
                    SVNVersionedProperties properties;
                    if (base && entry.isScheduledForAddition() || !base && entry.isScheduledForDeletion()) {
                        return;
                    }
                    SVNVersionedProperties sVNVersionedProperties = properties = base ? area.getBaseProperties(entry.getName()) : area.getProperties(entry.getName());
                    if (propName != null) {
                        String propValue = properties.getPropertyValue(propName);
                        if (propValue != null) {
                            handler.handleProperty(path, new SVNPropertyData(propName, propValue));
                        }
                    } else {
                        Map allProps = properties.asMap();
                        Iterator names = allProps.keySet().iterator();
                        while (names.hasNext()) {
                            String name = (String)names.next();
                            String val = (String)allProps.get(name);
                            handler.handleProperty(area.getFile(entry.getName()), new SVNPropertyData(name, val));
                        }
                    }
                }
            }
        }
        finally {
            wcAccess.close();
        }
    }

    public void doGetProperty(SVNURL url, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        if (propName != null && propName.startsWith("svn:wc:")) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.HEAD;
        }
        SVNRepository repos = this.createRepository(url, null, pegRevision, revision);
        this.doGetRemoteProperty(url, "", repos, propName, revision, recursive, handler);
    }

    public void doGetRevisionProperty(File path, String propName, SVNRevision revision, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (propName != null && propName.startsWith("svn:wc:")) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        if (!revision.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error(err);
        }
        SVNRepository repository = this.createRepository(null, path, SVNRevision.UNDEFINED, revision);
        long revisionNumber = this.getRevisionNumber(revision, repository, path);
        this.doGetRevisionProperty(repository, propName, revisionNumber, handler);
    }

    public void doGetRevisionProperty(SVNURL url, String propName, SVNRevision revision, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (propName != null && propName.startsWith("svn:wc:")) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop , thus not accessible to clients", propName);
            SVNErrorManager.error(err);
        }
        if (!revision.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error(err);
        }
        SVNRepository repos = this.createRepository(url, true);
        long revNumber = this.getRevisionNumber(revision, repos, null);
        this.doGetRevisionProperty(repos, propName, revNumber, handler);
    }

    private void doGetRevisionProperty(SVNRepository repos, String propName, long revNumber, ISVNPropertyHandler handler) throws SVNException {
        if (propName != null) {
            String value = repos.getRevisionPropertyValue(revNumber, propName);
            if (value != null) {
                handler.handleProperty(revNumber, new SVNPropertyData(propName, value));
            }
        } else {
            HashMap props = new HashMap();
            repos.getRevisionProperties(revNumber, props);
            Iterator names = props.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                String value = (String)props.get(name);
                handler.handleProperty(revNumber, new SVNPropertyData(name, value));
            }
        }
    }

    public void doDelete(File path, boolean force, boolean dryRun) throws SVNException {
        this.doDelete(path, force, true, dryRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(File path, boolean force, boolean deleteFiles, boolean dryRun) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        path = new File(SVNPathUtil.validateFilePath(path.getAbsolutePath())).getAbsoluteFile();
        try {
            if (!force) {
                SVNWCManager.canDelete(path, this.getOptions(), this);
            }
            SVNAdminArea root = wcAccess.open(path.getParentFile(), true, 0);
            if (!dryRun) {
                SVNWCManager.delete(wcAccess, root, path, deleteFiles, true);
            }
        }
        finally {
            wcAccess.close();
        }
    }

    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, boolean recursive) throws SVNException {
        this.doAdd(path, force, mkdir, climbUnversionedParents, recursive, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, boolean recursive, boolean includeIgnored) throws SVNException {
        SVNWCAccess wcAccess;
        block24: {
            path = new File(SVNPathUtil.validateFilePath(path.getAbsolutePath()));
            if (!mkdir && climbUnversionedParents && path.getParentFile() != null) {
                wcAccess = this.createWCAccess();
                try {
                    wcAccess.open(path.getParentFile(), false, 0);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                        this.doAdd(path.getParentFile(), false, false, climbUnversionedParents, false);
                        break block24;
                    }
                    throw e;
                }
                finally {
                    wcAccess.close();
                }
            }
        }
        if (force && mkdir && SVNFileType.getType(path) == SVNFileType.DIRECTORY) {
            this.doAdd(path, force, false, true, false, true);
            return;
        }
        if (mkdir) {
            File parent;
            File firstCreated = path;
            for (parent = path; parent != null && SVNFileType.getType(parent) == SVNFileType.NONE; parent = parent.getParentFile()) {
                firstCreated = parent;
            }
            boolean created = path.mkdirs();
            if (!created) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create new directory ''{0}''", path);
                while (parent == null ? path != null : !path.equals(parent)) {
                    SVNFileUtil.deleteAll(path, true);
                    path = path.getParentFile();
                }
                SVNErrorManager.error(err);
            }
            try {
                this.doAdd(firstCreated, false, false, climbUnversionedParents, true, true);
            }
            catch (SVNException e) {
                SVNFileUtil.deleteAll(firstCreated, true);
                throw e;
            }
            return;
        }
        wcAccess = this.createWCAccess();
        try {
            SVNAdminArea dir = null;
            dir = path.isDirectory() ? wcAccess.open(SVNWCUtil.isVersionedDirectory(path.getParentFile()) ? path.getParentFile() : path, true, 0) : wcAccess.open(path.getParentFile(), true, 0);
            SVNFileType fileType = SVNFileType.getType(path);
            if (fileType == SVNFileType.DIRECTORY && recursive) {
                this.addDirectory(path, dir, force, includeIgnored);
            } else if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
                this.addFile(path, fileType, dir);
            } else {
                SVNWCManager.add(path, dir, null, SVNRevision.UNDEFINED);
            }
        }
        catch (SVNException e) {
            if (!force || e.getErrorMessage().getErrorCode() != SVNErrorCode.ENTRY_EXISTS) {
                throw e;
            }
        }
        finally {
            wcAccess.close();
        }
    }

    private void addDirectory(File path, SVNAdminArea parentDir, boolean force, boolean noIgnore) throws SVNException {
        block7: {
            this.checkCancelled();
            try {
                SVNWCManager.add(path, parentDir, null, SVNRevision.UNDEFINED);
            }
            catch (SVNException e) {
                if (force && e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) break block7;
                throw e;
            }
        }
        SVNWCAccess access = parentDir.getWCAccess();
        SVNAdminArea dir = access.retrieve(path);
        Collection ignores = Collections.EMPTY_SET;
        if (!noIgnore) {
            ignores = SVNStatusEditor.getIgnorePatterns(dir, SVNStatusEditor.getGlobalIgnores(this.getOptions()));
        }
        File[] children = SVNFileListUtil.listFiles(dir.getRoot());
        for (int i = 0; children != null && i < children.length; ++i) {
            this.checkCancelled();
            if (SVNFileUtil.getAdminDirectoryName().equals(children[i].getName()) || !noIgnore && SVNStatusEditor.isIgnored(ignores, children[i].getName())) continue;
            SVNFileType childType = SVNFileType.getType(children[i]);
            if (childType == SVNFileType.DIRECTORY) {
                this.addDirectory(children[i], dir, force, noIgnore);
                continue;
            }
            if (childType == SVNFileType.UNKNOWN) continue;
            try {
                this.addFile(children[i], childType, dir);
                continue;
            }
            catch (SVNException e) {
                if (force && e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) continue;
                throw e;
            }
        }
    }

    private void addFile(File path, SVNFileType type, SVNAdminArea dir) throws SVNException {
        ISVNEventHandler handler = dir.getWCAccess().getEventHandler();
        dir.getWCAccess().setEventHandler(null);
        SVNWCManager.add(path, dir, null, SVNRevision.UNDEFINED);
        dir.getWCAccess().setEventHandler(handler);
        String mimeType = null;
        if (type == SVNFileType.SYMLINK) {
            SVNPropertiesManager.setProperty(dir.getWCAccess(), path, "svn:special", SVNProperty.getValueOfBooleanProperty("svn:special"), false);
        } else {
            Map props = SVNPropertiesManager.computeAutoProperties(this.getOptions(), path);
            Iterator names = props.keySet().iterator();
            while (names.hasNext()) {
                String propName = (String)names.next();
                String propValue = (String)props.get(propName);
                try {
                    SVNPropertiesManager.setProperty(dir.getWCAccess(), path, propName, propValue, false);
                }
                catch (SVNException e) {
                    if ("svn:eol-style".equals(propName) && e.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET && e.getErrorMessage().getMessage().indexOf("newlines") >= 0) {
                        ISVNAddParameters.Action action = this.getAddParameters().onInconsistentEOLs(path);
                        if (action == ISVNAddParameters.REPORT_ERROR) {
                            throw e;
                        }
                        if (action == ISVNAddParameters.ADD_AS_IS) {
                            SVNPropertiesManager.setProperty(dir.getWCAccess(), path, propName, null, false);
                            continue;
                        }
                        if (action != ISVNAddParameters.ADD_AS_BINARY) continue;
                        SVNPropertiesManager.setProperty(dir.getWCAccess(), path, propName, null, false);
                        mimeType = "application/octet-stream";
                        continue;
                    }
                    throw e;
                }
            }
            if (mimeType != null) {
                SVNPropertiesManager.setProperty(dir.getWCAccess(), path, "svn:mime-type", mimeType, false);
            } else {
                mimeType = (String)props.get("svn:mime-type");
            }
        }
        SVNEvent event = SVNEventFactory.createAddedEvent(dir, path.getName(), SVNNodeKind.FILE, mimeType);
        this.dispatchEvent(event);
    }

    public void doRevert(File path, boolean recursive) throws SVNException {
        this.doRevert(new File[]{path}, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRevert(File[] paths, boolean recursive) throws SVNException {
        boolean reverted = false;
        try {
            for (int i = 0; i < paths.length; ++i) {
                File path = paths[i];
                path = new File(SVNPathUtil.validateFilePath(path.getAbsolutePath()));
                SVNWCAccess wcAccess = this.createWCAccess();
                try {
                    SVNAdminAreaInfo info = wcAccess.openAnchor(path, true, recursive ? -1 : 0);
                    SVNEntry entry = wcAccess.getEntry(path, false);
                    if (entry != null && entry.isDirectory() && entry.isScheduledForAddition() && !recursive) {
                        this.getDebugLog().info("Forcing revert on path '" + path + "' to recurse");
                        recursive = true;
                        wcAccess.close();
                        info = wcAccess.openAnchor(path, true, -1);
                    }
                    boolean useCommitTimes = this.getOptions().isUseCommitTimes();
                    reverted |= this.doRevert(path, info.getAnchor(), recursive, useCommitTimes);
                    continue;
                }
                catch (SVNException e) {
                    reverted |= true;
                    SVNErrorCode code = e.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.ENTRY_NOT_FOUND || code == SVNErrorCode.UNVERSIONED_RESOURCE) {
                        SVNEvent event = SVNEventFactory.createSkipEvent(path.getParentFile(), path, SVNEventAction.SKIP, SVNEventAction.REVERT, null);
                        this.dispatchEvent(event);
                    }
                    if (paths.length != 1) continue;
                    throw e;
                }
                finally {
                    wcAccess.close();
                }
            }
        }
        finally {
            if (reverted) {
                this.sleepForTimeStamp();
            }
        }
    }

    private boolean doRevert(File path, SVNAdminArea parent, boolean recursive, boolean useCommitTimes) throws SVNException {
        SVNEntry entryInParent;
        SVNFileType fileType;
        SVNErrorMessage err;
        this.checkCancelled();
        SVNAdminArea dir = parent.getWCAccess().probeRetrieve(path);
        SVNEntry entry = dir.getWCAccess().getEntry(path, false);
        if (entry == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "Cannot revert: ''{0}'' is not under version control", path);
            SVNErrorManager.error(err);
        }
        if (entry.getKind() == SVNNodeKind.DIR && (fileType = SVNFileType.getType(path)) != SVNFileType.DIRECTORY && !entry.isScheduledForAddition()) {
            SVNEvent event = SVNEventFactory.createNotRevertedEvent(dir, entry);
            this.dispatchEvent(event);
            return false;
        }
        if (entry.getKind() != SVNNodeKind.DIR && entry.getKind() != SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot revert ''{0}'': unsupported entry node kind", path);
            SVNErrorManager.error(err);
        }
        if ((fileType = SVNFileType.getType(path)) == SVNFileType.UNKNOWN) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot revert ''{0}'': unsupported node kind in working copy", path);
            SVNErrorManager.error(err2);
        }
        boolean reverted = false;
        if (entry.isScheduledForAddition()) {
            boolean wasDeleted = false;
            if (entry.getKind() == SVNNodeKind.FILE) {
                wasDeleted = entry.isDeleted();
                parent.removeFromRevisionControl(path.getName(), false, false);
            } else if (entry.getKind() == SVNNodeKind.DIR) {
                entryInParent = parent.getEntry(path.getName(), true);
                if (entryInParent != null) {
                    wasDeleted = entryInParent.isDeleted();
                }
                if (fileType == SVNFileType.NONE) {
                    parent.deleteEntry(path.getName());
                    parent.saveEntries(false);
                } else {
                    dir.removeFromRevisionControl("", false, false);
                }
            }
            reverted = true;
            recursive = false;
            if (wasDeleted) {
                entryInParent = parent.getEntry(path.getName(), true);
                if (entryInParent == null) {
                    entryInParent = parent.addEntry(path.getName());
                }
                entryInParent.setKind(entry.getKind());
                entryInParent.setDeleted(true);
                parent.saveEntries(false);
            }
        } else if (entry.getSchedule() == null || entry.isScheduledForDeletion() || entry.isScheduledForReplacement()) {
            if (entry.getKind() == SVNNodeKind.FILE) {
                reverted = this.revert(parent, entry.getName(), entry, useCommitTimes);
            } else if (entry.getKind() == SVNNodeKind.DIR) {
                boolean notScheduled = entry.getSchedule() == null;
                reverted = this.revert(dir, dir.getThisDirName(), entry, useCommitTimes);
                if (entry.isScheduledForReplacement()) {
                    recursive = true;
                }
                if (reverted && parent != dir) {
                    entryInParent = parent.getEntry(path.getName(), false);
                    this.revert(parent, path.getName(), entryInParent, useCommitTimes);
                    parent.saveEntries(false);
                } else if (notScheduled && parent != dir && (entryInParent = parent.getEntry(path.getName(), false)).getSchedule() != null) {
                    entryInParent.setSchedule(null);
                    parent.saveEntries(false);
                }
            }
        }
        if (reverted) {
            SVNEvent event = SVNEventFactory.createRevertedEvent(dir, entry);
            this.dispatchEvent(event);
        }
        if (recursive && entry.getKind() == SVNNodeKind.DIR) {
            Iterator entries = dir.entries(false);
            while (entries.hasNext()) {
                SVNEntry childEntry = (SVNEntry)entries.next();
                if (dir.getThisDirName().equals(childEntry.getName())) continue;
                File childPath = new File(path, childEntry.getName());
                reverted |= this.doRevert(childPath, dir, true, useCommitTimes);
            }
        }
        return reverted;
    }

    private boolean revert(SVNAdminArea dir, String name, SVNEntry entry, boolean useCommitTime) throws SVNException {
        SVNLog log = dir.getLog();
        boolean reverted = false;
        boolean revertBase = false;
        SVNVersionedProperties baseProperties = null;
        HashMap<String, String> command = new HashMap<String, String>();
        if (entry.isScheduledForReplacement()) {
            String propRevertPath = SVNAdminUtil.getPropRevertPath(name, entry.getKind(), false);
            File propRevertFile = dir.getFile(propRevertPath);
            revertBase = true;
            if (!propRevertFile.isFile()) {
                propRevertPath = SVNAdminUtil.getPropBasePath(name, entry.getKind(), false);
                revertBase = false;
            }
            if (dir.getFile(propRevertPath).isFile()) {
                SVNVersionedProperties sVNVersionedProperties = baseProperties = revertBase ? dir.getRevertProperties(name) : dir.getBaseProperties(name);
                if (revertBase) {
                    command.put("name", propRevertPath);
                    log.addCommand("rm", command, false);
                    command.clear();
                }
                reverted = true;
            }
        }
        boolean reinstallWorkingFile = false;
        if (baseProperties == null && dir.hasPropModifications(name)) {
            baseProperties = dir.getBaseProperties(name);
            SVNVersionedProperties propDiff = dir.getProperties(name).compareTo(baseProperties);
            Collection propNames = propDiff.getPropertyNames(null);
            boolean bl = reinstallWorkingFile = propNames.contains("svn:executable") || propNames.contains("svn:keywords") || propNames.contains("svn:eol-style") || propNames.contains("svn:special") || propNames.contains("svn:needs-lock");
        }
        if (baseProperties != null) {
            Map newProperties = baseProperties.asMap();
            SVNVersionedProperties originalBaseProperties = dir.getBaseProperties(name);
            SVNVersionedProperties workProperties = dir.getProperties(name);
            if (revertBase) {
                originalBaseProperties.removeAll();
            }
            workProperties.removeAll();
            Iterator names = newProperties.keySet().iterator();
            while (names.hasNext()) {
                String propName = (String)names.next();
                if (revertBase) {
                    originalBaseProperties.setPropertyValue(propName, (String)newProperties.get(propName));
                }
                workProperties.setPropertyValue(propName, (String)newProperties.get(propName));
            }
            dir.saveVersionedProperties(log, false);
            reverted = true;
        }
        HashMap<String, String> newEntryProperties = new HashMap<String, String>();
        if (entry.isScheduledForReplacement() && entry.isCopied()) {
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:copied"), null);
            reverted = true;
        }
        if (entry.getKind() == SVNNodeKind.FILE) {
            File revertFile;
            String basePath;
            SVNFileType fileType;
            if (!reinstallWorkingFile && (fileType = SVNFileType.getType(dir.getFile(name))) == SVNFileType.NONE) {
                reinstallWorkingFile = true;
            }
            if (!dir.getFile(basePath = SVNAdminUtil.getTextBasePath(name, false)).isFile()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error restoring text for ''{0}''", dir.getFile(name));
                SVNErrorManager.error(err);
            }
            if ((revertFile = dir.getFile(SVNAdminUtil.getTextRevertPath(name, false))).isFile()) {
                command.put("name", SVNAdminUtil.getTextRevertPath(name, false));
                command.put("dest", SVNAdminUtil.getTextBasePath(name, false));
                log.addCommand("mv", command, false);
                command.clear();
                reinstallWorkingFile = true;
            }
            if (!reinstallWorkingFile) {
                reinstallWorkingFile = dir.hasTextModifications(name, false, false, false);
            }
            if (reinstallWorkingFile) {
                command.put("name", SVNAdminUtil.getTextBasePath(name, false));
                command.put("dest", name);
                log.addCommand("cp-and-translate", command, false);
                command.clear();
                if (useCommitTime && entry.getCommittedDate() != null) {
                    command.put("name", name);
                    command.put("timestamp", entry.getCommittedDate());
                    log.addCommand("set-timestamp", command, false);
                    command.clear();
                } else {
                    command.put("name", name);
                    command.put("timestamp", SVNTimeUtil.formatDate(new Date(System.currentTimeMillis())));
                    log.addCommand("set-timestamp", command, false);
                    command.clear();
                }
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
                log.addCommand("modify-entry", command, false);
                command.clear();
            }
            reverted |= reinstallWorkingFile;
        }
        if (entry.getConflictNew() != null) {
            command.put("name", entry.getConflictNew());
            log.addCommand("rm", command, false);
            command.clear();
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-new"), null);
            if (!reverted) {
                reverted |= dir.getFile(entry.getConflictNew()).exists();
            }
        }
        if (entry.getConflictOld() != null) {
            command.put("name", entry.getConflictOld());
            log.addCommand("rm", command, false);
            command.clear();
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-old"), null);
            if (!reverted) {
                reverted |= dir.getFile(entry.getConflictOld()).exists();
            }
        }
        if (entry.getConflictWorking() != null) {
            command.put("name", entry.getConflictWorking());
            log.addCommand("rm", command, false);
            command.clear();
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), null);
            if (!reverted) {
                reverted |= dir.getFile(entry.getConflictWorking()).exists();
            }
        }
        if (entry.getPropRejectFile() != null) {
            command.put("name", entry.getPropRejectFile());
            log.addCommand("rm", command, false);
            command.clear();
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:prop-reject-file"), null);
            if (!reverted) {
                reverted |= dir.getFile(entry.getPropRejectFile()).exists();
            }
        }
        if (entry.getSchedule() != null) {
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:schedule"), null);
            reverted = true;
        }
        if (!newEntryProperties.isEmpty()) {
            newEntryProperties.put("name", name);
            log.addCommand("modify-entry", newEntryProperties, false);
        }
        log.save();
        dir.runLogs();
        return reverted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResolve(File path, boolean recursive) throws SVNException {
        path = path.getAbsoluteFile();
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            wcAccess.probeOpen(path, true, recursive ? -1 : 0);
            if (!recursive) {
                SVNEntry entry = wcAccess.getEntry(path, false);
                if (entry == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", path);
                    SVNErrorManager.error(err);
                }
                this.resolveEntry(wcAccess, path, entry);
            } else {
                this.resolveAll(wcAccess, path);
            }
        }
        finally {
            wcAccess.close();
        }
    }

    private void resolveEntry(SVNWCAccess wcAccess, File path, SVNEntry entry) throws SVNException {
        SVNAdminArea dir;
        if (entry.getKind() == SVNNodeKind.DIR && !"".equals(entry.getName())) {
            return;
        }
        File dirPath = path;
        if (entry.getKind() == SVNNodeKind.FILE) {
            dirPath = path.getParentFile();
        }
        if ((dir = wcAccess.retrieve(dirPath)).markResolved(entry.getName(), true, true)) {
            SVNEvent event = SVNEventFactory.createResolvedEvent(null, dir, entry);
            this.dispatchEvent(event);
        }
    }

    private void resolveAll(SVNWCAccess access, File path) throws SVNException {
        this.checkCancelled();
        SVNEntry entry = access.getEntry(path, false);
        this.resolveEntry(access, path, entry);
        if (entry.isDirectory()) {
            SVNAdminArea dir = access.retrieve(path);
            Iterator ents = dir.entries(false);
            while (ents.hasNext()) {
                SVNEntry childEntry = (SVNEntry)ents.next();
                if (dir.getThisDirName().equals(childEntry.getName())) continue;
                this.resolveAll(access, dir.getFile(childEntry.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLock(File[] paths, boolean stealLock, String lockMessage) throws SVNException {
        final HashMap entriesMap = new HashMap();
        HashMap pathsRevisionsMap = new HashMap();
        final SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNURL topURL = this.collectLockInfo(wcAccess, paths, entriesMap, pathsRevisionsMap, true, stealLock);
            SVNRepository repository = this.createRepository(topURL, true);
            final SVNURL rootURL = repository.getRepositoryRoot(true);
            repository.lock(pathsRevisionsMap, lockMessage, stealLock, new ISVNLockHandler(){

                public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                    SVNURL fullURL = rootURL.appendPath(path, false);
                    LockInfo lockInfo = (LockInfo)entriesMap.get(fullURL);
                    SVNAdminArea dir = wcAccess.probeRetrieve(lockInfo.myFile);
                    if (error == null) {
                        SVNEntry entry = wcAccess.getEntry(lockInfo.myFile, false);
                        if (entry == null) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", lockInfo.myFile);
                            SVNErrorManager.error(err);
                        }
                        entry.setLockToken(lock.getID());
                        entry.setLockComment(lock.getComment());
                        entry.setLockOwner(lock.getOwner());
                        entry.setLockCreationDate(SVNTimeUtil.formatDate(lock.getCreationDate()));
                        SVNVersionedProperties props = dir.getProperties(entry.getName());
                        if (props.getPropertyValue("svn:needs-lock") != null) {
                            SVNFileUtil.setReadonly(dir.getFile(entry.getName()), false);
                        }
                        SVNFileUtil.setExecutable(dir.getFile(entry.getName()), props.getPropertyValue("svn:executable") != null);
                        dir.saveEntries(false);
                        SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(dir, entry.getName(), SVNEventAction.LOCKED, lock, null), -1.0);
                    } else {
                        SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(dir, lockInfo.myFile.getName(), SVNEventAction.LOCK_FAILED, lock, error), -1.0);
                    }
                }

                public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) {
                }
            });
        }
        finally {
            wcAccess.close();
        }
    }

    public void doLock(SVNURL[] urls, boolean stealLock, String lockMessage) throws SVNException {
        HashSet<String> paths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        HashMap<String, Object> pathsToRevisions = new HashMap<String, Object>();
        Iterator p = paths.iterator();
        while (p.hasNext()) {
            String path = (String)p.next();
            path = SVNEncodingUtil.uriDecode(path);
            pathsToRevisions.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.createRepository(topURL, true);
        repository.lock(pathsToRevisions, lockMessage, stealLock, new ISVNLockHandler(){

            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                if (error != null) {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(null, path, SVNEventAction.LOCK_FAILED, lock, error), -1.0);
                } else {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(null, path, SVNEventAction.LOCKED, lock, null), -1.0);
                }
            }

            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnlock(File[] paths, boolean breakLock) throws SVNException {
        final HashMap entriesMap = new HashMap();
        HashMap pathsTokensMap = new HashMap();
        final SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNURL topURL = this.collectLockInfo(wcAccess, paths, entriesMap, pathsTokensMap, false, breakLock);
            this.checkCancelled();
            SVNRepository repository = this.createRepository(topURL, true);
            final SVNURL rootURL = repository.getRepositoryRoot(true);
            repository.unlock(pathsTokensMap, breakLock, new ISVNLockHandler(){

                public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                }

                public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                    SVNURL fullURL = rootURL.appendPath(path, false);
                    LockInfo lockInfo = (LockInfo)entriesMap.get(fullURL);
                    SVNEventAction action = null;
                    SVNAdminArea dir = wcAccess.probeRetrieve(lockInfo.myFile);
                    if (error == null || error != null && error.getErrorCode() != SVNErrorCode.FS_LOCK_OWNER_MISMATCH) {
                        SVNEntry entry = wcAccess.getEntry(lockInfo.myFile, false);
                        if (entry == null) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", lockInfo.myFile);
                            SVNErrorManager.error(err);
                        }
                        entry.setLockToken(null);
                        entry.setLockComment(null);
                        entry.setLockOwner(null);
                        entry.setLockCreationDate(null);
                        SVNVersionedProperties props = dir.getProperties(entry.getName());
                        if (props.getPropertyValue("svn:needs-lock") != null) {
                            SVNFileUtil.setReadonly(dir.getFile(entry.getName()), true);
                        }
                        dir.saveEntries(false);
                        action = SVNEventAction.UNLOCKED;
                    }
                    if (error != null) {
                        action = SVNEventAction.UNLOCK_FAILED;
                    }
                    if (action != null) {
                        SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(dir, lockInfo.myFile.getName(), action, lock, error), -1.0);
                    }
                }
            });
        }
        finally {
            wcAccess.close();
        }
    }

    public void doUnlock(SVNURL[] urls, boolean breakLock) throws SVNException {
        HashSet<String> paths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        Map<String, Object> pathsToTokens = new HashMap<String, Object>();
        Iterator p = paths.iterator();
        while (p.hasNext()) {
            String path = (String)p.next();
            path = SVNEncodingUtil.uriDecode(path);
            pathsToTokens.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.createRepository(topURL, true);
        if (!breakLock) {
            pathsToTokens = this.fetchLockTokens(repository, pathsToTokens);
        }
        repository.unlock(pathsToTokens, breakLock, new ISVNLockHandler(){

            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            }

            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                if (error != null) {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(null, path, SVNEventAction.UNLOCK_FAILED, null, error), -1.0);
                } else {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(null, path, SVNEventAction.UNLOCKED, null, null), -1.0);
                }
            }
        });
    }

    private SVNURL collectLockInfo(SVNWCAccess wcAccess, File[] files, Map lockInfo, Map lockPaths, boolean lock, boolean stealLock) throws SVNException {
        SVNErrorMessage err;
        int i;
        String[] paths = new String[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            paths[i2] = files[i2].getAbsolutePath();
            paths[i2] = paths[i2].replace(File.separatorChar, '/');
        }
        ArrayList<String> condencedPaths = new ArrayList<String>();
        String commonParentPath = SVNPathUtil.condencePaths(paths, condencedPaths, false);
        if (condencedPaths.isEmpty()) {
            condencedPaths.add(SVNPathUtil.tail(commonParentPath));
            commonParentPath = SVNPathUtil.removeTail(commonParentPath);
        }
        if (commonParentPath == null || "".equals(commonParentPath)) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "No common parent found, unable to operate on dijoint arguments");
            SVNErrorManager.error(err2);
        }
        paths = condencedPaths.toArray(new String[condencedPaths.size()]);
        int depth = 0;
        for (i = 0; i < paths.length; ++i) {
            int segments = SVNPathUtil.getSegmentsCount(paths[i]);
            if (depth >= segments) continue;
            depth = segments;
        }
        wcAccess.probeOpen(new File(commonParentPath).getAbsoluteFile(), true, depth);
        for (i = 0; i < paths.length; ++i) {
            File file = new File(commonParentPath, paths[i]);
            SVNEntry entry = wcAccess.getEntry(file, false);
            if (entry == null) {
                err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", file.getName());
                SVNErrorManager.error(err);
            }
            if (entry.getURL() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", file);
                SVNErrorManager.error(err);
            }
            if (lock) {
                SVNRevision revision = stealLock ? SVNRevision.UNDEFINED : SVNRevision.create(entry.getRevision());
                lockInfo.put(entry.getSVNURL(), new LockInfo(file, revision));
                continue;
            }
            if (!stealLock && entry.getLockToken() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked in this working copy", file);
                SVNErrorManager.error(err);
            }
            lockInfo.put(entry.getSVNURL(), new LockInfo(file, entry.getLockToken()));
        }
        this.checkCancelled();
        SVNURL[] urls = lockInfo.keySet().toArray(new SVNURL[lockInfo.size()]);
        HashSet<String> urlPaths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, urlPaths, false);
        if (urlPaths.isEmpty()) {
            urlPaths.add("");
        }
        if (topURL == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unable to lock/unlock across multiple repositories");
            SVNErrorManager.error(err);
        }
        Iterator encodedPaths = urlPaths.iterator();
        while (encodedPaths.hasNext()) {
            String encodedPath = (String)encodedPaths.next();
            SVNURL fullURL = topURL.appendPath(encodedPath, true);
            LockInfo info = (LockInfo)lockInfo.get(fullURL);
            encodedPath = SVNEncodingUtil.uriDecode(encodedPath);
            if (lock) {
                if (info.myRevision == SVNRevision.UNDEFINED) {
                    lockPaths.put(encodedPath, null);
                    continue;
                }
                lockPaths.put(encodedPath, new Long(info.myRevision.getNumber()));
                continue;
            }
            lockPaths.put(encodedPath, info.myToken);
        }
        return topURL;
    }

    public void doInfo(File path, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(path, SVNRevision.UNDEFINED, revision, recursive, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInfo(File path, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        boolean local;
        path = path.getAbsoluteFile();
        if (handler == null) {
            return;
        }
        boolean bl = local = !(revision != null && revision.isValid() && !revision.isLocal() || pegRevision != null && pegRevision.isValid() && !pegRevision.isLocal());
        if (!local) {
            SVNWCAccess wcAccess = this.createWCAccess();
            SVNRevision wcRevision = null;
            SVNURL url = null;
            try {
                SVNErrorMessage err;
                wcAccess.probeOpen(path, false, 0);
                SVNEntry entry = wcAccess.getEntry(path, false);
                if (entry == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path);
                    SVNErrorManager.error(err);
                }
                if ((url = entry.getSVNURL()) == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path);
                    SVNErrorManager.error(err);
                }
                wcRevision = SVNRevision.create(entry.getRevision());
            }
            finally {
                wcAccess.close();
            }
            this.doInfo(url, pegRevision == null || !pegRevision.isValid() || pegRevision.isLocal() ? wcRevision : pegRevision, revision, recursive, handler);
            return;
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            wcAccess.probeOpen(path, false, recursive ? -1 : 0);
            SVNEntry entry = wcAccess.getEntry(path, false);
            if (entry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "Cannot read entry for ''{0}''", path);
                SVNErrorManager.error(err);
            }
            if (entry.isFile()) {
                this.reportEntry(path, entry, handler);
            } else if (entry.isDirectory()) {
                if (recursive) {
                    this.reportAllEntries(wcAccess, path, handler);
                } else {
                    this.reportEntry(path, entry, handler);
                }
            }
        }
        finally {
            wcAccess.close();
        }
    }

    private void reportEntry(File path, SVNEntry entry, ISVNInfoHandler handler) throws SVNException {
        if (entry.isDirectory() && !"".equals(entry.getName())) {
            return;
        }
        handler.handleInfo(SVNInfo.createInfo(path, entry));
    }

    private void reportAllEntries(SVNWCAccess wcAccess, File path, ISVNInfoHandler handler) throws SVNException {
        SVNEntry entry = wcAccess.getEntry(path, false);
        this.reportEntry(path, entry, handler);
        if (entry.isDirectory()) {
            SVNAdminArea dir = wcAccess.retrieve(path);
            Iterator entries = dir.entries(false);
            while (entries.hasNext()) {
                SVNEntry childEntry = (SVNEntry)entries.next();
                if (dir.getThisDirName().equals(childEntry.getName())) continue;
                File childPath = dir.getFile(childEntry.getName());
                if (childEntry.isDirectory()) {
                    this.reportAllEntries(wcAccess, childPath, handler);
                }
                this.reportEntry(childPath, childEntry, handler);
            }
        }
    }

    public void doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        String fullPath;
        String rootPath;
        HashMap<String, SVNLock> locksMap;
        String reposUUID;
        SVNURL reposRoot;
        SVNDirEntry rootEntry;
        long revNum;
        SVNRepository repos;
        block22: {
            if (revision == null || !revision.isValid()) {
                revision = SVNRevision.HEAD;
            }
            if (pegRevision == null || !pegRevision.isValid()) {
                pegRevision = revision;
            }
            repos = this.createRepository(url, null, pegRevision, revision);
            url = repos.getLocation();
            revNum = this.getRevisionNumber(revision, repos, null);
            rootEntry = null;
            try {
                rootEntry = repos.info("", revNum);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                    if (repos.getLocation().equals(repos.getRepositoryRoot(true))) {
                        rootEntry = new SVNDirEntry(url, "", SVNNodeKind.DIR, -1L, false, -1L, null, null);
                    } else {
                        String name = SVNPathUtil.tail(url.getPath());
                        SVNURL location = repos.getLocation();
                        repos.setLocation(location.removePathTail(), false);
                        Collection dirEntries = repos.getDir("", revNum, null, (Collection)null);
                        Iterator ents = dirEntries.iterator();
                        while (ents.hasNext()) {
                            SVNDirEntry dirEntry = (SVNDirEntry)ents.next();
                            if (!name.equals(dirEntry.getName())) continue;
                            rootEntry = dirEntry;
                            break;
                        }
                        repos.setLocation(location, false);
                    }
                }
                throw e;
            }
            if (rootEntry == null || rootEntry.getKind() == SVNNodeKind.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision ''{1}''", new Object[]{url, new Long(revNum)});
                SVNErrorManager.error(err);
            }
            reposRoot = repos.getRepositoryRoot(true);
            reposUUID = repos.getRepositoryUUID(true);
            SVNLock[] locks = null;
            if (pegRevision == SVNRevision.HEAD && rootEntry.getKind() == SVNNodeKind.DIR) {
                try {
                    locks = repos.getLocks("");
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                        locks = new SVNLock[]{};
                    }
                    throw e;
                }
            }
            locks = locks == null ? new SVNLock[]{} : locks;
            locksMap = new HashMap<String, SVNLock>();
            for (int i = 0; i < locks.length; ++i) {
                SVNLock lock = locks[i];
                locksMap.put(lock.getPath(), lock);
            }
            if (rootEntry.getKind() == SVNNodeKind.FILE) {
                try {
                    SVNURL headURL;
                    SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(url, null, null, revision, SVNRevision.HEAD, SVNRevision.UNDEFINED);
                    if (locations == null || locations.length <= 0 || !(headURL = locations[0].getURL()).equals(url)) break block22;
                    try {
                        SVNLock lock = repos.getLock("");
                        if (lock != null) {
                            locksMap.put(lock.getPath(), lock);
                        }
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage() == null || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                            throw e;
                        }
                    }
                }
                catch (SVNException e) {
                    SVNErrorCode code = e.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block22;
                    throw e;
                }
            }
        }
        if (!(rootPath = (fullPath = url.getPath()).substring(reposRoot.getPath().length())).startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        this.collectInfo(repos, rootEntry, SVNRevision.create(revNum), rootPath, reposRoot, reposUUID, url, locksMap, recursive, handler);
    }

    public String doGetWorkingCopyID(File path, String trailURL) throws SVNException {
        return this.doGetWorkingCopyID(path, trailURL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetWorkingCopyID(final File path, String trailURL, final boolean committed) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            wcAccess.open(path, false, 0);
        }
        catch (SVNException e) {
            SVNFileType pathType = SVNFileType.getType(path);
            if (pathType == SVNFileType.DIRECTORY) {
                String string = "exported";
                return string;
            }
            if (pathType == SVNFileType.NONE) {
                String string = null;
                return string;
            }
            String string = "'" + path + "' is not versioned and not exported";
            return string;
        }
        finally {
            wcAccess.close();
        }
        SVNStatusClient statusClient = new SVNStatusClient((ISVNAuthenticationManager)null, this.getOptions());
        statusClient.setIgnoreExternals(true);
        final long[] maxRevision = new long[1];
        final long[] minRevision = new long[]{-1L};
        final boolean[] switched = new boolean[2];
        final String[] wcURL = new String[1];
        statusClient.doStatus(path, true, false, true, false, false, new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                if (status.getEntryProperties() == null || status.getEntryProperties().isEmpty()) {
                    return;
                }
                if (status.getContentsStatus() != SVNStatusType.STATUS_ADDED) {
                    SVNRevision revision;
                    SVNRevision sVNRevision = revision = committed ? status.getCommittedRevision() : status.getRevision();
                    if (revision != null) {
                        if (minRevision[0] < 0L || minRevision[0] > revision.getNumber()) {
                            minRevision[0] = revision.getNumber();
                        }
                        maxRevision[0] = Math.max(maxRevision[0], revision.getNumber());
                    }
                }
                switched[0] = switched[0] | status.isSwitched();
                switched[1] = switched[1] | status.getContentsStatus() != SVNStatusType.STATUS_NORMAL;
                switched[1] = switched[1] | (status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL && status.getPropertiesStatus() != SVNStatusType.STATUS_NONE);
                if (wcURL[0] == null && status.getFile() != null && status.getFile().equals(path) && status.getURL() != null) {
                    wcURL[0] = status.getURL().toString();
                }
            }
        });
        if (!switched[0] && trailURL != null) {
            switched[0] = wcURL[0] == null ? true : !wcURL[0].endsWith(trailURL);
        }
        StringBuffer id = new StringBuffer();
        id.append(minRevision[0]);
        if (minRevision[0] != maxRevision[0]) {
            id.append(":").append(maxRevision[0]);
        }
        if (switched[1]) {
            id.append("M");
        }
        if (switched[0]) {
            id.append("S");
        }
        return id.toString();
    }

    public SVNInfo doInfo(File path, SVNRevision revision) throws SVNException {
        final SVNInfo[] result = new SVNInfo[1];
        this.doInfo(path, revision, false, new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) {
                if (result[0] == null) {
                    result[0] = info;
                }
            }
        });
        return result[0];
    }

    public SVNInfo doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        final SVNInfo[] result = new SVNInfo[1];
        this.doInfo(url, pegRevision, revision, false, new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) {
                if (result[0] == null) {
                    result[0] = info;
                }
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanupWCProperties(File directory) throws SVNException {
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(this);
        try {
            SVNAdminArea dir = wcAccess.open(directory, true, true, -1);
            if (dir != null) {
                SVNPropertiesManager.deleteWCProperties(dir, null, true);
            }
        }
        finally {
            wcAccess.close();
        }
    }

    private void collectInfo(SVNRepository repos, SVNDirEntry entry, SVNRevision rev, String path, SVNURL root, String uuid, SVNURL url, Map locks, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.checkCancelled();
        String displayPath = repos.getFullPath(path);
        displayPath = displayPath.substring(repos.getLocation().getPath().length());
        if ("".equals(displayPath) || "/".equals(displayPath)) {
            displayPath = path;
        }
        handler.handleInfo(SVNInfo.createInfo(displayPath, root, uuid, url, rev, entry, (SVNLock)locks.get(path)));
        if (entry.getKind() == SVNNodeKind.DIR && recursive) {
            Collection children = repos.getDir(path, rev.getNumber(), null, new ArrayList());
            Iterator ents = children.iterator();
            while (ents.hasNext()) {
                SVNDirEntry child = (SVNDirEntry)ents.next();
                SVNURL childURL = url.appendPath(child.getName(), false);
                this.collectInfo(repos, child, rev, SVNPathUtil.append(path, child.getName()), root, uuid, childURL, locks, recursive, handler);
            }
        }
    }

    private void doGetRemoteProperty(SVNURL url, String path, SVNRepository repos, String propName, SVNRevision rev, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        block7: {
            HashMap props;
            block8: {
                SVNNodeKind kind;
                long revNumber;
                block6: {
                    this.checkCancelled();
                    revNumber = this.getRevisionNumber(rev, repos, null);
                    kind = repos.checkPath(path, revNumber);
                    props = new HashMap();
                    if (kind != SVNNodeKind.DIR) break block6;
                    Collection children = repos.getDir(path, revNumber, props, (Collection)(recursive ? new ArrayList() : null));
                    if (propName != null) {
                        String value = (String)props.get(propName);
                        if (value != null) {
                            handler.handleProperty(url, new SVNPropertyData(propName, value));
                        }
                    } else {
                        Iterator names = props.keySet().iterator();
                        while (names.hasNext()) {
                            String name = (String)names.next();
                            if (name.startsWith("svn:entry:") || name.startsWith("svn:wc:")) continue;
                            String value = (String)props.get(name);
                            handler.handleProperty(url, new SVNPropertyData(name, value));
                        }
                    }
                    if (!recursive) break block7;
                    this.checkCancelled();
                    Iterator entries = children.iterator();
                    while (entries.hasNext()) {
                        SVNDirEntry child = (SVNDirEntry)entries.next();
                        SVNURL childURL = url.appendPath(child.getName(), false);
                        String childPath = "".equals(path) ? child.getName() : SVNPathUtil.append(path, child.getName());
                        this.doGetRemoteProperty(childURL, childPath, repos, propName, rev, recursive, handler);
                    }
                    break block7;
                }
                if (kind != SVNNodeKind.FILE) break block7;
                repos.getFile(path, revNumber, props, null);
                if (propName == null) break block8;
                String value = (String)props.get(propName);
                if (value == null) break block7;
                handler.handleProperty(url, new SVNPropertyData(propName, value));
                break block7;
            }
            Iterator names = props.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (name.startsWith("svn:entry:") || name.startsWith("svn:wc:")) continue;
                String value = (String)props.get(name);
                handler.handleProperty(url, new SVNPropertyData(name, value));
            }
        }
    }

    private void doGetLocalProperty(SVNAdminArea area, String propName, boolean base, ISVNPropertyHandler handler) throws SVNException {
        SVNEntry entry;
        this.checkCancelled();
        Iterator entries = area.entries(false);
        while (entries.hasNext()) {
            SVNVersionedProperties properties;
            entry = (SVNEntry)entries.next();
            if (entry.getKind() == SVNNodeKind.DIR && !"".equals(entry.getName()) || base && entry.isScheduledForAddition() || !base && entry.isScheduledForDeletion()) continue;
            SVNVersionedProperties sVNVersionedProperties = properties = base ? area.getBaseProperties(entry.getName()) : area.getProperties(entry.getName());
            if (propName != null) {
                String propVal = properties.getPropertyValue(propName);
                if (propVal == null) continue;
                handler.handleProperty(area.getFile(entry.getName()), new SVNPropertyData(propName, propVal));
                continue;
            }
            Map allProps = properties.asMap();
            Iterator names = allProps.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                String val = (String)allProps.get(name);
                handler.handleProperty(area.getFile(entry.getName()), new SVNPropertyData(name, val));
            }
        }
        entries = area.entries(false);
        while (entries.hasNext()) {
            entry = (SVNEntry)entries.next();
            if (entry.getKind() != SVNNodeKind.DIR || "".equals(entry.getName())) continue;
            SVNAdminArea childArea = null;
            try {
                childArea = area.getWCAccess().retrieve(area.getFile(entry.getName()));
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) continue;
                throw e;
            }
            if (childArea == null) continue;
            this.doGetLocalProperty(childArea, propName, base, handler);
        }
    }

    private void doSetLocalProperty(SVNAdminArea anchor, String name, String propName, String propValue, boolean force, boolean recursive, boolean cancel, ISVNPropertyHandler handler) throws SVNException {
        if (cancel) {
            this.checkCancelled();
        }
        if (!"".equals(name)) {
            SVNEntry entry = anchor.getEntry(name, true);
            if (entry == null || recursive && entry.isDeleted()) {
                return;
            }
            if (entry.getKind() == SVNNodeKind.DIR) {
                File path = anchor.getFile(name);
                SVNAdminArea dir = anchor.getWCAccess().retrieve(path);
                if (dir != null) {
                    this.doSetLocalProperty(dir, "", propName, propValue, force, recursive, cancel, handler);
                }
            } else if (entry.getKind() == SVNNodeKind.FILE) {
                String oldValue;
                File wcFile = anchor.getFile(name);
                if (("svn:ignore".equals(propName) || "svn:externals".equals(propName)) && propValue != null) {
                    if (!recursive) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a file (''{1}'')", new Object[]{propName, wcFile});
                        SVNErrorManager.error(err);
                    }
                    return;
                }
                SVNVersionedProperties props = anchor.getProperties(name);
                if ("svn:executable".equals(propName)) {
                    SVNFileUtil.setExecutable(wcFile, propValue != null);
                }
                if (!force && "svn:eol-style".equals(propName) && propValue != null) {
                    if (SVNProperty.isBinaryMimeType(props.getPropertyValue("svn:mime-type"))) {
                        if (!recursive) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has binary mime type property", wcFile);
                            SVNErrorManager.error(err);
                        }
                        return;
                    }
                    if (!SVNTranslator.checkNewLines(wcFile)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has incosistent newlines", wcFile);
                        SVNErrorManager.error(err);
                    }
                }
                boolean modified = (oldValue = props.getPropertyValue(propName)) == null ? propValue != null : !oldValue.equals(propValue);
                props.setPropertyValue(propName, propValue);
                if ("svn:eol-style".equals(propName) || "svn:keywords".equals(propName)) {
                    entry.setTextTime(null);
                } else if ("svn:needs-lock".equals(propName) && propValue == null) {
                    SVNFileUtil.setReadonly(wcFile, false);
                }
                if (modified && handler != null) {
                    handler.handleProperty(anchor.getFile(name), new SVNPropertyData(propName, propValue));
                }
            }
            SVNLog log = anchor.getLog();
            anchor.saveVersionedProperties(log, true);
            anchor.saveEntries(false);
            log.save();
            anchor.runLogs();
            return;
        }
        SVNVersionedProperties props = anchor.getProperties(name);
        if (("svn:keywords".equals(propName) || "svn:eol-style".equals(propName) || "svn:mime-type".equals(propName) || "svn:executable".equals(propName)) && propValue != null) {
            if (!recursive) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a directory (''{1}'')", new Object[]{propName, anchor.getRoot()});
                SVNErrorManager.error(err);
            }
        } else {
            String oldValue = props.getPropertyValue(propName);
            boolean modified = oldValue == null ? propValue != null : !oldValue.equals(propValue);
            props.setPropertyValue(propName, propValue);
            SVNLog log = anchor.getLog();
            anchor.saveVersionedProperties(log, true);
            log.save();
            anchor.runLogs();
            if (modified && handler != null) {
                handler.handleProperty(anchor.getFile(name), new SVNPropertyData(propName, propValue));
            }
        }
        if (!recursive) {
            return;
        }
        Iterator ents = anchor.entries(true);
        while (ents.hasNext()) {
            SVNEntry entry = (SVNEntry)ents.next();
            if ("".equals(entry.getName())) continue;
            this.doSetLocalProperty(anchor, entry.getName(), propName, propValue, force, recursive, cancel, handler);
        }
    }

    private static String validatePropertyName(String name) throws SVNException {
        if (name == null || name.trim().length() == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property name is empty");
            SVNErrorManager.error(err);
            return name;
        }
        if (!Character.isLetter((name = name.trim()).charAt(0)) && name.charAt(0) != ':' && name.charAt(0) != '_') {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", name);
            SVNErrorManager.error(err);
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '-' || name.charAt(i) == '.' || name.charAt(i) == ':' || name.charAt(i) == '_') continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", name);
            SVNErrorManager.error(err);
        }
        return name;
    }

    private static String validatePropertyValue(String name, String value, boolean force) throws SVNException {
        if (value == null) {
            return value;
        }
        if (SVNProperty.isSVNProperty(name)) {
            value = value.replaceAll("\r\n", "\n");
            value = value.replace('\r', '\n');
        }
        if (!force && "svn:eol-style".equals(name)) {
            if (SVNTranslator.getEOL(value = value.trim()) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL, "Unrecognized line ending style ''{0}''", value);
                SVNErrorManager.error(err);
            }
        } else if (!force && "svn:mime-type".equals(name)) {
            value = value.trim();
        } else if ("svn:ignore".equals(name) || "svn:externals".equals(name)) {
            if (!value.endsWith("\n")) {
                value = value + "\n";
            }
            if ("svn:externals".equals(name)) {
                SVNExternalInfo[] externalInfos = SVNWCAccess.parseExternals("", value);
                for (int i = 0; externalInfos != null && i < externalInfos.length; ++i) {
                    String path = externalInfos[i].getPath();
                    SVNExternalInfo.checkPath(path);
                }
            }
        } else if ("svn:keywords".equals(name)) {
            value = value.trim();
        } else if ("svn:executable".equals(name) || "svn:special".equals(name) || "svn:needs-lock".equals(name)) {
            value = "*";
        }
        return value;
    }

    private Map fetchLockTokens(SVNRepository repository, Map pathsTokensMap) throws SVNException {
        HashMap<String, String> tokens = new HashMap<String, String>();
        Iterator paths = pathsTokensMap.keySet().iterator();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            SVNLock lock = repository.getLock(path);
            if (lock == null || lock.getID() == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked", path);
                SVNErrorManager.error(err);
                continue;
            }
            tokens.put(path, lock.getID());
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetLocalFileContents(File path, OutputStream dst, SVNRevision revision, boolean expandKeywords) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        InputStream input = null;
        boolean hasMods = false;
        SVNVersionedProperties properties = null;
        try {
            SVNErrorMessage err;
            SVNAdminArea area = wcAccess.open(path.getParentFile(), false, 0);
            SVNEntry entry = wcAccess.getEntry(path, false);
            if (entry == null) {
                err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control or doesn''t exist", path, 1);
                SVNErrorManager.error(err);
            } else if (entry.getKind() != SVNNodeKind.FILE) {
                err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' refers to a directory", path, 1);
                SVNErrorManager.error(err);
            }
            String name = path.getName();
            if (revision != SVNRevision.WORKING) {
                input = area.getBaseFileForReading(name, false);
                properties = area.getBaseProperties(name);
            } else {
                input = SVNFileUtil.openFileForReading(area.getFile(path.getName()));
                hasMods = area.hasPropModifications(name) || area.hasTextModifications(name, true);
                properties = area.getProperties(name);
            }
            String eolStyle = properties.getPropertyValue("svn:eol-style");
            String keywords = properties.getPropertyValue("svn:keywords");
            boolean special = properties.getPropertyValue("svn:special") != null;
            byte[] eols = null;
            Map keywordsMap = null;
            String time = null;
            if (eolStyle != null) {
                eols = SVNTranslator.getEOL(eolStyle);
            }
            time = hasMods && !special ? SVNTimeUtil.formatDate(new Date(path.lastModified())) : entry.getCommittedDate();
            if (keywords != null) {
                String url = entry.getURL();
                String author = hasMods ? "(local)" : entry.getAuthor();
                String rev = hasMods ? entry.getCommittedRevision() + "M" : entry.getCommittedRevision() + "";
                keywordsMap = SVNTranslator.computeKeywords(keywords, expandKeywords ? url : null, author, time, rev, this.getOptions());
            }
            OutputStream translatingStream = eols != null || keywordsMap != null ? new SVNTranslatorOutputStream(dst, eols, false, keywordsMap, expandKeywords) : dst;
            try {
                SVNTranslator.copy(input, new SVNCancellableOutputStream(translatingStream, this.getEventDispatcher()));
                if (translatingStream != dst) {
                    SVNFileUtil.closeFile(translatingStream);
                }
                dst.flush();
            }
            catch (IOException e) {
                if (e instanceof SVNCancellableOutputStream.IOCancelException) {
                    SVNErrorManager.cancel(e.getMessage());
                }
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(input);
            wcAccess.close();
            throw throwable;
        }
        SVNFileUtil.closeFile(input);
        wcAccess.close();
    }

    private static class LockInfo {
        private File myFile;
        private SVNRevision myRevision;
        private String myToken;

        public LockInfo(File file, SVNRevision rev) {
            this.myFile = file;
            this.myRevision = rev;
        }

        public LockInfo(File file, String token) {
            this.myFile = file;
            this.myToken = token;
        }
    }
}

