/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.File;
import org.tmatesoft.svn.core.internal.util.jna.ISVNCLibrary;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

class SVNLinuxUtil {
    private static Memory ourSharedMemory;

    SVNLinuxUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNFileType getFileType(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? cLibrary.lstat(path, (Pointer)ourSharedMemory) : cLibrary.__lxstat64(0, path, (Pointer)ourSharedMemory);
                }
                if (rc < 0) {
                    if (file.exists() || file.isDirectory() || file.isFile()) {
                        return null;
                    }
                    return SVNFileType.NONE;
                }
                int mode = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? ourSharedMemory.getShort(8L) : ourSharedMemory.getInt(16L);
                int type = mode & 0xF000;
                if (type == 40960) {
                    return SVNFileType.SYMLINK;
                }
                if (type == 16384) {
                    return SVNFileType.DIRECTORY;
                }
                if (type == 32768) {
                    return SVNFileType.FILE;
                }
                if (file.exists() || file.isDirectory() || file.isFile()) {
                    return null;
                }
                return SVNFileType.NONE;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isExecutable(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? cLibrary.lstat(path, (Pointer)ourSharedMemory) : cLibrary.__lxstat64(0, path, (Pointer)ourSharedMemory);
                }
                if (rc < 0) {
                    return null;
                }
                int mode = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? ourSharedMemory.getInt(8L) : ourSharedMemory.getInt(16L);
                int fuid = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? ourSharedMemory.getInt(16L) : ourSharedMemory.getInt(24L);
                int fgid = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? ourSharedMemory.getInt(20L) : ourSharedMemory.getInt(28L);
                int access = mode & 0x1FF;
                int mask = 73;
                mask = JNALibraryLoader.getUID() == fuid ? 64 : (JNALibraryLoader.getGID() == fgid ? 8 : 1);
                return (access & mask) != 0;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinkTarget(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = cLibrary.readlink(path, (Pointer)ourSharedMemory, 1024);
                }
                if (rc <= 0) {
                    return null;
                }
                byte[] buffer = new byte[rc];
                ourSharedMemory.read(0L, buffer, 0, rc);
                return new String(buffer, 0, rc);
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setExecutable(File file, boolean set) {
        if (file == null || ourSharedMemory == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return false;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? cLibrary.lstat(path, (Pointer)ourSharedMemory) : cLibrary.__lxstat64(0, path, (Pointer)ourSharedMemory);
                }
                if (rc < 0) {
                    return false;
                }
                int mode = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? ourSharedMemory.getInt(8L) : ourSharedMemory.getInt(16L);
                int access = mode & 0x1FF;
                int mask = 0;
                if ((access & 0x100) != 0) {
                    mask |= 0x40;
                }
                if ((access & 0x20) != 0) {
                    mask |= 8;
                }
                if ((access & 4) != 0) {
                    mask |= 1;
                }
                if (mask == 0) {
                    return false;
                }
                ISVNCLibrary iSVNCLibrary2 = cLibrary;
                synchronized (iSVNCLibrary2) {
                    rc = cLibrary.chmod(path, set ? mask | access : mask ^ access);
                }
                return rc >= 0;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setWritable(File file) {
        if (file == null || ourSharedMemory == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return false;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? cLibrary.lstat(path, (Pointer)ourSharedMemory) : cLibrary.__lxstat64(0, path, (Pointer)ourSharedMemory);
                }
                if (rc < 0) {
                    return false;
                }
                int mode = SVNFileUtil.isOSX || SVNFileUtil.isBSD ? ourSharedMemory.getInt(8L) : ourSharedMemory.getInt(16L);
                int access = mode & 0x1FF;
                int mask = 0;
                if ((access & 0x100) != 0) {
                    mask |= 0x80;
                }
                if ((access & 0x20) != 0) {
                    mask |= 0x10;
                }
                if ((access & 4) != 0) {
                    mask |= 2;
                }
                if (mask == 0) {
                    return false;
                }
                ISVNCLibrary iSVNCLibrary2 = cLibrary;
                synchronized (iSVNCLibrary2) {
                    rc = cLibrary.chmod(path, mask | access);
                }
                return rc >= 0;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSymlink(File file, String linkName) {
        if (file == null || linkName == null || ourSharedMemory == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            int rc;
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return false;
            }
            ISVNCLibrary iSVNCLibrary = cLibrary;
            synchronized (iSVNCLibrary) {
                rc = cLibrary.symlink(linkName, path);
            }
            return rc >= 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static {
        try {
            ourSharedMemory = new Memory(1024L);
        }
        catch (Throwable th) {
            ourSharedMemory = null;
        }
    }
}

