/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;

class HTTPParser {
    HTTPParser() {
    }

    public static HTTPStatus parseStatus(InputStream is, String charset) throws IOException, ParseException {
        String line = null;
        int limit = 100;
        do {
            if (limit < 0) {
                line = null;
                break;
            }
            line = HTTPParser.readLine(is, charset);
            --limit;
        } while (line != null && (line.length() == 0 || line.trim().length() == 0 || !HTTPStatus.isHTTPStatusLine(line)));
        if (line == null) {
            throw new ParseException("can not read HTTP status line", 0);
        }
        return HTTPStatus.createHTTPStatus(line);
    }

    public static String readLine(InputStream is, String charset) throws IOException {
        byte[] bytes = HTTPParser.readPlainLine(is);
        if (bytes == null) {
            return null;
        }
        int length = bytes.length;
        if (length > 0 && bytes[length - 1] == 10 && --length > 0 && bytes[length - 1] == 13) {
            --length;
        }
        return new String(bytes, 0, length, charset);
    }

    public static byte[] readPlainLine(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((ch = is.read()) >= 0) {
            buf.write(ch);
            if (ch != 10) continue;
        }
        if (buf.size() == 0) {
            return null;
        }
        return buf.toByteArray();
    }

    public static StringBuffer getCanonicalPath(String path, StringBuffer target) {
        StringBuffer stringBuffer = target = target == null ? new StringBuffer() : target;
        if (path.startsWith("http:") || path.startsWith("https:")) {
            target.append(path);
            return target;
        }
        int end = path.length() - 1;
        block3: for (int i = 0; i <= end; ++i) {
            char ch = path.charAt(i);
            switch (ch) {
                case '/': {
                    if (i == end && i != 0 || i > 0 && path.charAt(i - 1) == '/') continue block3;
                }
                default: {
                    target.append(ch);
                }
            }
        }
        return target;
    }
}

