/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Date;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.xml.sax.Attributes;

public class DAVDateRevisionHandler
extends BasicDAVHandler {
    private long myRevisionNumber;

    public static StringBuffer generateDateRevisionRequest(StringBuffer body, Date date) {
        body = body == null ? new StringBuffer() : body;
        body.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        body.append("<S:dated-rev-report xmlns:S=\"svn:\" ");
        body.append("xmlns:D=\"DAV:\">");
        body.append("<D:creationdate>");
        SVNTimeUtil.formatDate(date, body);
        body.append("</D:creationdate>");
        body.append("</S:dated-rev-report>");
        return body;
    }

    public DAVDateRevisionHandler() {
        this.init();
        this.myRevisionNumber = -1L;
    }

    public long getRevisionNumber() {
        return this.myRevisionNumber;
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) {
        if (element == DAVElement.VERSION_NAME && cdata != null) {
            this.myRevisionNumber = Long.parseLong(cdata.toString());
        }
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) {
    }
}

