/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn;

import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Saml2LoginContext
extends LoginContext
implements Serializable {
    private static final long serialVersionUID = -7117092606828289070L;
    private String relayState;
    private String serialAuthnRequest;

    public Saml2LoginContext(String relyingParty, String state, AuthnRequest request) throws MarshallingException {
        if (relyingParty == null || request == null) {
            throw new IllegalArgumentException("SAML 2 authentication request and relying party ID may not be null");
        }
        this.setRelyingParty(relyingParty);
        this.relayState = state;
        this.serialAuthnRequest = this.serializeRequest(request);
        this.setForceAuthRequired(request.isForceAuthn());
        this.setPassiveAuthRequired(request.isPassive());
        this.getRequestedAuthenticationMethods().addAll(this.extractRequestedAuthenticationMethods(request));
    }

    public synchronized String getAuthenticationRequest() throws UnmarshallingException {
        return this.serialAuthnRequest;
    }

    public synchronized String getRelayState() {
        return this.relayState;
    }

    protected String serializeRequest(AuthnRequest request) throws MarshallingException {
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)request);
        Element requestElem = marshaller.marshall((XMLObject)request);
        StringWriter writer = new StringWriter();
        XMLHelper.writeNode((Node)requestElem, (Writer)writer);
        return writer.toString();
    }

    protected List<String> extractRequestedAuthenticationMethods(AuthnRequest request) {
        List authnDeclRefs;
        ArrayList<String> requestedMethods = new ArrayList<String>();
        RequestedAuthnContext authnContext = request.getRequestedAuthnContext();
        if (authnContext == null) {
            return requestedMethods;
        }
        AuthnContextComparisonTypeEnumeration comparator = authnContext.getComparison();
        if (comparator != null && comparator != AuthnContextComparisonTypeEnumeration.EXACT) {
            Logger log = LoggerFactory.getLogger(Saml2LoginContext.class);
            log.error("Unsupported comparision operator ( " + comparator + ") in RequestedAuthnContext. Only exact comparisions are supported.");
            return requestedMethods;
        }
        List authnClasses = authnContext.getAuthnContextClassRefs();
        if (authnClasses != null) {
            for (AuthnContextClassRef classRef : authnClasses) {
                if (classRef == null || DatatypeHelper.isEmpty((String)classRef.getAuthnContextClassRef())) continue;
                requestedMethods.add(classRef.getAuthnContextClassRef());
            }
        }
        if ((authnDeclRefs = authnContext.getAuthnContextDeclRefs()) != null) {
            for (AuthnContextDeclRef declRef : authnDeclRefs) {
                if (declRef == null || DatatypeHelper.isEmpty((String)declRef.getAuthnContextDeclRef())) continue;
                requestedMethods.add(declRef.getAuthnContextDeclRef());
            }
        }
        if (requestedMethods.contains("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified")) {
            requestedMethods.clear();
        }
        return requestedMethods;
    }
}

