/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.relyingparty.saml;

import edu.internet2.middleware.shibboleth.common.config.relyingparty.saml.AbstractSAMLProfileConfigurationBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.CryptoOperationRequirementLevel;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractSAML2ProfileConfigurationBeanDefinitionParser
extends AbstractSAMLProfileConfigurationBeanDefinitionParser {
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        List proxyAudiences = XMLHelper.getChildElementsByTagNameNS((Element)element, (String)"urn:mace:shibboleth:2.0:relying-party:saml", (String)"ProxyAudience");
        if (proxyAudiences != null && proxyAudiences.size() > 0) {
            ArrayList<String> audiences = new ArrayList<String>();
            for (Element proxyAudience : proxyAudiences) {
                audiences.add(DatatypeHelper.safeTrimOrNullString((String)proxyAudience.getTextContent()));
            }
            builder.addPropertyValue("proxyAudiences", audiences);
        }
        builder.addPropertyReference("attributeAuthority", DatatypeHelper.safeTrimOrNullString((String)element.getAttributeNS(null, "attributeAuthority")));
        if (element.hasAttributeNS(null, "encryptNameIds")) {
            builder.addPropertyValue("encryptNameIds", (Object)CryptoOperationRequirementLevel.valueOf(element.getAttributeNS(null, "encryptNameIds")));
        } else {
            builder.addPropertyValue("encryptNameIds", (Object)CryptoOperationRequirementLevel.never);
        }
        if (element.hasAttributeNS(null, "encryptAssertions")) {
            builder.addPropertyValue("encryptAssertions", (Object)CryptoOperationRequirementLevel.valueOf(element.getAttributeNS(null, "encryptAssertions")));
        } else {
            builder.addPropertyValue("encryptAssertions", (Object)CryptoOperationRequirementLevel.conditional);
        }
        if (element.hasAttributeNS(null, "assertionProxyCount")) {
            builder.addPropertyValue("assertionProxyCount", (Object)Integer.parseInt(DatatypeHelper.safeTrimOrNullString((String)element.getAttributeNS(null, "assertionProxyCount"))));
        } else {
            builder.addPropertyValue("assertionProxyCount", (Object)0);
        }
    }
}

