/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorFactoryBean;
import java.util.Map;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDataConnectorFactoryBean
extends BaseDataConnectorFactoryBean {
    private TemplateEngine templateEngine;
    private String ldapURL;
    private String baseDN;
    private String principal;
    private String principalCredential;
    private LdapDataConnector.AUTHENTICATION_TYPE authenticationType;
    private String filterTemplate;
    private LdapDataConnector.SEARCH_SCOPE searchScope;
    private String[] returnAttributes;
    private Map<String, String> ldapProperties;
    private boolean useStartTLS;
    private X509Credential trustCredential;
    private X509Credential connectionCredential;
    private int poolInitialSize;
    private int poolMaxIdle;
    private int searchTimeLimit;
    private int maxResultSize;
    private boolean cacheResults;
    private boolean mergeResults;
    private boolean noResultsIsError;

    protected Object createInstance() throws Exception {
        LdapDataConnector connector = new LdapDataConnector(this.ldapURL, this.baseDN, this.useStartTLS, this.poolInitialSize, this.poolMaxIdle);
        this.populateDataConnector(connector);
        connector.setAuthenticationType(this.authenticationType);
        connector.setPrincipal(this.principal);
        connector.setPrincipalCredential(this.principalCredential);
        connector.setLdapProperties(this.ldapProperties);
        if (this.trustCredential != null) {
            connector.setSslTrustManagers(this.trustCredential);
        }
        if (this.connectionCredential != null) {
            connector.setSslKeyManagers(this.connectionCredential);
        }
        connector.setCacheResults(this.cacheResults);
        connector.setFilterTemplate(this.filterTemplate);
        connector.setMaxResultSize(this.maxResultSize);
        connector.setMergeResults(this.mergeResults);
        connector.setNoResultsIsError(this.noResultsIsError);
        connector.setReturnAttributes(this.returnAttributes);
        connector.setSearchScope(this.searchScope);
        connector.setSearchTimeLimit(this.searchTimeLimit);
        connector.setTemplateEngine(this.templateEngine);
        connector.initialize();
        return connector;
    }

    public LdapDataConnector.AUTHENTICATION_TYPE getAuthenticationType() {
        return this.authenticationType;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public X509Credential getConnectionCredential() {
        return this.connectionCredential;
    }

    public String getFilterTemplate() {
        return this.filterTemplate;
    }

    public Map<String, String> getLdapProperties() {
        return this.ldapProperties;
    }

    public String getLdapUrl() {
        return this.ldapURL;
    }

    public int getMaxResultSize() {
        return this.maxResultSize;
    }

    public Class getObjectType() {
        return LdapDataConnector.class;
    }

    public int getPoolInitialSize() {
        return this.poolInitialSize;
    }

    public int getPoolMaxIdleSize() {
        return this.poolMaxIdle;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPrincipalCredential() {
        return this.principalCredential;
    }

    public String[] getReturnAttributes() {
        return this.returnAttributes;
    }

    public LdapDataConnector.SEARCH_SCOPE getSearchScope() {
        return this.searchScope;
    }

    public int getSearchTimeLimit() {
        return this.searchTimeLimit;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public X509Credential getTrustCredential() {
        return this.trustCredential;
    }

    public boolean getUseStartTLS() {
        return this.useStartTLS;
    }

    public boolean isCacheResults() {
        return this.cacheResults;
    }

    public boolean isMergeResults() {
        return this.mergeResults;
    }

    public boolean isNoResultsIsError() {
        return this.noResultsIsError;
    }

    public void setAuthenticationType(LdapDataConnector.AUTHENTICATION_TYPE type) {
        this.authenticationType = type;
    }

    public void setBaseDN(String dn) {
        this.baseDN = DatatypeHelper.safeTrimOrNullString((String)dn);
    }

    public void setCacheResults(boolean cache) {
        this.cacheResults = cache;
    }

    public void setConnectionCredential(X509Credential credential) {
        this.connectionCredential = credential;
    }

    public void setFilterTemplate(String template) {
        this.filterTemplate = DatatypeHelper.safeTrimOrNullString((String)template);
    }

    public void setLdapProperties(Map<String, String> properties) {
        this.ldapProperties = properties;
    }

    public void setLdapUrl(String url) {
        this.ldapURL = DatatypeHelper.safeTrimOrNullString((String)url);
    }

    public void setMaxResultSize(int max) {
        this.maxResultSize = max;
    }

    public void setMergeResults(boolean merge) {
        this.mergeResults = merge;
    }

    public void setNoResultsIsError(boolean isError) {
        this.noResultsIsError = isError;
    }

    public void setPoolInitialSize(int initialSize) {
        this.poolInitialSize = initialSize;
    }

    public void setPoolMaxIdleSize(int maxIdle) {
        this.poolMaxIdle = maxIdle;
    }

    public void setPrincipal(String principalName) {
        this.principal = DatatypeHelper.safeTrimOrNullString((String)principalName);
    }

    public void setPrincipalCredential(String credential) {
        this.principalCredential = DatatypeHelper.safeTrimOrNullString((String)credential);
    }

    public void setReturnAttributes(String[] attributes) {
        this.returnAttributes = attributes;
    }

    public void setSearchScope(LdapDataConnector.SEARCH_SCOPE scope) {
        this.searchScope = scope;
    }

    public void setSearchTimeLimit(int timeLimit) {
        this.searchTimeLimit = timeLimit;
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.templateEngine = engine;
    }

    public void setTrustCredential(X509Credential credential) {
        this.trustCredential = credential;
    }

    public void setUseStartTLS(boolean startTLS) {
        this.useStartTLS = startTLS;
    }
}

