/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.filtering;

import edu.internet2.middleware.shibboleth.common.config.attribute.filtering.AttributeFilterPolicyGroupBeanDefinitionParser;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.impl.RandomIdentifierGenerator;
import org.opensaml.xml.util.DatatypeHelper;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class BaseFilterBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static IdentifierGenerator idGen = new RandomIdentifierGenerator();

    protected String resolveId(Element configElement, AbstractBeanDefinition beanDefinition, ParserContext parserContext) {
        return this.getQualifiedId(configElement, configElement.getLocalName(), configElement.getAttributeNS(null, "id"));
    }

    protected String getQualifiedId(Element configElement, String componentNamespace, String localId) {
        Element afpgElement = configElement.getOwnerDocument().getDocumentElement();
        String policyGroupId = DatatypeHelper.safeTrimOrNullString((String)afpgElement.getAttributeNS(null, "id"));
        StringBuilder qualifiedId = new StringBuilder();
        qualifiedId.append("/");
        qualifiedId.append(AttributeFilterPolicyGroupBeanDefinitionParser.ELEMENT_NAME.getLocalPart());
        qualifiedId.append(":");
        qualifiedId.append(policyGroupId);
        if (!DatatypeHelper.isEmpty((String)componentNamespace)) {
            qualifiedId.append("/");
            qualifiedId.append(componentNamespace);
            qualifiedId.append(":");
            if (DatatypeHelper.isEmpty((String)localId)) {
                qualifiedId.append(idGen.generateIdentifier());
            } else {
                qualifiedId.append(localId);
            }
        }
        return qualifiedId.toString();
    }

    protected String getAbsoluteReference(Element configElement, String componentNamespace, String reference) {
        if (reference.startsWith("/")) {
            return reference;
        }
        return this.getQualifiedId(configElement, componentNamespace, reference);
    }
}

