/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.RDBMSColumnDescriptor;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import edu.internet2.middleware.shibboleth.common.session.LogoutEvent;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDBMSDataConnector
extends BaseDataConnector
implements ApplicationListener {
    private final Logger log = LoggerFactory.getLogger(RDBMSDataConnector.class);
    private boolean initialized = false;
    private DataSource dataSource;
    private boolean readOnlyConnection;
    private boolean usesStoredProcedure;
    private boolean noResultIsError;
    private boolean cacheResults;
    private String queryTemplateName;
    private String queryTemplate;
    private Map<String, RDBMSColumnDescriptor> columnDescriptors;
    private Map<String, Map<String, SoftReference<Map<String, BaseAttribute>>>> resultsCache;
    private TemplateEngine queryCreator;

    public RDBMSDataConnector(DataSource source, boolean resultCaching) {
        this.dataSource = source;
        this.cacheResults = resultCaching;
        this.usesStoredProcedure = false;
        this.columnDescriptors = new HashMap<String, RDBMSColumnDescriptor>();
    }

    public void initialize() {
        this.registerTemplate();
        if (this.cacheResults) {
            this.resultsCache = new HashMap<String, Map<String, SoftReference<Map<String, BaseAttribute>>>>();
        }
        this.initialized = true;
    }

    public boolean isConnectionReadOnly() {
        return this.readOnlyConnection;
    }

    public void setConnectionReadOnly(boolean isReadOnly) {
        this.readOnlyConnection = isReadOnly;
    }

    public boolean getUsesStoredProcedure() {
        return this.usesStoredProcedure;
    }

    public void setUsesStoredProcedure(boolean storedProcedure) {
        this.usesStoredProcedure = storedProcedure;
    }

    public boolean isNoResultIsError() {
        return this.noResultIsError;
    }

    public void setNoResultIsError(boolean b) {
        this.noResultIsError = b;
    }

    public boolean getCacheResults() {
        return this.cacheResults;
    }

    public TemplateEngine getTemplateEngine() {
        return this.queryCreator;
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.queryCreator = engine;
        this.registerTemplate();
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public void setQueryTemplate(String template) {
        this.queryTemplate = template;
    }

    public Map<String, RDBMSColumnDescriptor> getColumnDescriptor() {
        return this.columnDescriptors;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof LogoutEvent) {
            LogoutEvent logoutEvent = (LogoutEvent)event;
            if (this.cacheResults) {
                this.resultsCache.remove(logoutEvent.getUserSession().getPrincipalName());
            }
        }
    }

    @Override
    public Map<String, BaseAttribute> resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String query = this.queryCreator.createStatement(this.queryTemplateName, resolutionContext, this.getDependencyIds(), null);
        this.log.debug("Search Query: {}", (Object)query);
        Map<String, BaseAttribute> resolvedAttributes = null;
        resolvedAttributes = this.retrieveAttributesFromCache(resolutionContext.getAttributeRequestContext().getPrincipalName(), query);
        if (resolvedAttributes == null) {
            resolvedAttributes = this.retrieveAttributesFromDatabase(query);
        }
        if (this.cacheResults) {
            Map<String, SoftReference<Map<String, BaseAttribute>>> individualCache = this.resultsCache.get(resolutionContext.getAttributeRequestContext().getPrincipalName());
            if (individualCache == null) {
                individualCache = new HashMap<String, SoftReference<Map<String, BaseAttribute>>>();
                this.resultsCache.put(resolutionContext.getAttributeRequestContext().getPrincipalName(), individualCache);
            }
            individualCache.put(query, new SoftReference<Map<String, BaseAttribute>>(resolvedAttributes));
        }
        return resolvedAttributes;
    }

    @Override
    public void validate() throws AttributeResolutionException {
        this.log.debug("Validating RDBMS data connector {} configuration.", (Object)this.getId());
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            if (connection == null) {
                this.log.error("Unable to create connections for RDBMS data connector " + this.getId());
                throw new AttributeResolutionException("Unable to create connections for RDBMS data connector " + this.getId());
            }
            DatabaseMetaData dbmd = connection.getMetaData();
            if (!dbmd.supportsStoredProcedures() && this.usesStoredProcedure) {
                this.log.error("RDBMS data connector " + this.getId() + " is configured to use stored procedures but database does not support them.");
                throw new AttributeResolutionException("RDBMS data connector " + this.getId() + " is configured to use stored procedures but database does not support them.");
            }
            this.log.debug("Validating RDBMS data connector {} configuration is valid.", (Object)this.getId());
        }
        catch (SQLException e) {
            this.log.error("Unable to validate RDBMS data connector " + this.getId() + " configuration", (Throwable)e);
            throw new AttributeResolutionException("Unable to validate RDBMS data connector " + this.getId() + " configuration", e);
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection", (Throwable)e);
            }
        }
    }

    public void clearCache() {
        if (this.initialized && this.cacheResults) {
            this.resultsCache.clear();
        }
    }

    protected void registerTemplate() {
        this.queryTemplateName = "shibboleth.resolver.dc." + this.getId();
        this.queryCreator.registerTemplate(this.queryTemplateName, this.queryTemplate);
    }

    protected Map<String, BaseAttribute> retrieveAttributesFromCache(String princpal, String query) throws AttributeResolutionException {
        SoftReference<Map<String, BaseAttribute>> cachedAttributes;
        if (!this.cacheResults) {
            return null;
        }
        Map<String, SoftReference<Map<String, BaseAttribute>>> queryCache = this.resultsCache.get(princpal);
        if (queryCache != null && (cachedAttributes = queryCache.get(query)) != null) {
            this.log.debug("RDBMS Data Connector {}: Fetched attributes from cache for principal {}", (Object)this.getId(), (Object)princpal);
            return cachedAttributes.get();
        }
        return null;
    }

    protected Map<String, BaseAttribute> retrieveAttributesFromDatabase(String query) throws AttributeResolutionException {
        Connection connection = null;
        ResultSet queryResult = null;
        try {
            connection = this.dataSource.getConnection();
            if (this.readOnlyConnection) {
                connection.setReadOnly(true);
            }
            this.log.debug("RDBMS Data Connector {}: Querying database for attributes with query: {}", (Object)this.getId(), (Object)query);
            queryResult = connection.createStatement().executeQuery(query);
            Map<String, BaseAttribute> resolvedAttributes = this.processResultSet(queryResult);
            if (resolvedAttributes.isEmpty() && this.noResultIsError) {
                this.log.error("RDBMS Data Connector {}: No attribtues from query", (Object)this.getId());
                throw new AttributeResolutionException("RDBMS Data Connector " + this.getId() + ": No attributes returned from query");
            }
            this.log.debug("RDBMS Data Connector {}: Retrieved attributes: {}", (Object)this.getId(), resolvedAttributes.keySet());
            Map<String, BaseAttribute> map = resolvedAttributes;
            return map;
        }
        catch (SQLException e) {
            this.log.error("RDBMS Data Connector " + this.getId() + ": Unable to execute SQL query\n" + query, (Throwable)e);
            throw new AttributeResolutionException("RDBMS Data Connector " + this.getId() + ": Unable to execute SQL query", e);
        }
        finally {
            try {
                if (queryResult != null) {
                    queryResult.close();
                }
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.log.error("RDBMS Data Connector " + this.getId() + ": Unable to close connection to database", (Throwable)e);
            }
        }
    }

    protected Map<String, BaseAttribute> processResultSet(ResultSet resultSet) throws AttributeResolutionException {
        HashMap<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();
        try {
            if (!resultSet.next()) {
                return attributes;
            }
            ResultSetMetaData resultMD = resultSet.getMetaData();
            int numOfCols = resultMD.getColumnCount();
            do {
                for (int i = 1; i <= numOfCols; ++i) {
                    BaseAttribute attribute;
                    String columnName = resultMD.getColumnName(i);
                    RDBMSColumnDescriptor columnDescriptor = this.columnDescriptors.get(columnName);
                    if (columnDescriptor == null || columnDescriptor.getAttributeID() == null) {
                        attribute = (BasicAttribute)attributes.get(columnName);
                        if (attribute == null) {
                            attribute = new BasicAttribute(columnName);
                        }
                    } else {
                        attribute = (BaseAttribute)attributes.get(columnDescriptor.getAttributeID());
                        if (attribute == null) {
                            attribute = new BasicAttribute(columnDescriptor.getAttributeID());
                        }
                    }
                    attributes.put(((BaseAttribute)attribute).getId(), attribute);
                    Collection attributeValues = ((BaseAttribute)attribute).getValues();
                    if (columnDescriptor == null || columnDescriptor.getDataType() == null) {
                        attributeValues.add(resultSet.getObject(i));
                        continue;
                    }
                    this.addValueByType(attributeValues, columnDescriptor.getDataType(), resultSet, i);
                }
            } while (resultSet.next());
        }
        catch (SQLException e) {
            this.log.error("RDBMS Data Connector " + this.getId() + ": Unable to read data from query result set", (Throwable)e);
        }
        return attributes;
    }

    protected void addValueByType(Collection values, DATA_TYPES type, ResultSet resultSet, int columnIndex) throws SQLException {
        switch (type) {
            case BigDecimal: {
                values.add(resultSet.getBigDecimal(columnIndex));
                break;
            }
            case Boolean: {
                values.add(resultSet.getBoolean(columnIndex));
                break;
            }
            case Byte: {
                values.add(resultSet.getByte(columnIndex));
                break;
            }
            case ByteArray: {
                values.add(resultSet.getBytes(columnIndex));
                break;
            }
            case Date: {
                values.add(resultSet.getDate(columnIndex));
                break;
            }
            case Double: {
                values.add(resultSet.getDouble(columnIndex));
                break;
            }
            case Float: {
                values.add(Float.valueOf(resultSet.getFloat(columnIndex)));
                break;
            }
            case Integer: {
                values.add(resultSet.getInt(columnIndex));
                break;
            }
            case Long: {
                values.add(resultSet.getLong(columnIndex));
                break;
            }
            case Object: {
                values.add(resultSet.getObject(columnIndex));
                break;
            }
            case Short: {
                values.add(resultSet.getShort(columnIndex));
                break;
            }
            case Time: {
                values.add(resultSet.getTime(columnIndex));
                break;
            }
            case Timestamp: {
                values.add(resultSet.getTimestamp(columnIndex));
                break;
            }
            case URL: {
                values.add(resultSet.getURL(columnIndex));
                break;
            }
            default: {
                values.add(resultSet.getString(columnIndex));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DATA_TYPES {
        BigDecimal,
        Boolean,
        Byte,
        ByteArray,
        Date,
        Double,
        Float,
        Integer,
        Long,
        Object,
        Short,
        String,
        Time,
        Timestamp,
        URL;

    }
}

