/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.ValueMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedAttributeDefinition
extends BaseAttributeDefinition {
    private static Logger log = LoggerFactory.getLogger(MappedAttributeDefinition.class);
    private String defaultValue;
    private boolean passThru;
    private Collection<ValueMap> valueMaps = new ArrayList<ValueMap>();

    @Override
    protected BaseAttribute doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        BasicAttribute attribute = new BasicAttribute();
        attribute.setId(this.getId());
        for (Object o : this.getValuesFromAllDependencies(resolutionContext)) {
            boolean valueMapMatch = false;
            for (ValueMap valueMap : this.valueMaps) {
                Set<String> mappedValues = valueMap.evaluate(o.toString());
                if (mappedValues.isEmpty()) continue;
                valueMapMatch = true;
                attribute.getValues().addAll(mappedValues);
            }
            if (valueMapMatch) continue;
            if (this.passThru) {
                attribute.getValues().add(o.toString());
                continue;
            }
            if (DatatypeHelper.isEmpty((String)this.defaultValue)) continue;
            attribute.getValues().add(this.getDefaultValue());
        }
        return attribute;
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.passThru && !DatatypeHelper.isEmpty((String)this.defaultValue)) {
            log.error("MappedAttributeDefinition (" + this.getId() + ") may not have a DefaultValue string with passThru enabled.");
            throw new AttributeResolutionException("MappedAttributeDefinition (" + this.getId() + ") may not have a DefaultValue string with passThru enabled.");
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String newDefaultValue) {
        this.defaultValue = newDefaultValue;
    }

    public boolean isPassThru() {
        return this.passThru;
    }

    public void setPassThru(boolean newPassThru) {
        this.passThru = newPassThru;
    }

    public Collection<ValueMap> getValueMaps() {
        return this.valueMaps;
    }
}

