/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractMatchFunctor;

public class NumOfAttributeValuesMatchFunctor
extends AbstractMatchFunctor {
    private String attributeId;
    private int minimumValues;
    private int maximumValues;

    public NumOfAttributeValuesMatchFunctor(String id, int min, int max) {
        this.attributeId = id;
        this.minimumValues = min;
        this.maximumValues = max;
    }

    protected boolean doEvaluatePolicyRequirement(ShibbolethFilteringContext filterContext) throws FilterProcessingException {
        return this.isWithinRange(filterContext.getUnfilteredAttributes().get(this.attributeId));
    }

    protected boolean doEvaluateValue(ShibbolethFilteringContext filterContext, String id, Object value) throws FilterProcessingException {
        return this.isWithinRange(filterContext.getUnfilteredAttributes().get(this.attributeId));
    }

    protected boolean isWithinRange(BaseAttribute attribute) {
        if (attribute == null) {
            return false;
        }
        int numOfValues = attribute.getValues().size();
        return numOfValues >= this.minimumValues && numOfValues <= this.maximumValues;
    }
}

