/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.rolling.helper.AsynchronousCompressor;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.rolling.helper.TimeBasedCleaner;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedRollingPolicy<E>
extends RollingPolicyBase
implements TriggeringPolicy<E> {
    static final String FNP_NOT_SET = "The FileNamePattern option must be set before using TimeBasedRollingPolicy. ";
    static final String SEE_FNP_NOT_SET = "See also http://logback.qos.ch/codes.html#tbr_fnp_not_set";
    static final int DEFAULT_MAX_HISTORY = 0;
    RollingCalendar rc;
    long currentTime;
    long nextCheck;
    boolean isTimeForced = false;
    Date lastCheck = new Date();
    String elapsedPeriodsFileName;
    FileNamePattern activeFileNamePattern;
    RenameUtil util = new RenameUtil();
    String lastGeneratedFileName;
    Future<?> future;
    int maxHistory = 0;
    TimeBasedCleaner tbCleaner;

    public void setCurrentTime(long timeInMillis) {
        this.currentTime = timeInMillis;
        this.isTimeForced = true;
    }

    public long getCurrentTime() {
        if (this.isTimeForced) {
            return this.currentTime;
        }
        return System.currentTimeMillis();
    }

    @Override
    public void start() {
        this.util.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addWarn(FNP_NOT_SET);
            this.addWarn(SEE_FNP_NOT_SET);
            throw new IllegalStateException("The FileNamePattern option must be set before using TimeBasedRollingPolicy. See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        this.determineCompressionMode();
        DateTokenConverter dtc = this.fileNamePattern.getDateTokenConverter();
        if (dtc == null) {
            throw new IllegalStateException("FileNamePattern [" + this.fileNamePattern.getPattern() + "] does not contain a valid DateToken");
        }
        int len = this.fileNamePatternStr.length();
        switch (this.compressionMode) {
            case GZ: {
                this.activeFileNamePattern = new FileNamePattern(this.fileNamePatternStr.substring(0, len - 3), this.context);
                break;
            }
            case ZIP: {
                this.activeFileNamePattern = new FileNamePattern(this.fileNamePatternStr.substring(0, len - 4), this.context);
                break;
            }
            case NONE: {
                this.activeFileNamePattern = this.fileNamePattern;
            }
        }
        this.addInfo("Will use the pattern " + this.activeFileNamePattern + " for the active file");
        this.rc = new RollingCalendar();
        this.rc.init(dtc.getDatePattern());
        this.addInfo("The date pattern is '" + dtc.getDatePattern() + "' from file name pattern '" + this.fileNamePattern.getPattern() + "'.");
        this.rc.printPeriodicity(this);
        this.lastCheck.setTime(this.getCurrentTime());
        this.nextCheck = this.rc.getNextTriggeringMillis(this.lastCheck);
        if (this.maxHistory != 0) {
            this.tbCleaner = new TimeBasedCleaner(this.fileNamePattern, this.rc, this.maxHistory);
        }
    }

    @Override
    public void rollover() throws RolloverFailure {
        if (this.getParentFileName() == null && this.compressionMode != CompressionMode.NONE) {
            this.doCompression(false, this.elapsedPeriodsFileName, this.elapsedPeriodsFileName);
        } else if (this.compressionMode == CompressionMode.NONE) {
            this.util.rename(this.getParentFileName(), this.elapsedPeriodsFileName);
        } else {
            this.doCompression(true, this.getParentFileName(), this.elapsedPeriodsFileName);
        }
        if (this.tbCleaner != null) {
            this.tbCleaner.clean(new Date(this.getCurrentTime()));
        }
        this.setParentFileName(this.getNewActiveFileName());
    }

    void doCompression(boolean rename, String nameOfFile2Compress, String nameOfCompressedFile) throws RolloverFailure {
        Compressor compressor = null;
        if (rename) {
            String renameTarget = nameOfFile2Compress + System.nanoTime() + ".tmp";
            this.util.rename(this.getParentFileName(), renameTarget);
            nameOfFile2Compress = renameTarget;
        }
        switch (this.compressionMode) {
            case GZ: {
                this.addInfo("GZIP compressing [" + nameOfFile2Compress + "].");
                compressor = new Compressor(CompressionMode.GZ, nameOfFile2Compress, nameOfCompressedFile);
                compressor.setContext(this.context);
                break;
            }
            case ZIP: {
                this.addInfo("ZIP compressing [" + nameOfFile2Compress + "]");
                compressor = new Compressor(CompressionMode.ZIP, nameOfFile2Compress, nameOfCompressedFile);
                compressor.setContext(this.context);
            }
        }
        AsynchronousCompressor ac = new AsynchronousCompressor(compressor);
        this.future = ac.compressAsynchronously();
    }

    @Override
    public String getNewActiveFileName() {
        if (this.getParentFileName() == null || this.getParentFileName() == this.lastGeneratedFileName) {
            String newName = this.activeFileNamePattern.convertDate(this.lastCheck);
            this.addInfo("Generated a new name for RollingFileAppender: " + newName);
            this.lastGeneratedFileName = newName;
            return newName;
        }
        return this.getParentFileName();
    }

    @Override
    public boolean isTriggeringEvent(File activeFile, E event) {
        long time = this.getCurrentTime();
        if (time >= this.nextCheck) {
            this.elapsedPeriodsFileName = this.activeFileNamePattern.convertDate(this.lastCheck);
            this.lastCheck.setTime(time);
            this.nextCheck = this.rc.getNextTriggeringMillis(this.lastCheck);
            Date x = new Date();
            x.setTime(this.nextCheck);
            return true;
        }
        return false;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    public String toString() {
        return "c.q.l.core.rolling.TimeBasedRollingPolicy";
    }
}

