/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ldif.util;

import edu.vt.middleware.ldap.LdapUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Ldif
implements Serializable {
    public static final int NUL_CHAR = 0;
    public static final int LF_CHAR = 10;
    public static final int CR_CHAR = 13;
    public static final int SP_CHAR = 32;
    public static final int COLON_CHAR = 58;
    public static final int LA_CHAR = 60;
    public static final int MAX_ASCII_CHAR = 127;
    private static final long serialVersionUID = 7940338254323446707L;
    private static final Log LOG = LogFactory.getLog((Class)(class$edu$vt$middleware$ldap$ldif$util$Ldif == null ? (class$edu$vt$middleware$ldap$ldif$util$Ldif = Ldif.class$("edu.vt.middleware.ldap.ldif.util.Ldif")) : class$edu$vt$middleware$ldap$ldif$util$Ldif));
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static /* synthetic */ Class class$edu$vt$middleware$ldap$ldif$util$Ldif;

    public String createLdif(NamingEnumeration results) throws NamingException {
        return this.createLdif(LdapUtil.parseNamingEnumeration(results).iterator());
    }

    public String createLdif(Iterator results) {
        StringBuffer ldif;
        block9: {
            ldif = new StringBuffer();
            if (results != null) {
                try {
                    TreeMap<String, SearchResult> m = new TreeMap<String, SearchResult>();
                    while (results.hasNext()) {
                        try {
                            SearchResult sr = (SearchResult)results.next();
                            String dn = sr.getName();
                            m.put(dn, sr);
                        }
                        catch (ClassCastException e) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)"Could not cast item in Iterator as a SearchResult");
                        }
                    }
                    Iterator i = m.values().iterator();
                    while (i.hasNext()) {
                        try {
                            SearchResult sr = (SearchResult)i.next();
                            ldif.append(this.createLdifEntry(sr)).append(LINE_SEPARATOR);
                        }
                        catch (ClassCastException e) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)"Could not cast item in Iterator as a SearchResult");
                        }
                    }
                }
                catch (NamingException e) {
                    if (!LOG.isErrorEnabled()) break block9;
                    LOG.error((Object)"Error creating String from SearchResult", (Throwable)e);
                }
            }
        }
        return ldif.toString();
    }

    protected String createLdifEntry(SearchResult result) throws NamingException {
        StringBuffer entry = new StringBuffer();
        if (result != null) {
            String dn = result.getName();
            if (dn != null) {
                if (this.encodeData(dn)) {
                    try {
                        dn = new String(Base64.encodeBase64((byte[])dn.getBytes("UTF-8")), "UTF-8");
                        entry.append("dn:: ").append(dn).append(LINE_SEPARATOR);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)"Could not encode dn using UTF-8");
                        }
                    }
                } else {
                    entry.append("dn: ").append(dn).append(LINE_SEPARATOR);
                }
            }
            TreeMap attrs = new TreeMap(LdapUtil.parseAttributes(result.getAttributes(), false));
            Iterator attrNameIter = attrs.keySet().iterator();
            while (attrNameIter.hasNext()) {
                String attrName = (String)attrNameIter.next();
                TreeSet attrValues = new TreeSet((List)attrs.get(attrName));
                Iterator attrValueIter = attrValues.iterator();
                while (attrValueIter.hasNext()) {
                    Object attrValue = attrValueIter.next();
                    if (this.encodeData(attrValue)) {
                        try {
                            String attrValueString = (String)attrValue;
                            try {
                                attrValue = new String(Base64.encodeBase64((byte[])attrValueString.getBytes("UTF-8")), "UTF-8");
                                entry.append(attrName).append(":: ").append(attrValue).append(LINE_SEPARATOR);
                            }
                            catch (UnsupportedEncodingException e) {
                                if (!LOG.isErrorEnabled()) continue;
                                LOG.error((Object)"Could not encode attribute value using UTF-8");
                            }
                        }
                        catch (ClassCastException e1) {
                            try {
                                byte[] attrValueBytes = (byte[])attrValue;
                                try {
                                    attrValue = new String(Base64.encodeBase64((byte[])attrValueBytes), "UTF-8");
                                    entry.append(attrName).append(":: ").append(attrValue).append(LINE_SEPARATOR);
                                }
                                catch (UnsupportedEncodingException e) {
                                    if (!LOG.isErrorEnabled()) continue;
                                    LOG.error((Object)"Could not encode attribute value using UTF-8");
                                }
                            }
                            catch (ClassCastException e2) {
                                if (!LOG.isErrorEnabled()) continue;
                                LOG.error((Object)"Could not cast attribute value as a byte[] or a String");
                            }
                        }
                        continue;
                    }
                    try {
                        new URL((String)attrValue);
                        entry.append(attrName).append(":< ").append(attrValue).append(LINE_SEPARATOR);
                    }
                    catch (Exception e) {
                        entry.append(attrName).append(": ").append(attrValue).append(LINE_SEPARATOR);
                    }
                }
            }
        }
        return entry.toString();
    }

    private boolean encodeData(Object data) {
        boolean encode = false;
        try {
            String stringData = (String)data;
            char[] dataCharArray = stringData.toCharArray();
            for (int i = 0; i < dataCharArray.length; ++i) {
                char charInt = dataCharArray[i];
                if (charInt == '\u0000') {
                    encode = true;
                    continue;
                }
                if (charInt == '\n') {
                    encode = true;
                    continue;
                }
                if (charInt == '\r') {
                    encode = true;
                    continue;
                }
                if (charInt == ' ' && (i == 0 || i == dataCharArray.length - 1)) {
                    encode = true;
                    continue;
                }
                if (charInt == ':' && i == 0) {
                    encode = true;
                    continue;
                }
                if (charInt == '<' && i == 0) {
                    encode = true;
                    continue;
                }
                if (charInt <= '\u007f') continue;
                encode = true;
            }
        }
        catch (ClassCastException e) {
            encode = true;
        }
        return encode;
    }

    public void outputLdif(Iterator results, OutputStream out) throws IOException {
        this.output(this.createLdif(results), out);
    }

    public void outputLdif(NamingEnumeration results, OutputStream out) throws IOException, NamingException {
        this.output(this.createLdif(results), out);
    }

    public void output(String ldif, OutputStream out) throws IOException {
        if (ldif != null && out != null) {
            out.write(ldif.getBytes("UTF-8"));
        }
    }

    protected void doMain(String[] args) throws Exception {
        this.outputLdif(LdapUtil.runCommandline(args), (OutputStream)System.out);
    }

    public static void main(String[] args) throws Exception {
        Ldif ldif = new Ldif();
        ldif.doMain(args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

