/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.dsml.util;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapPool;
import edu.vt.middleware.ldap.dsml.util.Dsmlv1;
import edu.vt.middleware.ldap.dsml.util.Dsmlv2;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DsmlSearch {
    private static final Log LOG = LogFactory.getLog((Class)(class$edu$vt$middleware$ldap$dsml$util$DsmlSearch == null ? (class$edu$vt$middleware$ldap$dsml$util$DsmlSearch = DsmlSearch.class$("edu.vt.middleware.ldap.dsml.util.DsmlSearch")) : class$edu$vt$middleware$ldap$dsml$util$DsmlSearch));
    private LdapPool pool;
    private Dsmlv1 dsmlv1 = new Dsmlv1();
    private Dsmlv2 dsmlv2 = new Dsmlv2();
    static /* synthetic */ Class class$edu$vt$middleware$ldap$dsml$util$DsmlSearch;

    public DsmlSearch() {
        this.pool = new LdapPool();
    }

    public DsmlSearch(String propertiesFile) {
        this.pool = new LdapPool(propertiesFile);
    }

    public void search(String query, String[] attrs, String version, OutputStream out) throws NamingException, IOException {
        if (version != null && version.equals("2")) {
            this.dsmlv2.outputDsml(this.doSearch(query, attrs), out);
        } else {
            this.dsmlv1.outputDsml(this.doSearch(query, attrs), out);
        }
    }

    public String searchToString(String query, String[] attrs, String version) throws NamingException, IOException {
        if (version != null && version.equals("2")) {
            return this.dsmlv2.outputDsmlToString(this.doSearch(query, attrs));
        }
        return this.dsmlv1.outputDsmlToString(this.doSearch(query, attrs));
    }

    private Iterator doSearch(String query, String[] attrs) throws NamingException {
        Iterator queryResults;
        block9: {
            queryResults = null;
            if (query != null) {
                try {
                    Ldap ldap = null;
                    try {
                        ldap = (Ldap)this.pool.borrowObject();
                        queryResults = ldap.search(query, attrs);
                    }
                    catch (NamingException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)"Error attempting LDAP search", (Throwable)e);
                        }
                        throw e;
                    }
                    finally {
                        this.pool.returnObject(ldap);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block9;
                    LOG.error((Object)"Error using LDAP pool", (Throwable)e);
                }
            }
        }
        return queryResults;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

