/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.LdapProperties;
import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.ldif.util.Ldif;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Ldap
implements Serializable {
    public static final String PROPERTIES_DOMAIN = "edu.vt.middleware.ldap.";
    protected static final Log AUTH_LOG = LogFactory.getLog((Class)(class$edu$vt$middleware$ldap$Authenticator == null ? (class$edu$vt$middleware$ldap$Authenticator = Ldap.class$("edu.vt.middleware.ldap.Authenticator")) : class$edu$vt$middleware$ldap$Authenticator));
    private static final long serialVersionUID = 3601674532899914836L;
    private static final Log LOG = LogFactory.getLog((Class)(class$edu$vt$middleware$ldap$Ldap == null ? (class$edu$vt$middleware$ldap$Ldap = Ldap.class$("edu.vt.middleware.ldap.Ldap")) : class$edu$vt$middleware$ldap$Ldap));
    protected LdapContext context;
    protected StartTlsResponse tlsResponse;
    protected LdapConfig config;
    static /* synthetic */ Class class$edu$vt$middleware$ldap$Authenticator;
    static /* synthetic */ Class class$edu$vt$middleware$ldap$Ldap;

    public Ldap() {
    }

    public Ldap(LdapConfig ldapConfig) {
        this.setLdapConfig(ldapConfig);
    }

    public void setLdapConfig(LdapConfig ldapConfig) {
        block3: {
            this.config = ldapConfig;
            if (this.config.isTlsEnabled()) {
                try {
                    this.useTls(true);
                }
                catch (NamingException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)"Error using TLS", (Throwable)e);
                }
            }
        }
    }

    public void loadFromProperties() {
        LdapProperties ldapProperties = new LdapProperties();
        ldapProperties.useDefaultPropertiesFile();
        ldapProperties.initialize(this);
    }

    public void loadFromProperties(String propertiesFile) {
        LdapProperties ldapProperties = new LdapProperties(propertiesFile);
        ldapProperties.initialize(this);
    }

    public boolean authenticate(String user, Object credential) throws NamingException {
        return this.authenticateAndAuthorize(user, credential, null);
    }

    public boolean authenticateAndAuthorize(String user, Object credential, String filter) throws NamingException {
        boolean success;
        block2: {
            success = false;
            try {
                this.authenticateAndAuthorize(user, credential, filter, false, null);
                success = true;
            }
            catch (AuthenticationException e) {
                if (!AUTH_LOG.isDebugEnabled()) break block2;
                AUTH_LOG.debug((Object)("Authentication failed for user: " + user), (Throwable)e);
            }
        }
        return success;
    }

    public Attributes authenticateAndAuthorize(String user, Object credential, String filter, String[] retAttrs) throws NamingException {
        return this.authenticateAndAuthorize(user, credential, filter, true, retAttrs);
    }

    private Attributes authenticateAndAuthorize(String user, Object credential, String filter, boolean searchAttrs, String[] retAttrs) throws NamingException {
        String authtype = this.config.getAuthtype();
        if (authtype.equalsIgnoreCase("none")) {
            throw new AuthenticationException("Cannot authenticate user, authtype is 'none'");
        }
        if (!LdapUtil.checkCredential(credential)) {
            throw new AuthenticationException("Cannot authenticate user, invalid credential");
        }
        if (user == null || user.equals("")) {
            throw new AuthenticationException("Cannot authenticate user, invalid user name");
        }
        Attributes userAttributes = null;
        StartTlsResponse tls = null;
        Context ctx = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                try {
                    ctx = this.bind(user, credential, tls);
                    if (AUTH_LOG.isInfoEnabled()) {
                        AUTH_LOG.info((Object)("Authentication succeeded for user: " + user));
                    }
                }
                catch (AuthenticationException e) {
                    if (AUTH_LOG.isInfoEnabled()) {
                        AUTH_LOG.info((Object)("Authentication failed for user: " + user));
                    }
                    throw e;
                }
                if (filter != null) {
                    NamingEnumeration<SearchResult> results = ctx.search(user, filter, LdapConfig.getCompareSearchControls());
                    if (results.hasMore()) {
                        if (AUTH_LOG.isInfoEnabled()) {
                            AUTH_LOG.info((Object)("Authorization succeeded for user: " + user + " with filter: " + filter));
                        }
                    } else {
                        if (AUTH_LOG.isInfoEnabled()) {
                            AUTH_LOG.info((Object)("Authorization failed for user: " + user + " with filter: " + filter));
                        }
                        throw new AuthenticationException("Authorization failed for user: " + user + " with filter: " + filter);
                    }
                }
                if (!searchAttrs) break;
                userAttributes = ctx.getAttributes(user, retAttrs);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                continue;
            }
        }
        this.stopTls(tls);
        ctx.close();
        return userAttributes;
    }

    public boolean compare(String filter) throws NamingException {
        return this.compare(this.config.getBase(), filter);
    }

    public boolean compare(String dn, String filter) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Compare with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            LOG.debug((Object)("  filter = " + filter));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        boolean success = false;
        SearchControls ctls = LdapConfig.getCompareSearchControls();
        LdapContext ctx = null;
        NamingEnumeration<SearchResult> en = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                ctx = this.getContext();
                en = ctx.search(dn, filter, ctls);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                }
                this.reconnect();
                continue;
            }
        }
        if (en.hasMore()) {
            success = true;
        }
        ctx.close();
        return success;
    }

    public Iterator search(String filter) throws NamingException {
        return this.search(this.config.getBase(), filter, null, null);
    }

    public Iterator search(String filter, String[] retAttrs) throws NamingException {
        return this.search(this.config.getBase(), filter, null, retAttrs);
    }

    public Iterator search(String filter, Object[] filterArgs, String[] retAttrs) throws NamingException {
        return this.search(this.config.getBase(), filter, filterArgs, retAttrs);
    }

    public Iterator search(String dn, String filter) throws NamingException {
        return this.search(dn, filter, null, null);
    }

    public Iterator search(String dn, String filter, String[] retAttrs) throws NamingException {
        return this.search(dn, filter, null, retAttrs);
    }

    public Iterator search(String dn, String filter, Object[] filterArgs, String[] retAttrs) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Search with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            LOG.debug((Object)("  filter = " + filter));
            LOG.debug((Object)"  filterArgs = ");
            if (filterArgs == null) {
                LOG.debug((Object)"    none");
            } else {
                LOG.debug((Object)("    " + Arrays.asList(filterArgs)));
            }
            LOG.debug((Object)"  retAttrs = ");
            if (retAttrs == null) {
                LOG.debug((Object)"    all attributes");
            } else {
                LOG.debug((Object)("    " + Arrays.asList(retAttrs)));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        SearchControls ctls = this.config.getSearchControls(retAttrs);
        LdapContext ctx = null;
        NamingEnumeration<SearchResult> en = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                ctx = this.getContext();
                en = ctx.search(dn, filter, filterArgs, ctls);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                }
                this.reconnect();
                continue;
            }
        }
        List results = LdapUtil.deepCopySearchResults(dn, en, this.config.getRemoveUrls());
        ctx.close();
        return results.iterator();
    }

    public Iterator searchAttributes(Attributes matchAttrs) throws NamingException {
        return this.searchAttributes(this.config.getBase(), matchAttrs, null);
    }

    public Iterator searchAttributes(Attributes matchAttrs, String[] retAttrs) throws NamingException {
        return this.searchAttributes(this.config.getBase(), matchAttrs, retAttrs);
    }

    public Iterator searchAttributes(String dn, Attributes matchAttrs) throws NamingException {
        return this.searchAttributes(dn, matchAttrs, null);
    }

    public Iterator searchAttributes(String dn, Attributes matchAttrs, String[] retAttrs) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"One level search with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            LOG.debug((Object)"  attributes = <not shown>");
            LOG.debug((Object)"  return attributes = ");
            if (retAttrs == null) {
                LOG.debug((Object)"    all attributes");
            } else {
                LOG.debug((Object)("    " + Arrays.asList(retAttrs)));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        LdapContext ctx = null;
        NamingEnumeration<SearchResult> en = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                ctx = this.getContext();
                en = ctx.search(dn, matchAttrs, retAttrs);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                }
                this.reconnect();
                continue;
            }
        }
        List results = LdapUtil.deepCopySearchResults(dn, en, this.config.getRemoveUrls());
        ctx.close();
        return results.iterator();
    }

    public Iterator list(String dn) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"List with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        LdapContext ctx = null;
        NamingEnumeration<NameClassPair> en = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                ctx = this.getContext();
                en = ctx.list(dn);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                }
                this.reconnect();
                continue;
            }
        }
        List results = LdapUtil.parseNamingEnumeration(en);
        ctx.close();
        return results.iterator();
    }

    public Attributes getAttributes(String dn) throws NamingException {
        return this.getAttributes(dn, null);
    }

    public Attributes getAttributes(String dn, String[] retAttrs) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Attribute search with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            LOG.debug((Object)"  return attributes = ");
            if (retAttrs == null) {
                LOG.debug((Object)"    all attributes");
            } else {
                LOG.debug((Object)("    " + Arrays.asList(retAttrs)));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        Context ctx = null;
        Attributes attrs = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                ctx = this.getContext();
                attrs = ctx.getAttributes(dn, retAttrs);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                }
                this.reconnect();
                continue;
            }
        }
        ctx.close();
        return attrs;
    }

    public Iterator getSchema(String dn) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Schema search with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        LdapContext ctx = null;
        DirContext schema = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                ctx = this.getContext();
                schema = ctx.getSchema(dn);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                }
                this.reconnect();
                continue;
            }
        }
        NamingEnumeration<SearchResult> en = schema.search("", null);
        List results = LdapUtil.parseNamingEnumeration(en);
        ctx.close();
        return results.iterator();
    }

    public void addAttribute(String dn, String field, String value) throws NamingException {
        if (value == null) {
            this.addAttributes(dn, field, null);
        } else {
            this.addAttributes(dn, field, new String[]{value});
        }
    }

    public void addAttributes(String dn, String field, String[] values) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Add attribute with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            LOG.debug((Object)("  field = " + field));
            LOG.debug((Object)"  values = ");
            if (values != null) {
                LOG.debug((Object)("    " + Arrays.asList(values)));
            } else {
                LOG.debug((Object)"    null");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        BasicAttributes attrs = new BasicAttributes(this.config.isIgnoreCase());
        BasicAttribute attr = new BasicAttribute(field);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                attr.add(values[i]);
            }
        }
        attrs.put(attr);
        this.addAttributes(dn, attrs);
    }

    public void addAttributes(String dn, Attributes attrs) throws NamingException {
        this.modifyAttributes(dn, 1, attrs);
    }

    public void replaceAttribute(String dn, String field, String value) throws NamingException {
        if (value == null) {
            this.replaceAttributes(dn, field, null);
        } else {
            this.replaceAttributes(dn, field, new String[]{value});
        }
    }

    public void replaceAttributes(String dn, String field, String[] values) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Replace attribute with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            LOG.debug((Object)("  field = " + field));
            LOG.debug((Object)"  values = ");
            if (values != null) {
                LOG.debug((Object)("    " + Arrays.asList(values)));
            } else {
                LOG.debug((Object)"    null");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        BasicAttributes attrs = new BasicAttributes(this.config.isIgnoreCase());
        BasicAttribute attr = new BasicAttribute(field);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                attr.add(values[i]);
            }
        }
        attrs.put(attr);
        this.replaceAttributes(dn, attrs);
    }

    public void replaceAttributes(String dn, Attributes attrs) throws NamingException {
        this.modifyAttributes(dn, 2, attrs);
    }

    public void removeAttribute(String dn, String field) throws NamingException {
        this.removeAttribute(dn, field, null);
    }

    public void removeAttribute(String dn, String field, String value) throws NamingException {
        if (value == null) {
            this.removeAttributes(dn, field, null);
        } else {
            this.removeAttributes(dn, field, new String[]{value});
        }
    }

    public void removeAttributes(String dn, String field, String[] values) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Remove attribute with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            LOG.debug((Object)("  field = " + field));
            LOG.debug((Object)"  values = ");
            if (values != null) {
                LOG.debug((Object)("    " + Arrays.asList(values)));
            } else {
                LOG.debug((Object)"    null");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        BasicAttributes attrs = new BasicAttributes(this.config.isIgnoreCase());
        BasicAttribute attr = new BasicAttribute(field);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                attr.add(values[i]);
            }
        }
        attrs.put(attr);
        this.removeAttributes(dn, attrs);
    }

    public void removeAttributes(String dn, Attributes attrs) throws NamingException {
        this.modifyAttributes(dn, 3, attrs);
    }

    public void create(String dn, Attributes attrs) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Create name with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            LOG.debug((Object)"  attributes = <not shown>");
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        Context ctx = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                ctx = this.getContext();
                ctx.createSubcontext(dn, attrs);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                }
                this.reconnect();
                continue;
            }
        }
        ctx.close();
    }

    public void delete(String dn) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Delete name with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        Context ctx = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                ctx = this.getContext();
                ctx.destroySubcontext(dn);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                }
                this.reconnect();
                continue;
            }
        }
        ctx.close();
    }

    public String[] getSaslMechanisms() throws NamingException {
        Attribute attr;
        Attributes attrs = this.getAttributes("", new String[]{"supportedSASLMechanisms"});
        String[] results = new String[]{};
        if (attrs != null && (attr = attrs.get("supportedSASLMechanisms")) != null) {
            results = LdapUtil.parseNamingEnumeration(attr.getAll()).toArray(results);
        }
        return results;
    }

    public String[] getSupportedControls() throws NamingException {
        Attribute attr;
        Attributes attrs = this.getAttributes("", new String[]{"supportedcontrol"});
        String[] results = new String[]{};
        if (attrs != null && (attr = attrs.get("supportedcontrol")) != null) {
            results = LdapUtil.parseNamingEnumeration(attr.getAll()).toArray(results);
        }
        return results;
    }

    public LdapConfig getLdapConfig() {
        return this.config;
    }

    public boolean isTlsEnabled() {
        return this.config.isTlsEnabled();
    }

    public void useTls(boolean tls) throws NamingException {
        this.config.useTls(tls);
        if (this.context != null) {
            if (tls) {
                if (this.tlsResponse == null) {
                    this.tlsResponse = this.startTls(this.context);
                }
            } else {
                this.stopTls(this.tlsResponse);
            }
        }
    }

    public synchronized boolean connect() throws NamingException {
        boolean success = false;
        if (this.context != null) {
            success = true;
        } else {
            this.context = this.bind(this.config.getServiceUser(), this.config.getServiceCredential(), this.tlsResponse);
            success = true;
        }
        return success;
    }

    public synchronized boolean reconnect() throws NamingException {
        this.close();
        return this.connect();
    }

    public void close() {
        block3: {
            try {
                this.stopTls(this.tlsResponse);
                if (this.context != null) {
                    this.context.close();
                    this.context = null;
                }
            }
            catch (NamingException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Error closing connection with the LDAP", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new Ldif().outputLdif(LdapUtil.runCommandline(args), (OutputStream)System.out);
    }

    private LdapContext getContext() throws NamingException {
        this.connect();
        return this.context.newInstance(null);
    }

    private void modifyAttributes(String dn, int modOp, Attributes attrs) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Modifiy attributes with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            LOG.debug((Object)("  modOp = " + modOp));
            LOG.debug((Object)"  attributes = <not shown>");
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        Context ctx = null;
        for (int i = 0; i <= 1; ++i) {
            try {
                ctx = this.getContext();
                ctx.modifyAttributes(dn, modOp, attrs);
                break;
            }
            catch (CommunicationException e) {
                if (i == 1) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                }
                this.reconnect();
                continue;
            }
        }
        ctx.close();
    }

    private LdapContext bind(String dn, Object credential, StartTlsResponse tls) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Bind with the following parameters:");
            LOG.debug((Object)("  dn = " + dn));
            if (this.config.getLogCredentials()) {
                LOG.debug((Object)("  credential = " + credential));
            } else {
                LOG.debug((Object)"  credential = <suppressed>");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        Hashtable<String, Object> environment = new Hashtable<String, Object>(this.config.getEnvironment());
        String authtype = this.config.getAuthtype();
        if (!(this.config.isSaslAuth() || dn != null && credential != null)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"dn or credential is null, authtype set to none");
            }
            authtype = "none";
        }
        if (this.config.isTlsEnabled()) {
            environment.put("java.naming.ldap.version", "3");
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"TLS not used");
                LOG.trace((Object)("authtype is " + authtype));
            }
            environment.put("java.naming.security.authentication", authtype);
            if (!this.config.isSaslAuth() && !authtype.equals("none")) {
                environment.put("java.naming.security.principal", dn);
                environment.put("java.naming.security.credentials", credential);
            }
        }
        InitialLdapContext context = new InitialLdapContext(environment, null);
        if (this.config.isTlsEnabled()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"TLS will be used");
                LOG.trace((Object)("authtype is " + authtype));
            }
            tls = this.startTls(context);
            context.addToEnvironment("java.naming.security.authentication", authtype);
            if (!this.config.isSaslAuth() && !authtype.equals("none")) {
                context.addToEnvironment("java.naming.security.principal", dn);
                context.addToEnvironment("java.naming.security.credentials", credential);
            }
            context.reconnect(null);
        }
        return context;
    }

    private StartTlsResponse startTls(LdapContext context) throws NamingException {
        StartTlsResponse tls = null;
        try {
            for (int i = 0; i <= 1; ++i) {
                try {
                    tls = (StartTlsResponse)context.extendedOperation(new StartTlsRequest());
                    if (this.config.useHostnameVerifier()) {
                        tls.setHostnameVerifier(this.config.getHostnameVerifier());
                    }
                    if (this.config.useSslSocketFactory()) {
                        tls.negotiate(this.config.getSslSocketFactory());
                    } else {
                        tls.negotiate();
                    }
                    break;
                }
                catch (CommunicationException e) {
                    if (i == 1) {
                        throw e;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Error while communicating with the LDAP, retrying", (Throwable)e);
                    }
                    this.reconnect();
                    continue;
                }
            }
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Could not negotiate TLS connection", (Throwable)e);
            }
            throw new CommunicationException(e.getMessage());
        }
        return tls;
    }

    private void stopTls(StartTlsResponse tls) throws NamingException {
        if (tls != null) {
            try {
                tls.close();
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not close TLS connection", (Throwable)e);
                }
                throw new CommunicationException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

