/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.LdapProperties;
import edu.vt.middleware.ldap.LdapUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;

public class Authenticator
extends Ldap {
    public static final String PROPERTIES_DOMAIN = "edu.vt.middleware.ldap.auth.";
    protected String[] userField = new String[]{"uid"};
    protected String user;
    protected Object credential;
    protected String authorizationFilter;
    protected boolean constructDn = false;
    protected boolean subtreeSearch = false;

    public Authenticator() {
    }

    public Authenticator(LdapConfig ldapConfig) {
        super(ldapConfig);
    }

    public void loadFromProperties() {
        LdapProperties ldapProperties = new LdapProperties();
        ldapProperties.useDefaultPropertiesFile();
        ldapProperties.initialize(this);
    }

    public void loadFromProperties(String propertiesFile) {
        LdapProperties ldapProperties = new LdapProperties(propertiesFile);
        ldapProperties.initialize(this);
    }

    public String getDn(String user) throws NamingException {
        String dn = null;
        if (user != null && !user.equals("")) {
            if (this.userField == null || this.userField.length == 0) {
                if (AUTH_LOG.isErrorEnabled()) {
                    AUTH_LOG.error((Object)"Invalid userField, cannot be null or empty.");
                }
            } else if (this.constructDn) {
                if (AUTH_LOG.isDebugEnabled()) {
                    AUTH_LOG.debug((Object)"Constructing DN from first userfield and base");
                }
                dn = this.userField[0] + "=" + user + "," + this.config.getBase();
            } else {
                if (AUTH_LOG.isDebugEnabled()) {
                    AUTH_LOG.debug((Object)"Looking up DN from userfield and base");
                }
                Iterator answer = null;
                if (this.subtreeSearch) {
                    StringBuffer searchFilter = new StringBuffer();
                    if (this.userField.length > 1) {
                        searchFilter.append("(|");
                        for (int i = 0; i < this.userField.length; ++i) {
                            searchFilter.append("(").append(this.userField[i]).append("=").append(user).append(")");
                        }
                        searchFilter.append(")");
                    } else {
                        searchFilter.append("(").append(this.userField[0]).append("=").append(user).append(")");
                    }
                    answer = this.search(searchFilter.toString(), new String[0]);
                } else {
                    for (int i = 0; !(i >= this.userField.length || (answer = this.searchAttributes(new BasicAttributes(this.userField[i], user), new String[0])) != null && answer.hasNext()); ++i) {
                    }
                }
                if (answer != null && answer.hasNext()) {
                    SearchResult sr = (SearchResult)answer.next();
                    dn = sr.getName();
                } else if (AUTH_LOG.isInfoEnabled()) {
                    AUTH_LOG.info((Object)("Search for user: " + user + " failed using attribute(s): " + Arrays.asList(this.userField)));
                }
            }
        }
        return dn;
    }

    public boolean authenticate() throws NamingException {
        return this.authenticate(this.user, this.credential);
    }

    public Attributes authenticate(String[] retAttrs) throws NamingException {
        return this.authenticate(this.user, this.credential, retAttrs);
    }

    public boolean authenticate(String user, Object credential) throws NamingException {
        return super.authenticateAndAuthorize(this.getDn(user), credential, this.authorizationFilter);
    }

    public Attributes authenticate(String user, Object credential, String[] retAttrs) throws NamingException {
        return super.authenticateAndAuthorize(this.getDn(user), credential, this.authorizationFilter, retAttrs);
    }

    public boolean authenticateDn(String dn, Object credential) throws NamingException {
        return super.authenticateAndAuthorize(dn, credential, this.authorizationFilter);
    }

    public void setUserField(String userField) {
        this.userField = userField.split(",");
    }

    public void setUserField(String[] userField) {
        this.userField = userField;
    }

    public String[] getUserField() {
        return this.userField;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public void setCredential(Object credential) {
        this.credential = credential;
    }

    public void setAuthorizationFilter(String authorizationFilter) {
        this.authorizationFilter = authorizationFilter;
    }

    public String getAuthorizationFilter() {
        return this.authorizationFilter;
    }

    public void setConstructDn(String constructDn) {
        if (constructDn != null) {
            this.setConstructDn(Boolean.valueOf(constructDn));
        }
    }

    public void setConstructDn(boolean constructDn) {
        this.constructDn = constructDn;
    }

    public boolean getConstructDn() {
        return this.constructDn;
    }

    public void setSubtreeSearch(String subtreeSearch) {
        if (subtreeSearch != null) {
            this.setSubtreeSearch(Boolean.valueOf(subtreeSearch));
        }
    }

    public void setSubtreeSearch(boolean subtreeSearch) {
        this.subtreeSearch = subtreeSearch;
    }

    public boolean getSubtreeSearch() {
        return this.subtreeSearch;
    }

    public static void main(String[] args) throws Exception {
        Authenticator auth = new Authenticator();
        LdapConfig config = new LdapConfig();
        auth.setLdapConfig(config);
        ArrayList<String> attrs = new ArrayList<String>();
        boolean setUserPasswd = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-url")) {
                    config.setHost(args[++i]);
                    continue;
                }
                if (args[i].equals("-base")) {
                    config.setBase(args[++i]);
                    continue;
                }
                if (args[i].equals("-tls")) {
                    auth.useTls(true);
                    continue;
                }
                if (args[i].equals("-trace")) {
                    config.tracePackets(System.out);
                    continue;
                }
                if (args[i].equals("-userField")) {
                    auth.setUserField(args[++i]);
                    continue;
                }
                if (args[i].equals("-constructDn")) {
                    auth.setConstructDn(true);
                    continue;
                }
                if (args[i].equals("-useProperties")) {
                    auth.loadFromProperties();
                    config = auth.getLdapConfig();
                    continue;
                }
                if (args[i].equals("-user")) {
                    auth.setUser(args[++i]);
                    continue;
                }
                if (args[i].equals("-credential")) {
                    auth.setCredential(args[++i]);
                    setUserPasswd = true;
                    continue;
                }
                if (args[i].equals("-authorize")) {
                    auth.setAuthorizationFilter(args[++i]);
                    continue;
                }
                attrs.add(args[i]);
            }
            if (config.getHost() == null || config.getPort() == null || config.getBase() == null || auth.getUser() == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (!setUserPasswd) {
                System.out.print("Enter user password:  ");
                String pass = new BufferedReader(new InputStreamReader(System.in)).readLine();
                auth.setCredential(pass);
            }
            Attributes results = null;
            results = !attrs.isEmpty() ? auth.authenticate(attrs.toArray(new String[0])) : auth.authenticate(new String[0]);
            if (results != null && results.size() > 0) {
                System.out.println("User attributes:");
                System.out.println(LdapUtil.parseAttributes(results, true));
            }
            auth.close();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: java " + auth.getClass().getName() + " -url <url> \\");
            System.out.println("       -base <base DN> \\");
            System.out.println("       -tls \\");
            System.out.println("       -trace \\");
            System.out.println("       -userField <user field> \\");
            System.out.println("       -constructDn \\");
            System.out.println("       -useProperties \\");
            System.out.println("       -user <user> \\");
            System.out.println("       -credential <credential> (Optional) \\");
            System.out.println("       -authorize <filter> \\");
            System.out.println("       <attributes> \\");
        }
    }
}

