/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.cipher.CBCMode;
import com.trilead.ssh2.crypto.cipher.CTRMode;
import java.util.Vector;

public class BlockCipherFactory {
    static Vector ciphers = new Vector();

    static {
        ciphers.addElement(new CipherEntry("aes256-ctr", 16, 32, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("aes192-ctr", 16, 24, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("aes128-ctr", 16, 16, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("blowfish-ctr", 8, 16, "com.trileadssh2.crypto.cipher.BlowFish"));
        ciphers.addElement(new CipherEntry("aes256-cbc", 16, 32, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("aes192-cbc", 16, 24, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("aes128-cbc", 16, 16, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new CipherEntry("blowfish-cbc", 8, 16, "com.trilead.ssh2.crypto.cipher.BlowFish"));
        ciphers.addElement(new CipherEntry("3des-ctr", 8, 24, "com.trilead.ssh2.crypto.cipher.DESede"));
        ciphers.addElement(new CipherEntry("3des-cbc", 8, 24, "com.trilead.ssh2.crypto.cipher.DESede"));
    }

    public static String[] getDefaultCipherList() {
        String[] list = new String[ciphers.size()];
        int i = 0;
        while (i < ciphers.size()) {
            CipherEntry ce = (CipherEntry)ciphers.elementAt(i);
            list[i] = new String(ce.type);
            ++i;
        }
        return list;
    }

    public static void checkCipherList(String[] cipherCandidates) {
        int i = 0;
        while (i < cipherCandidates.length) {
            BlockCipherFactory.getEntry(cipherCandidates[i]);
            ++i;
        }
    }

    public static BlockCipher createCipher(String type, boolean encrypt, byte[] key, byte[] iv) {
        try {
            CipherEntry ce = BlockCipherFactory.getEntry(type);
            Class<?> cc = Class.forName(ce.cipherClass);
            BlockCipher bc = (BlockCipher)cc.newInstance();
            if (type.endsWith("-cbc")) {
                bc.init(encrypt, key);
                return new CBCMode(bc, iv, encrypt);
            }
            if (type.endsWith("-ctr")) {
                bc.init(true, key);
                return new CTRMode(bc, iv, encrypt);
            }
            throw new IllegalArgumentException("Cannot instantiate " + type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate " + type);
        }
    }

    private static CipherEntry getEntry(String type) {
        int i = 0;
        while (i < ciphers.size()) {
            CipherEntry ce = (CipherEntry)ciphers.elementAt(i);
            if (ce.type.equals(type)) {
                return ce;
            }
            ++i;
        }
        throw new IllegalArgumentException("Unkown algorithm " + type);
    }

    public static int getBlockSize(String type) {
        CipherEntry ce = BlockCipherFactory.getEntry(type);
        return ce.blocksize;
    }

    public static int getKeySize(String type) {
        CipherEntry ce = BlockCipherFactory.getEntry(type);
        return ce.keysize;
    }

    static class CipherEntry {
        String type;
        int blocksize;
        int keysize;
        String cipherClass;

        public CipherEntry(String type, int blockSize, int keySize, String cipherClass) {
            this.type = type;
            this.blocksize = blockSize;
            this.keysize = keySize;
            this.cipherClass = cipherClass;
        }
    }
}

