/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.relyingparty;

import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfigurationManager;
import java.util.Collections;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelyingPartySecurityPolicyResolver
implements SecurityPolicyResolver {
    private Logger log = LoggerFactory.getLogger(RelyingPartySecurityPolicyResolver.class);
    private RelyingPartyConfigurationManager rpConfigManager;
    private MetadataProvider metadataProvider;

    public RelyingPartySecurityPolicyResolver(RelyingPartyConfigurationManager configManager) {
        this(configManager, null);
    }

    public RelyingPartySecurityPolicyResolver(RelyingPartyConfigurationManager configManager, MetadataProvider mdProvider) {
        if (configManager == null) {
            throw new IllegalArgumentException("Relying party configuration manager may not be null");
        }
        this.rpConfigManager = configManager;
        this.metadataProvider = mdProvider;
    }

    public Iterable<SecurityPolicy> resolve(MessageContext messageContext) throws SecurityException {
        return Collections.singletonList(this.resolveSingle(messageContext));
    }

    public SecurityPolicy resolveSingle(MessageContext messageContext) throws SecurityException {
        String peerEntityId = messageContext.getInboundMessageIssuer();
        if (DatatypeHelper.isEmpty((String)peerEntityId)) {
            throw new SecurityException("Unable to select security policy, ID of the peer unknown.");
        }
        RelyingPartyConfiguration rpConfig = null;
        if (this.metadataProvider != null) {
            try {
                if (this.metadataProvider.getEntityDescriptor(peerEntityId) == null) {
                    this.log.warn("No metadata for relying party {}, treating party as anonymous for security policy", (Object)peerEntityId);
                    rpConfig = this.rpConfigManager.getAnonymousRelyingConfiguration();
                }
            }
            catch (MetadataProviderException e) {
                this.log.error("Error fetching metadata for relying party '{}', unable to evaluate anonymous relying party case", (Object)peerEntityId, (Object)e);
            }
        } else {
            this.log.debug("No metadata provider supplied, will be unable to evaluate anonymous relying party case");
        }
        if (rpConfig == null) {
            rpConfig = this.rpConfigManager.getRelyingPartyConfiguration(peerEntityId);
        }
        if (rpConfig == null) {
            this.log.debug("No relying party configuration resolved, returning null security policy");
            return null;
        }
        String profileId = messageContext.getCommunicationProfileId();
        if (DatatypeHelper.isEmpty((String)profileId)) {
            throw new SecurityException("Unable to select security policy, communication profile ID unknown.");
        }
        this.log.debug("Resolving security policy based on communication profile ID: {}", (Object)profileId);
        ProfileConfiguration profileConfig = rpConfig.getProfileConfiguration(profileId);
        if (profileConfig == null) {
            this.log.debug("No profile configuration resolved for communication profile ID '{}', returning null security policy", (Object)profileId);
            return null;
        }
        return profileConfig.getSecurityPolicy();
    }
}

