/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.TransientIdEntry;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector.BasePrincipalConnector;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml2.core.NameID;
import org.opensaml.util.storage.StorageService;

public class TransientPrincipalConnector
extends BasePrincipalConnector {
    private StorageService<String, TransientIdEntry> identifierStore;
    private String partition;

    public TransientPrincipalConnector(StorageService<String, TransientIdEntry> store) {
        if (store == null) {
            throw new IllegalArgumentException("Identifier store may not be null");
        }
        this.identifierStore = store;
        this.partition = "transientId";
    }

    @Override
    public String resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        NameIdentifier nameId;
        SAMLProfileRequestContext requestContext = resolutionContext.getAttributeRequestContext();
        String transientId = null;
        SAMLObject subjectId = requestContext.getSubjectNameIdentifier();
        if (subjectId instanceof NameIdentifier) {
            nameId = (NameIdentifier)requestContext.getSubjectNameIdentifier();
            if (nameId != null) {
                transientId = nameId.getNameIdentifier();
            }
        } else if (requestContext.getSubjectNameIdentifier() instanceof NameID) {
            nameId = (NameID)requestContext.getSubjectNameIdentifier();
            if (nameId != null) {
                transientId = nameId.getValue();
            }
        } else {
            throw new AttributeResolutionException("Subject name identifier is not of a supported type");
        }
        if (transientId == null) {
            throw new AttributeResolutionException("Invalid subject name identifier");
        }
        TransientIdEntry idToken = (TransientIdEntry)((Object)this.identifierStore.get(this.partition, (Object)transientId));
        if (idToken == null || idToken.isExpired()) {
            throw new AttributeResolutionException("No information associated with transient identifier: " + transientId);
        }
        if (!idToken.getRelyingPartyId().equals(requestContext.getInboundMessageIssuer())) {
            throw new AttributeResolutionException("Transient identifier was issued to " + idToken.getRelyingPartyId() + " but is being used by " + requestContext.getInboundMessageIssuer());
        }
        return idToken.getPrincipalName();
    }

    @Override
    public void validate() throws AttributeResolutionException {
    }
}

