/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.encoding.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncodingException;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML2NameIDEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.provider.AbstractAttributeEncoder;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.NameID;
import org.opensaml.xml.util.DatatypeHelper;

public class SAML2StringNameIDEncoder
extends AbstractAttributeEncoder<NameID>
implements SAML2NameIDEncoder {
    private SAMLObjectBuilder<NameID> nameIdBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME);
    private String nameFormat;
    private String nameQualifier;

    @Override
    public NameID encode(BaseAttribute attribute) throws AttributeEncodingException {
        if (attribute.getValues() != null) {
            for (Object value : attribute.getValues()) {
                String valueStr = value.toString();
                if (DatatypeHelper.safeTrimOrNullString((String)valueStr) == null) continue;
                NameID nameId = (NameID)this.nameIdBuilder.buildObject();
                nameId.setValue(valueStr);
                if (this.nameFormat != null) {
                    nameId.setFormat(this.nameFormat);
                }
                if (this.nameQualifier != null) {
                    nameId.setNameQualifier(this.nameQualifier);
                }
                return nameId;
            }
        }
        throw new AttributeEncodingException(attribute.getId() + " attribute does not contain any non-empty values to encode");
    }

    @Override
    public String getNameFormat() {
        return this.nameFormat;
    }

    @Override
    public void setNameFormat(String format) {
        this.nameFormat = DatatypeHelper.safeTrimOrNullString((String)format);
    }

    @Override
    public String getNameQualifier() {
        return this.nameQualifier;
    }

    @Override
    public void setNameQualifier(String qualifier) {
        this.nameQualifier = DatatypeHelper.safeTrimOrNullString((String)qualifier);
    }
}

