/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.StoredIDDataConnectorBeanFactory;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class StoredIDDataConnectorBeanDefinitionParser
extends BaseDataConnectorBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "StoredId");
    private final Logger log = LoggerFactory.getLogger(StoredIDDataConnectorBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return StoredIDDataConnectorBeanFactory.class;
    }

    @Override
    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        super.doParse(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        this.processConnectionManagement(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        long queryTimeout = 5000L;
        if (pluginConfig.hasAttributeNS(null, "queryTimeout")) {
            queryTimeout = SpringConfigurationUtils.parseDurationToMillis("queryTimeout on relational database connector " + pluginId, pluginConfig.getAttributeNS(null, "queryTimeout"), 0);
        }
        this.log.debug("Data connector {} SQL query timeout: {}ms", (Object)queryTimeout);
        pluginBuilder.addPropertyValue("queryTimeout", (Object)queryTimeout);
        String generatedAttributeId = "storedId";
        if (pluginConfig.hasAttributeNS(null, "generatedAttributeID")) {
            generatedAttributeId = DatatypeHelper.safeTrimOrNullString((String)pluginConfig.getAttributeNS(null, "generatedAttributeID"));
        }
        pluginBuilder.addPropertyValue("generatedAttribute", (Object)generatedAttributeId);
        this.log.debug("Data connector {} generated attribute ID: {}", (Object)pluginId, (Object)generatedAttributeId);
        String sourceAttribute = DatatypeHelper.safeTrimOrNullString((String)pluginConfig.getAttributeNS(null, "sourceAttributeID"));
        this.log.debug("Data connector {} source attribute ID: {}", (Object)pluginId, (Object)sourceAttribute);
        pluginBuilder.addPropertyValue("sourceAttribute", (Object)sourceAttribute);
        String salt = DatatypeHelper.safeTrimOrNullString((String)pluginConfig.getAttributeNS(null, "salt"));
        this.log.debug("Data connector {} salt: {}", (Object)pluginId, (Object)salt);
        pluginBuilder.addPropertyValue("salt", (Object)salt.getBytes());
    }

    protected void processConnectionManagement(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        List<Element> cmc = pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "ContainerManagedConnection"));
        DataSource datasource = cmc != null && cmc.get(0) != null ? this.buildContainerManagedConnection(pluginId, cmc.get(0)) : this.buildApplicationManagedConnection(pluginId, pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "ApplicationManagedConnection")).get(0));
        pluginBuilder.addPropertyValue("datasource", (Object)datasource);
    }

    protected DataSource buildContainerManagedConnection(String pluginId, Element cmc) {
        String jndiResource = cmc.getAttributeNS(null, "resourceName");
        jndiResource = DatatypeHelper.safeTrim((String)jndiResource);
        Hashtable<String, String> initCtxProps = this.buildProperties(XMLHelper.getChildElementsByTagNameNS((Element)cmc, (String)"urn:mace:shibboleth:2.0:resolver:dc", (String)"JNDIConnectionProperty"));
        try {
            InitialContext initCtx = new InitialContext(initCtxProps);
            DataSource dataSource = (DataSource)initCtx.lookup(jndiResource);
            if (dataSource == null) {
                this.log.error("DataSource " + jndiResource + " did not exist in JNDI directory");
                throw new BeanCreationException("DataSource " + jndiResource + " did not exist in JNDI directory");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrieved data source for data connector {} from JNDI location {} using properties ", (Object)pluginId, initCtxProps);
            }
            return dataSource;
        }
        catch (NamingException e) {
            this.log.error("Unable to retrieve data source for data connector " + pluginId + " from JNDI location " + jndiResource + " using properties " + initCtxProps, (Throwable)e);
            return null;
        }
    }

    protected DataSource buildApplicationManagedConnection(String pluginId, Element amc) {
        ComboPooledDataSource datasource = new ComboPooledDataSource();
        String driverClass = DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "jdbcDriver"));
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            classLoader.loadClass(driverClass);
        }
        catch (ClassNotFoundException e) {
            this.log.error("Unable to create relational database connector, JDBC driver can not be found on the classpath");
            throw new BeanCreationException("Unable to create relational database connector, JDBC driver can not be found on the classpath");
        }
        try {
            datasource.setDriverClass(driverClass);
            datasource.setJdbcUrl(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "jdbcURL")));
            datasource.setUser(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "jdbcUserName")));
            datasource.setPassword(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "jdbcPassword")));
            if (amc.hasAttributeNS(null, "poolAcquireIncrement")) {
                datasource.setAcquireIncrement(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolAcquireIncrement"))));
            } else {
                datasource.setAcquireIncrement(3);
            }
            if (amc.hasAttributeNS(null, "poolAcquireRetryAttempts")) {
                datasource.setAcquireRetryAttempts(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolAcquireRetryAttempts"))));
            } else {
                datasource.setAcquireRetryAttempts(36);
            }
            if (amc.hasAttributeNS(null, "poolAcquireRetryDelay")) {
                datasource.setAcquireRetryDelay(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolAcquireRetryDelay"))));
            } else {
                datasource.setAcquireRetryDelay(5000);
            }
            if (amc.hasAttributeNS(null, "poolBreakAfterAcquireFailure")) {
                datasource.setBreakAfterAcquireFailure(XMLHelper.getAttributeValueAsBoolean((Attr)amc.getAttributeNodeNS(null, "poolBreakAfterAcquireFailure")).booleanValue());
            } else {
                datasource.setBreakAfterAcquireFailure(true);
            }
            if (amc.hasAttributeNS(null, "poolMinSize")) {
                datasource.setMinPoolSize(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolMinSize"))));
            } else {
                datasource.setMinPoolSize(2);
            }
            if (amc.hasAttributeNS(null, "poolMaxSize")) {
                datasource.setMaxPoolSize(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolMaxSize"))));
            } else {
                datasource.setMaxPoolSize(50);
            }
            if (amc.hasAttributeNS(null, "poolMaxIdleTime")) {
                datasource.setMaxIdleTime(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolMaxIdleTime"))));
            } else {
                datasource.setMaxIdleTime(600);
            }
            if (amc.hasAttributeNS(null, "poolIdleTestPeriod")) {
                datasource.setIdleConnectionTestPeriod(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolIdleTestPeriod"))));
            } else {
                datasource.setIdleConnectionTestPeriod(180);
            }
            datasource.setMaxStatementsPerConnection(10);
            this.log.debug("Created application managed data source for data connector {}", (Object)pluginId);
            return datasource;
        }
        catch (PropertyVetoException e) {
            this.log.error("Unable to create data source for data connector {} with JDBC driver class {}", (Object)pluginId, (Object)driverClass);
            return null;
        }
    }

    protected Hashtable<String, String> buildProperties(List<Element> propertyElements) {
        if (propertyElements == null || propertyElements.size() < 1) {
            return null;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        for (Element propertyElement : propertyElements) {
            String propName = DatatypeHelper.safeTrim((String)propertyElement.getAttributeNS(null, "name"));
            String propValue = DatatypeHelper.safeTrim((String)propertyElement.getAttributeNS(null, "value"));
            properties.put(propName, propValue);
        }
        return properties;
    }
}

