/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.RDBMSColumnDescriptor;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.RDBMSDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorFactoryBean;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.opensaml.xml.util.DatatypeHelper;

public class RDBMSDataConnectorFactoryBean
extends BaseDataConnectorFactoryBean {
    private DataSource connectionDataSource;
    private TemplateEngine templateEngine;
    private String queryTemplate;
    private long queryTimeout;
    private boolean readOnlyConnections;
    private boolean queryUsesStoredProcedures;
    private boolean noResultsIsError;
    private List<RDBMSColumnDescriptor> columnDescriptors;
    private CacheManager cacheManager;
    private int maximumCachedElements;
    private long cacheElementTtl;

    public Class getObjectType() {
        return RDBMSDataConnector.class;
    }

    public boolean isNoResultIsError() {
        return this.noResultsIsError;
    }

    public void setNoResultIsError(boolean b) {
        this.noResultsIsError = b;
    }

    public List<RDBMSColumnDescriptor> getColumnDescriptors() {
        return this.columnDescriptors;
    }

    public void setColumnDescriptors(List<RDBMSColumnDescriptor> descriptors) {
        this.columnDescriptors = descriptors;
    }

    public DataSource getConnectionDataSource() {
        return this.connectionDataSource;
    }

    public void setConnectionDataSource(DataSource source) {
        this.connectionDataSource = source;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.templateEngine = engine;
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public void setQueryTemplate(String template) {
        this.queryTemplate = DatatypeHelper.safeTrimOrNullString((String)template);
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(long timeout) {
        this.queryTimeout = timeout;
    }

    public boolean getQueryUsesStoredProcedures() {
        return this.queryUsesStoredProcedures;
    }

    public void setQueryUsesStoredProcedures(boolean storedProcedures) {
        this.queryUsesStoredProcedures = storedProcedures;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    public long getCacheElementTimeToLive() {
        return this.cacheElementTtl;
    }

    public void setCacheElementTimeToLive(long ttl) {
        this.cacheElementTtl = ttl;
    }

    public int getMaximumCachedElements() {
        return this.maximumCachedElements;
    }

    public void setMaximumCachedElements(int max) {
        this.maximumCachedElements = max;
    }

    public boolean isReadOnlyConnections() {
        return this.readOnlyConnections;
    }

    public void setReadOnlyConnections(boolean readOnly) {
        this.readOnlyConnections = readOnly;
    }

    protected Object createInstance() throws Exception {
        Cache resultsCache = null;
        if (this.cacheManager != null && (resultsCache = this.cacheManager.getCache(this.getPluginId())) == null) {
            long ttlInSeconds = this.cacheElementTtl / 1000L;
            resultsCache = new Cache(this.getPluginId(), this.maximumCachedElements, false, false, ttlInSeconds, ttlInSeconds);
            this.cacheManager.addCache(resultsCache);
        }
        RDBMSDataConnector connector = new RDBMSDataConnector(this.getConnectionDataSource(), resultsCache);
        this.populateDataConnector(connector);
        connector.registerTemplate(this.templateEngine, this.queryTemplate);
        connector.setQueryTimeout((int)(this.queryTimeout / 1000L));
        connector.setUsesStoredProcedure(this.getQueryUsesStoredProcedures());
        connector.setConnectionReadOnly(this.isReadOnlyConnections());
        connector.setNoResultIsError(this.isNoResultIsError());
        if (this.getColumnDescriptors() != null) {
            Map<String, RDBMSColumnDescriptor> columnDecriptors = connector.getColumnDescriptor();
            for (RDBMSColumnDescriptor descriptor : this.getColumnDescriptors()) {
                columnDecriptors.put(descriptor.getColumnName(), descriptor);
            }
        }
        return connector;
    }
}

