/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.ValueMap;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition.BaseAttributeDefinitionBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition.MappedAttributeDefinitionFactoryBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class MappedAttributeDefinitionBeanDefinitionParser
extends BaseAttributeDefinitionBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Mapped");
    public static final QName VALUEMAP_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "ValueMap");
    public static final QName SOURCE_VALUE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "SourceValue");
    public static final QName RETURN_VALUE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "ReturnValue");
    public static final QName DEFAULT_VALUE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "DefaultValue");
    private final Logger log = LoggerFactory.getLogger(MappedAttributeDefinitionBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return MappedAttributeDefinitionFactoryBean.class;
    }

    @Override
    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        super.doParse(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        List<ValueMap> valueMaps = this.processValueMaps(pluginId, pluginConfigChildren, pluginBuilder);
        pluginBuilder.addPropertyValue("valueMaps", valueMaps);
        if (pluginConfigChildren.containsKey(DEFAULT_VALUE_ELEMENT_NAME)) {
            Element defaultValueElem = pluginConfigChildren.get(DEFAULT_VALUE_ELEMENT_NAME).get(0);
            String defaultValue = DatatypeHelper.safeTrimOrNullString((String)defaultValueElem.getTextContent());
            pluginBuilder.addPropertyValue("defaultValue", (Object)defaultValue);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attribute definition {} default value: {}", (Object)pluginId, (Object)defaultValue);
            }
            boolean passThru = false;
            if (defaultValueElem.hasAttributeNS(null, "passThru")) {
                passThru = XMLHelper.getAttributeValueAsBoolean((Attr)defaultValueElem.getAttributeNodeNS(null, "passThru"));
            }
            pluginBuilder.addPropertyValue("passThru", (Object)passThru);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attribute definition {} uses default value pass thru: {}", (Object)pluginId, (Object)passThru);
            }
        }
    }

    protected List<ValueMap> processValueMaps(String pluginId, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder) {
        ArrayList<ValueMap> maps = new ArrayList<ValueMap>(5);
        if (pluginConfigChildren.containsKey(VALUEMAP_ELEMENT_NAME)) {
            for (Element valueMapElem : pluginConfigChildren.get(VALUEMAP_ELEMENT_NAME)) {
                ValueMap valueMap = new ValueMap();
                Map children = XMLHelper.getChildElements((Element)valueMapElem);
                if (children.containsKey(RETURN_VALUE_ELEMENT_NAME)) {
                    List returnValueElems = (List)children.get(RETURN_VALUE_ELEMENT_NAME);
                    String returnValue = DatatypeHelper.safeTrimOrNullString((String)((Element)returnValueElems.get(0)).getTextContent());
                    valueMap.setReturnValue(returnValue);
                }
                if (children.containsKey(SOURCE_VALUE_ELEMENT_NAME)) {
                    for (Element sourceValueElem : (List)children.get(SOURCE_VALUE_ELEMENT_NAME)) {
                        String sourceValue = DatatypeHelper.safeTrim((String)sourceValueElem.getTextContent());
                        boolean ignoreCase = sourceValueElem.hasAttributeNS(null, "ignoreCase") ? XMLHelper.getAttributeValueAsBoolean((Attr)sourceValueElem.getAttributeNodeNS(null, "ignoreCase")) : false;
                        boolean partialMatch = sourceValueElem.hasAttributeNS(null, "partialMatch") ? XMLHelper.getAttributeValueAsBoolean((Attr)sourceValueElem.getAttributeNodeNS(null, "partialMatch")) : false;
                        Collection<ValueMap.SourceValue> collection = valueMap.getSourceValues();
                        ValueMap valueMap2 = valueMap;
                        valueMap2.getClass();
                        collection.add(new ValueMap.SourceValue(valueMap2, sourceValue, ignoreCase, partialMatch));
                    }
                }
                maps.add(valueMap);
            }
        }
        return maps;
    }
}

