/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.StoredIDDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.StoredIDStore;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector.BasePrincipalConnector;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import java.sql.SQLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.SubjectQuery;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredIDPrincipalConnector
extends BasePrincipalConnector {
    private final Logger log = LoggerFactory.getLogger(StoredIDPrincipalConnector.class);
    private StoredIDStore pidStore;
    private boolean noResultIsError;

    public StoredIDPrincipalConnector(StoredIDDataConnector idProducer) {
        if (idProducer == null) {
            throw new IllegalArgumentException("ID producing data connector may not be null");
        }
        this.pidStore = idProducer.getStoredIDStore();
        this.noResultIsError = false;
    }

    public boolean isNoResultIsError() {
        return this.noResultIsError;
    }

    public void setNoResultIsError(boolean isError) {
        this.noResultIsError = isError;
    }

    @Override
    public String resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String persistentId;
        SAMLProfileRequestContext requestContext = resolutionContext.getAttributeRequestContext();
        if (requestContext.getSubjectNameIdentifier() instanceof NameIdentifier) {
            persistentId = ((NameIdentifier)requestContext.getSubjectNameIdentifier()).getNameIdentifier();
        } else if (requestContext.getSubjectNameIdentifier() instanceof NameID) {
            persistentId = ((NameID)requestContext.getSubjectNameIdentifier()).getValue();
        } else {
            throw new AttributeResolutionException("Subject name identifier is not of a supported type");
        }
        try {
            StoredIDStore.PersistentIdEntry pidEntry = this.pidStore.getActivePersistentIdEntry(persistentId);
            if (pidEntry == null) {
                if (this.noResultIsError) {
                    this.log.warn("PersistentId '{}' not found", (Object)persistentId);
                    throw new AttributeResolutionException("No identifier found");
                }
                return null;
            }
            if (!DatatypeHelper.safeEquals((Object)pidEntry.getPeerEntityId(), (Object)this.getPeerEntityId(resolutionContext))) {
                this.log.warn("Requester '{}' attempted to use identifier '{}' which was issued to the entity '{}'", new Object[]{requestContext.getInboundMessageIssuer(), pidEntry.getPersistentId(), pidEntry.getPeerEntityId()});
                if (this.noResultIsError) {
                    throw new AttributeResolutionException("identifier mismatch");
                }
                return null;
            }
            return pidEntry.getPrincipalName();
        }
        catch (SQLException e) {
            this.log.error("Error retrieving persistent ID from database", (Throwable)e);
            throw new AttributeResolutionException("Error retrieving persistent ID from database", e);
        }
    }

    protected String getPeerEntityId(ShibbolethResolutionContext resolutionContext) {
        SAMLProfileRequestContext requestContext = resolutionContext.getAttributeRequestContext();
        String peerEntityId = null;
        this.log.debug("Determining if peer entity ID will be the SPNameQualifier from a SAML 2 authentication statement");
        SAMLObject inboundMessage = requestContext.getInboundSAMLMessage();
        if (inboundMessage instanceof AuthnRequest) {
            AuthnRequest authnRequest = (AuthnRequest)inboundMessage;
            if (authnRequest.getNameIDPolicy() != null) {
                peerEntityId = DatatypeHelper.safeTrimOrNullString((String)authnRequest.getNameIDPolicy().getSPNameQualifier());
                if (peerEntityId == null) {
                    this.log.debug("SAML 2 authentication request did not contain an SPNameQualifier within its NameIDPolicy");
                } else {
                    this.log.debug("SAML 2 authentication request contained an SPNameQualifier, within its NameIDPolicy.  Using that as peer entity ID");
                }
            } else {
                this.log.debug("SAML 2 authentication request did not contain a NameIDPolicy");
            }
        } else if (inboundMessage instanceof SubjectQuery) {
            SubjectQuery query = (SubjectQuery)inboundMessage;
            if (query.getSubject().getNameID().getSPNameQualifier() != null) {
                peerEntityId = DatatypeHelper.safeTrimOrNullString((String)query.getSubject().getNameID().getSPNameQualifier());
                if (peerEntityId == null) {
                    this.log.debug("SAML 2 subject query did not contain an SPNameQualifier within its NameID");
                } else {
                    this.log.debug("SAML 2 subject query contained an SPNameQualifier, within its NameID.  Using that as peer entity ID");
                }
            } else {
                this.log.debug("SAML 2 attribute query did not contain a SPNameQualifier");
            }
        } else {
            peerEntityId = requestContext.getInboundMessageIssuer();
        }
        if (peerEntityId == null) {
            this.log.debug("Determining if inbound message issuer is available for use as peer entity ID");
            peerEntityId = resolutionContext.getAttributeRequestContext().getInboundMessageIssuer();
        }
        return peerEntityId;
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.pidStore == null) {
            throw new AttributeResolutionException("Persistent ID store was null");
        }
        try {
            this.pidStore.getPersistentIdEntry("test", false);
        }
        catch (SQLException e) {
            throw new AttributeResolutionException("Persistent ID store can not perform persistent ID search", e);
        }
    }
}

