/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexSplitAttributeDefinition
extends BaseAttributeDefinition {
    private final Logger log = LoggerFactory.getLogger(RegexSplitAttributeDefinition.class);
    private Pattern regex;

    public RegexSplitAttributeDefinition(String regularExpression, boolean caseSensitive) {
        this.regex = !caseSensitive ? Pattern.compile(regularExpression, 2) : Pattern.compile(regularExpression);
    }

    @Override
    protected BaseAttribute<?> doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        BasicAttribute attribute = new BasicAttribute();
        attribute.setId(this.getId());
        Collection<Object> values = this.getValuesFromAllDependencies(resolutionContext);
        if (values == null || values.isEmpty()) {
            return attribute;
        }
        for (Object value : values) {
            if (value instanceof String) {
                Matcher matcher = this.regex.matcher((String)value);
                if (matcher.matches()) {
                    attribute.getValues().add(matcher.group(1));
                    continue;
                }
                this.log.debug("Value {} did not result in any values when split by regular expression {}", value, (Object)this.regex.toString());
                continue;
            }
            this.log.debug("Ignoring non-string attribute value");
        }
        return attribute;
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.getSourceAttributeID() == null) {
            throw new AttributeResolutionException("Source attribute ID is required but none was given.");
        }
    }
}

