/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.joda.time.DateTime;
import org.opensaml.util.resource.AbstractFilteredResource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SVNResource
extends AbstractFilteredResource {
    private final Logger log = LoggerFactory.getLogger(SVNResource.class);
    private final SVNClientManager svnClientMgr = SVNClientManager.newInstance();
    private String remoteResource;
    private File localResource;
    private SVNRevision revision;

    public SVNResource(String remote, String local, long revision) {
        this.remoteResource = DatatypeHelper.safeTrimOrNullString((String)remote);
        if (this.remoteResource == null) {
            throw new IllegalArgumentException("Remote repository location may not be null or empty");
        }
        if (DatatypeHelper.isEmpty((String)local)) {
            throw new IllegalArgumentException("Local repository location may not be null or empty");
        }
        this.localResource = new File(local);
        this.revision = revision < 0L ? SVNRevision.HEAD : SVNRevision.create((long)revision);
    }

    public SVNResource(String remote, String local, long revision, String username, String password) {
        if (username != null) {
            if (password != null) {
                BasicAuthenticationManager authnMgr = new BasicAuthenticationManager(username, password);
                this.svnClientMgr.setAuthenticationManager((ISVNAuthenticationManager)authnMgr);
            } else {
                throw new IllegalArgumentException("Unable to initialize subversion resource.  User name was given but no password was provided.");
            }
        }
        this.remoteResource = DatatypeHelper.safeTrimOrNullString((String)remote);
        if (this.remoteResource == null) {
            throw new IllegalArgumentException("Remote resource location may not be null or empty");
        }
        if (DatatypeHelper.isEmpty((String)local)) {
            throw new IllegalArgumentException("Local repository location may not be null or empty");
        }
        this.localResource = new File(local);
        this.revision = revision < 0L ? SVNRevision.HEAD : SVNRevision.create((long)revision);
    }

    public boolean exists() throws ResourceException {
        this.checkoutOrUpdateResource();
        return this.workingCopyExists();
    }

    public InputStream getInputStream() throws ResourceException {
        this.checkoutOrUpdateResource();
        try {
            return new FileInputStream(this.localResource);
        }
        catch (IOException e) {
            this.log.error("Unable read local working copy {}", (Object)this.localResource.getAbsolutePath());
            throw new ResourceException("Unable to read local working copy of configuration file " + this.localResource.getAbsolutePath());
        }
    }

    public DateTime getLastModifiedTime() throws ResourceException {
        SVNStatus status = this.getResourceStatus();
        if (status.getContentsStatus() == SVNStatusType.STATUS_NORMAL) {
            return new DateTime((Object)status.getWorkingContentsDate());
        }
        throw new ResourceException("SVN resource is in a state which prevents determining last modified date: " + status.getContentsStatus().toString());
    }

    public String getLocation() {
        try {
            return SVNURL.parseURIDecoded((String)this.remoteResource).toDecodedString();
        }
        catch (SVNException e) {
            this.log.error("Unable to represent remote repository URL as a string");
            return null;
        }
    }

    protected boolean workingCopyExists() {
        return this.localResource.exists();
    }

    protected void checkoutOrUpdateResource() throws ResourceException {
        SVNStatus status = this.getResourceStatus();
        if (!this.workingCopyExists()) {
            this.checkoutResource();
            return;
        }
        if (this.revision == SVNRevision.HEAD) {
            if (!this.revision.equals((Object)status.getRemoteRevision())) {
                this.updateResource();
            }
        } else if (!this.revision.equals((Object)status.getRevision())) {
            this.updateResource();
        }
    }

    protected SVNStatus getResourceStatus() throws ResourceException {
        SVNStatusClient client = this.svnClientMgr.getStatusClient();
        try {
            return client.doStatus(this.localResource, true);
        }
        catch (SVNException e) {
            this.log.error("Unable to determine current status of SVN resource {}", (Object)new Object[]{this.localResource.getAbsolutePath()}, (Object)e);
            throw new ResourceException("Unable to determine current status of SVN resource");
        }
    }

    protected void checkoutResource() throws ResourceException {
        SVNUpdateClient client = this.svnClientMgr.getUpdateClient();
        client.setIgnoreExternals(false);
        try {
            SVNURL remoteResourceLocation = SVNURL.parseURIDecoded((String)this.remoteResource);
            client.doCheckout(remoteResourceLocation, this.localResource, this.revision, this.revision, false);
        }
        catch (SVNException e) {
            this.log.error("Unable to check out resource {}", (Object)new Object[]{this.remoteResource}, (Object)e);
            throw new ResourceException("Unable to check out resource from repository");
        }
    }

    protected void updateResource() throws ResourceException {
        SVNUpdateClient client = this.svnClientMgr.getUpdateClient();
        client.setIgnoreExternals(false);
        try {
            client.doUpdate(this.localResource, this.revision, false);
        }
        catch (SVNException e) {
            this.log.error("Unable to update working copy of resource {} to revision {}", (Object)new Object[]{this.remoteResource, this.revision.getNumber()}, (Object)e);
            throw new ResourceException("Unable to update working copy of resource");
        }
    }
}

