/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.profile;

import edu.internet2.middleware.shibboleth.common.log.AccessLogEntry;
import edu.internet2.middleware.shibboleth.common.profile.NoProfileHandlerException;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandlerManager;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileRequestDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 3750548606378986211L;
    private final Logger log = LoggerFactory.getLogger(ProfileRequestDispatcherServlet.class);
    private final Logger accessLog = LoggerFactory.getLogger((String)"Shibboleth-Access");
    private ProfileHandlerManager handlerManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String handlerManagerId = config.getInitParameter("handlerManagerId");
        if (DatatypeHelper.isEmpty((String)handlerManagerId)) {
            handlerManagerId = "shibboleth.HandlerManager";
        }
        this.handlerManager = (ProfileHandlerManager)this.getServletContext().getAttribute(handlerManagerId);
    }

    /*
     * Unable to fully structure code
     */
    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        if (this.accessLog.isInfoEnabled()) {
            accessEntry = new AccessLogEntry(httpRequest);
            this.accessLog.info(accessEntry.toString());
        }
        profileReq = new HttpServletRequestAdapter(httpRequest);
        profileResp = new HttpServletResponseAdapter(httpResponse, httpRequest.isSecure());
        errorHandler = this.handlerManager.getErrorHandler();
        handler = this.handlerManager.getProfileHandler((ServletRequest)httpRequest);
        if (handler != null) {
            try {
                handler.processRequest(profileReq, profileResp);
                return;
            }
            catch (Throwable t) {
                this.log.error("Error processing profile request", t);
                if (t.getMessage() == null) ** GOTO lbl19
                httpRequest.setAttribute("error", (Object)t);
            }
        } else {
            this.log.warn("No profile handler configured for request at path: {}", (Object)httpRequest.getPathInfo());
            httpRequest.setAttribute("error", (Object)new NoProfileHandlerException("No profile handler configured for request at path: " + httpRequest.getPathInfo()));
        }
lbl19:
        // 3 sources

        errorHandler.processRequest((InTransport)profileReq, (OutTransport)profileResp);
    }
}

