/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config;

import edu.internet2.middleware.shibboleth.common.config.BaseService;
import edu.internet2.middleware.shibboleth.common.service.ReloadableService;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import java.util.Timer;
import java.util.TimerTask;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceChangeListener;
import org.opensaml.util.resource.ResourceChangeWatcher;
import org.opensaml.util.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseReloadableService
extends BaseService
implements ReloadableService {
    private final Logger log = LoggerFactory.getLogger(BaseReloadableService.class);
    private long resourcePollingFrequency;
    private int resourcePollingRetryAttempts;
    private Timer pollingTimer;

    public BaseReloadableService() {
        this.setPollingFrequency(0L);
        this.setPollingRetryAttempts(0);
    }

    public Timer getPollingTimer() {
        return this.pollingTimer;
    }

    public void setPollingTimer(Timer timer) {
        this.pollingTimer = timer;
    }

    public long getPollingFrequency() {
        return this.resourcePollingFrequency;
    }

    public void setPollingFrequency(long frequency) {
        this.resourcePollingFrequency = frequency;
    }

    public int getPollingRetryAttempts() {
        return this.resourcePollingRetryAttempts;
    }

    public void setPollingRetryAttempts(int attempts) {
        this.resourcePollingRetryAttempts = attempts;
    }

    public void initialize() throws ServiceException {
        if (this.isDestroyed()) {
            throw new SecurityException(this.getId() + " service has been destroyed, it may not be initialized.");
        }
        if (this.isInitialized()) {
            return;
        }
        try {
            this.log.debug("Initializing {} service with resources: {}", (Object)this.getId(), this.getServiceConfigurations());
            if (this.resourcePollingFrequency > 0L) {
                ConfigurationResourceListener changeListener = new ConfigurationResourceListener();
                for (Resource configurationResournce : this.getServiceConfigurations()) {
                    ResourceChangeWatcher changeWatcher = new ResourceChangeWatcher(configurationResournce, this.resourcePollingFrequency, this.resourcePollingRetryAttempts);
                    changeWatcher.getResourceListeners().add(changeListener);
                    this.pollingTimer.schedule((TimerTask)changeWatcher, this.resourcePollingFrequency, this.resourcePollingFrequency);
                }
            }
            this.loadContext();
        }
        catch (ResourceException e) {
            throw new ServiceException("Unable to initialize service: " + this.getId(), (Exception)((Object)e));
        }
    }

    public void reload() throws ServiceException {
        this.log.debug("Reloading service {}", (Object)this.getId());
        this.loadContext();
    }

    public void destroy() throws ServiceException {
        this.pollingTimer.cancel();
        super.destroy();
    }

    protected class ConfigurationResourceListener
    implements ResourceChangeListener {
        protected ConfigurationResourceListener() {
        }

        public void onResourceCreate(Resource resource) {
            try {
                BaseReloadableService.this.loadContext();
            }
            catch (ServiceException e) {
                BaseReloadableService.this.log.error("Error reloading configuration, upon configuration resource creation, for service " + BaseReloadableService.this.getId(), (Throwable)e);
            }
        }

        public void onResourceDelete(Resource resource) {
            try {
                BaseReloadableService.this.loadContext();
            }
            catch (ServiceException e) {
                BaseReloadableService.this.log.error("Error reloading configuration, upon configuration resource deletion, for service " + BaseReloadableService.this.getId(), (Throwable)e);
            }
        }

        public void onResourceUpdate(Resource resource) {
            try {
                BaseReloadableService.this.loadContext();
            }
            catch (ServiceException e) {
                BaseReloadableService.this.log.error("Error reloading configuration, upon configuration resource update, for service " + BaseReloadableService.this.getId(), (Throwable)e);
            }
        }
    }
}

