/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.StoredIDStore;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredIDDataConnector
extends BaseDataConnector {
    private final Logger log = LoggerFactory.getLogger(StoredIDDataConnector.class);
    private StoredIDStore pidStore;
    private String generatedAttribute;
    private String sourceAttribute;
    private byte[] salt;

    public StoredIDDataConnector(DataSource source, String generatedAttributeId, String sourceAttributeId, byte[] idSalt) {
        if (source == null) {
            throw new IllegalArgumentException("Data source may not be null");
        }
        this.pidStore = new StoredIDStore(source);
        if (DatatypeHelper.isEmpty((String)generatedAttributeId)) {
            throw new IllegalArgumentException("Provided generated attribute ID must not be empty");
        }
        this.generatedAttribute = generatedAttributeId;
        if (DatatypeHelper.isEmpty((String)sourceAttributeId)) {
            throw new IllegalArgumentException("Provided source attribute ID must not be empty");
        }
        this.sourceAttribute = sourceAttributeId;
        if (idSalt.length < 16) {
            throw new IllegalArgumentException("Provided salt must be at least 16 bytes in size.");
        }
        this.salt = idSalt;
    }

    public StoredIDStore getStoredIDStore() {
        return this.pidStore;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public String getSourceAttributeId() {
        return this.sourceAttribute;
    }

    public String getGeneratedAttributeId() {
        return this.generatedAttribute;
    }

    @Override
    public Map<String, BaseAttribute> resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String persistentId = this.getStoredId(resolutionContext);
        BasicAttribute attribute = new BasicAttribute();
        attribute.setId(this.getGeneratedAttributeId());
        attribute.getValues().add(persistentId);
        HashMap<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();
        attributes.put(attribute.getId(), attribute);
        return attributes;
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.getDependencyIds() == null || this.getDependencyIds().size() != 1) {
            this.log.error("Computed ID " + this.getId() + " data connectore requires exactly one dependency");
            throw new AttributeResolutionException("Computed ID " + this.getId() + " data connectore requires exactly one dependency");
        }
    }

    protected String getStoredId(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        SAMLProfileRequestContext requestCtx = resolutionContext.getAttributeRequestContext();
        String localId = this.getLocalId(resolutionContext);
        try {
            StoredIDStore.PersistentIdEntry idEntry = this.pidStore.getActivePersistentIdEntry(requestCtx.getLocalEntityId(), requestCtx.getInboundMessageIssuer(), localId);
            if (idEntry == null) {
                idEntry = this.createPersistentId(resolutionContext, localId, this.salt);
                this.pidStore.storePersistentIdEntry(idEntry);
                this.log.debug("Created stored ID {}", (Object)idEntry);
            } else {
                this.log.debug("Located existing stored ID {}", (Object)idEntry);
            }
            return idEntry.getPersistentId();
        }
        catch (SQLException e) {
            this.log.error("Database error retrieving persistent identifier", (Throwable)e);
            throw new AttributeResolutionException("Database error retrieving persistent identifier", e);
        }
    }

    protected String getLocalId(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        Collection<Object> sourceIdValues = this.getValuesFromAllDependencies(resolutionContext, this.getSourceAttributeId());
        if (sourceIdValues == null || sourceIdValues.isEmpty()) {
            this.log.error("Source attribute {} for connector {} provide no values", (Object)this.getSourceAttributeId(), (Object)this.getId());
            throw new AttributeResolutionException("Source attribute " + this.getSourceAttributeId() + " for connector " + this.getId() + " provided no values");
        }
        if (sourceIdValues.size() > 1) {
            this.log.warn("Source attribute {} for connector {} has more than one value, only the first value is used", (Object)this.getSourceAttributeId(), (Object)this.getId());
        }
        return sourceIdValues.iterator().next().toString();
    }

    protected StoredIDStore.PersistentIdEntry createPersistentId(ShibbolethResolutionContext resolutionContext, String localId, byte[] salt) throws SQLException {
        String persisentId;
        StoredIDStore.PersistentIdEntry entry = new StoredIDStore.PersistentIdEntry(this.pidStore);
        entry.setLocalEntityId(resolutionContext.getAttributeRequestContext().getLocalEntityId());
        entry.setPeerEntityId(resolutionContext.getAttributeRequestContext().getInboundMessageIssuer());
        entry.setPrincipalName(resolutionContext.getAttributeRequestContext().getPrincipalName());
        entry.setLocalId(localId);
        int numberOfExistingEntries = this.pidStore.getNumberOfPersistentIdEntries(entry.getLocalEntityId(), entry.getPeerEntityId(), entry.getLocalId());
        if (numberOfExistingEntries == 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(entry.getPeerEntityId().getBytes());
                md.update((byte)33);
                md.update(localId.getBytes());
                md.update((byte)33);
                persisentId = Base64.encodeBytes((byte[])md.digest(salt));
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error("JVM error, SHA-1 is not supported, unable to compute ID");
                throw new SQLException("SHA-1 is not supported, unable to compute ID");
            }
        } else {
            persisentId = UUID.randomUUID().toString();
        }
        entry.setPersistentId(persisentId);
        entry.setCreationTime(new Timestamp(System.currentTimeMillis()));
        return entry;
    }
}

