/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueMap {
    private final Logger log = LoggerFactory.getLogger(ValueMap.class);
    private String returnValue;
    private Collection<SourceValue> sourceValues = new HashSet<SourceValue>();

    public String getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(String newReturnValue) {
        this.returnValue = newReturnValue;
    }

    public Collection<SourceValue> getSourceValues() {
        return this.sourceValues;
    }

    public Set<String> evaluate(String sourceValue) {
        HashSet<String> mappedValues = new HashSet<String>();
        for (SourceValue vmv : this.sourceValues) {
            String newValue = null;
            if (vmv.isPartialMatch()) {
                if (sourceValue.contains(vmv.getValue())) {
                    newValue = this.returnValue;
                }
            } else {
                try {
                    int flags = vmv.isIgnoreCase() ? 2 : 0;
                    Matcher m = Pattern.compile(vmv.getValue(), flags).matcher(sourceValue);
                    if (m.matches()) {
                        newValue = m.replaceAll(this.returnValue);
                    }
                }
                catch (PatternSyntaxException e) {
                    this.log.debug("Error matching value {}.  Skipping this value.", (Object)sourceValue);
                }
            }
            if (newValue == null) continue;
            mappedValues.add(this.returnValue);
        }
        return mappedValues;
    }

    public class SourceValue {
        private String value;
        private boolean ignoreCase;
        private boolean partialMatch;

        public SourceValue(String newValue, boolean newIgnoreCase, boolean newPartialMatch) {
            this.value = newValue;
            this.ignoreCase = newIgnoreCase;
            this.partialMatch = newPartialMatch;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public boolean isPartialMatch() {
            return this.partialMatch;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

