/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBStepGeneratorServiceProvider;

import android.support.annotation.Nullable;
import com.google.gson.JsonObject;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBStepGeneratorServiceProvider.spi.RSTBStepGenerator;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBTaskBuilderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.researchstack.backbone.step.Step;

public class RSTBStepGeneratorService {
    private static RSTBStepGeneratorService service;
    private ServiceLoader<RSTBStepGenerator> loader = ServiceLoader.load(RSTBStepGenerator.class);

    private RSTBStepGeneratorService() {
    }

    public static synchronized RSTBStepGeneratorService getInstance() {
        if (service == null) {
            service = new RSTBStepGeneratorService();
        }
        return service;
    }

    @Nullable
    public List<Step> generateSteps(RSTBTaskBuilderHelper helper, String type, JsonObject jsonObject) {
        try {
            for (RSTBStepGenerator stepGenerator : this.loader) {
                if (!stepGenerator.supportsType(type)) continue;
                List<Step> steps = stepGenerator.generateSteps(helper, type, jsonObject);
                if (steps != null) {
                    return steps;
                }
                Step step = stepGenerator.generateStep(helper, type, jsonObject);
                if (step == null) continue;
                return Arrays.asList(step);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            serviceError.printStackTrace();
            return null;
        }
        return null;
    }

    public List<String> supportedStepTypes() {
        ArrayList<String> supportedTypes = new ArrayList<String>();
        try {
            for (RSTBStepGenerator stepGenerator : this.loader) {
                supportedTypes.addAll(stepGenerator.supportedStepTypes());
            }
        }
        catch (ServiceConfigurationError serviceError) {
            supportedTypes = new ArrayList();
            serviceError.printStackTrace();
        }
        return supportedTypes;
    }
}

