/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.tech.foundry.researchsuitetaskbuilder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.DefaultStepGenerators.descriptors.RSTBElementDescriptor;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBElementGeneratorServiceProvider.RSTBElementGeneratorService;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBStateHelper;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBStepGeneratorServiceProvider.RSTBStepGeneratorService;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBTaskBuilderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.researchstack.backbone.step.Step;
import org.researchstack.skin.ResourceManager;

public class RSTBTaskBuilder {
    private static final String TAG = "RSTBTaskBuilder";
    private static RSTBTaskBuilder instance;
    private RSTBTaskBuilderHelper stepBuilderHelper;
    private Context context;

    public RSTBTaskBuilder(Context context, ResourceManager resourceManager, RSTBStateHelper stateHelper) {
        this.stepBuilderHelper = new RSTBTaskBuilderHelper(context, resourceManager, stateHelper);
    }

    @Nullable
    public List<Step> stepsForElement(JsonElement element) {
        if (element.isJsonArray()) {
            JsonArray jsonArray = element.getAsJsonArray();
            return this.generateSteps(jsonArray);
        }
        if (element.isJsonObject()) {
            JsonObject jsonObject = element.getAsJsonObject();
            return this.generateSteps(jsonObject);
        }
        return null;
    }

    @Nullable
    public List<Step> stepsForElementFilename(String elementFilename) {
        JsonElement element = this.stepBuilderHelper.getJsonElementForFilename(elementFilename);
        System.out.print("got ordered task!!");
        List<Step> stepList = null;
        try {
            stepList = this.stepsForElement(element);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"could not create steps from task json", (Throwable)e);
            return null;
        }
        return new ArrayList<Step>(stepList);
    }

    @Nullable
    private List<Step> generateSteps(JsonObject element) {
        RSTBElementDescriptor elementDescriptor = (RSTBElementDescriptor)this.stepBuilderHelper.getGson().fromJson((JsonElement)element, RSTBElementDescriptor.class);
        String type = elementDescriptor.type;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        if (RSTBElementGeneratorService.getInstance().supportsType(type)) {
            JsonArray elements = RSTBElementGeneratorService.getInstance().generateElements(this.stepBuilderHelper, type, element);
            if (elements != null) {
                return this.generateSteps(elements);
            }
            return null;
        }
        Step step = this.createStepForObject(type, element);
        if (step != null) {
            return Arrays.asList(step);
        }
        return null;
    }

    @Nullable
    private List<Step> generateSteps(JsonArray arrayOfElements) {
        ArrayList<Step> stepList = new ArrayList<Step>();
        for (JsonElement element : arrayOfElements) {
            List<Step> addlStepList;
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                addlStepList = this.generateSteps(jsonObject);
                if (addlStepList == null) continue;
                stepList.addAll(addlStepList);
                continue;
            }
            if (element.isJsonArray()) {
                JsonArray jsonArray = element.getAsJsonArray();
                addlStepList = this.generateSteps(jsonArray);
                if (addlStepList == null) continue;
                stepList.addAll(addlStepList);
                continue;
            }
            assert (false);
        }
        return stepList;
    }

    @Nullable
    protected Step createStepForObject(String type, JsonObject jsonObject) {
        RSTBStepGeneratorService stepGenerator = RSTBStepGeneratorService.getInstance();
        return stepGenerator.generateStep(this.stepBuilderHelper, type, jsonObject);
    }

    public RSTBTaskBuilderHelper getStepBuilderHelper() {
        return this.stepBuilderHelper;
    }
}

