/*
 * Decompiled with CFR 0.152.
 */
package edu.chop.cbmi.dataExpress.backends;

import edu.chop.cbmi.dataExpress.backends.MySqlBackend;
import edu.chop.cbmi.dataExpress.backends.OracleBackend;
import edu.chop.cbmi.dataExpress.backends.PostgresBackend;
import edu.chop.cbmi.dataExpress.backends.SqLiteBackend;
import edu.chop.cbmi.dataExpress.backends.SqlBackend;
import edu.chop.cbmi.dataExpress.backends.SqlBackendProvider;
import edu.chop.cbmi.dataExpress.backends.SqlDialect;
import edu.chop.cbmi.dataExpress.backends.SqlServerBackend;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class SqlBackendFactory$ {
    public static SqlBackendFactory$ MODULE$;
    private final ServiceLoader<SqlBackendProvider> sqlBackendProviderLoader;
    private final List<String> included_backends;

    static {
        new SqlBackendFactory$();
    }

    public ServiceLoader<SqlBackendProvider> sqlBackendProviderLoader() {
        return this.sqlBackendProviderLoader;
    }

    private List<String> included_backends() {
        return this.included_backends;
    }

    private SqlBackend load_included_bakcend(String db_type, Properties connection_properties, SqlDialect sqlDialect, String driver_class_name) {
        SqlBackend sqlBackend;
        String string = db_type;
        if ("postgresql".equals(string)) {
            sqlBackend = new PostgresBackend(connection_properties, sqlDialect, driver_class_name);
        } else if ("mysql".equals(string)) {
            sqlBackend = new MySqlBackend(connection_properties, sqlDialect, driver_class_name);
        } else if ("oracle".equals(string)) {
            sqlBackend = new OracleBackend(connection_properties, sqlDialect, driver_class_name);
        } else if ("sqlite".equals(string)) {
            sqlBackend = new SqLiteBackend(connection_properties, sqlDialect, driver_class_name);
        } else if ("sqlserver".equals(string)) {
            sqlBackend = new SqlServerBackend(connection_properties, sqlDialect, driver_class_name);
        } else {
            throw new RuntimeException(new StringBuilder(27).append("Unsupported database type: ").append(db_type).toString());
        }
        return sqlBackend;
    }

    private SqlDialect load_included_bakcend$default$3() {
        return null;
    }

    private String load_included_bakcend$default$4() {
        return null;
    }

    public SqlBackend apply(Properties connection_properties, SqlDialect sqlDialect, String driver_class_name) {
        SqlBackend sqlBackend;
        String db_type = connection_properties.getProperty("jdbcUri").split(":")[1];
        if (this.included_backends().contains((Object)db_type)) {
            sqlBackend = this.load_included_bakcend(db_type, connection_properties, sqlDialect, driver_class_name);
        } else {
            Iterator<SqlBackendProvider> providers = this.sqlBackendProviderLoader().iterator();
            SqlBackend provider = null;
            boolean keep_searching = true;
            while (providers.hasNext() && keep_searching) {
                BoxedUnit boxedUnit;
                Option<SqlBackend> option = providers.next().getProviderFor(db_type, connection_properties, sqlDialect, driver_class_name);
                if (option instanceof Some) {
                    SqlBackend p;
                    Some some = (Some)option;
                    provider = p = (SqlBackend)some.value();
                    keep_searching = false;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                keep_searching = true;
                boxedUnit = BoxedUnit.UNIT;
            }
            sqlBackend = provider;
        }
        return sqlBackend;
    }

    public SqlBackend apply(String connection_properties_file, SqlDialect sqlDialect, String driver_class_name) {
        FileInputStream prop_stream = new FileInputStream(connection_properties_file);
        Properties props = new Properties();
        props.load(prop_stream);
        prop_stream.close();
        if (!props.stringPropertyNames().contains("jdbcUri")) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("File %s does not contain required property \"jdbcUri")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connection_properties_file})));
        }
        return this.apply(props, sqlDialect, driver_class_name);
    }

    public SqlBackend apply(String connection_properties_file, SqlDialect sqlDialect) {
        return this.apply(connection_properties_file, sqlDialect, null);
    }

    public SqlBackend apply(String connection_properties_file, String driver_class_name) {
        return this.apply(connection_properties_file, null, driver_class_name);
    }

    public SqlBackend apply(String connection_properties_file) {
        return this.apply(connection_properties_file, null, null);
    }

    public SqlDialect apply$default$2() {
        return null;
    }

    public String apply$default$3() {
        return null;
    }

    private SqlBackendFactory$() {
        MODULE$ = this;
        this.sqlBackendProviderLoader = ServiceLoader.load(SqlBackendProvider.class);
        this.included_backends = new .colon.colon((Object)"postgresql", (List)new .colon.colon((Object)"mysql", (List)new .colon.colon((Object)"sqlite", (List)new .colon.colon((Object)"oracle", (List)new .colon.colon((Object)"sqlserver", (List)Nil$.MODULE$)))));
    }
}

