/*
 * Decompiled with CFR 0.152.
 */
package edu.chop.cbmi.dataExpress.backends;

import edu.chop.cbmi.dataExpress.backends.SqlDialect;
import edu.chop.cbmi.dataExpress.dataModels.DataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.BigBinaryDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.BitDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.BooleanDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.CharacterDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.DateDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.DateTimeDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.DecimalDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.FloatDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.IntegerDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.SmallIntegerDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.TextDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.TimeDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.TinyIntegerDataType$;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SqLiteDialect$
implements SqlDialect,
Product,
scala.Serializable {
    public static SqLiteDialect$ MODULE$;
    private final String identifierQuote;
    private final String tableCreate;
    private final String tableTruncate;
    private final String tableDrop;
    private final String tableCascade;
    private final String insertStatement;
    private final String insertValues;
    private final String transactionStart;
    private final String transactionEnd;
    private final String transactionCommit;
    private final String transactionRollback;
    private final List<String> reservedWords;

    static {
        new SqLiteDialect$();
    }

    @Override
    public Seq<DataType> mapDataTypes(Seq<String> column_names, ResultSetMetaData meta) {
        return SqlDialect.mapDataTypes$(this, column_names, meta);
    }

    public String identifierQuote() {
        return this.identifierQuote;
    }

    public String tableCreate() {
        return this.tableCreate;
    }

    public String tableTruncate() {
        return this.tableTruncate;
    }

    public String tableDrop() {
        return this.tableDrop;
    }

    public String tableCascade() {
        return this.tableCascade;
    }

    public String insertStatement() {
        return this.insertStatement;
    }

    public String insertValues() {
        return this.insertValues;
    }

    public String transactionStart() {
        return this.transactionStart;
    }

    public String transactionEnd() {
        return this.transactionEnd;
    }

    public String transactionCommit() {
        return this.transactionCommit;
    }

    public String transactionRollback() {
        return this.transactionRollback;
    }

    public List<String> reservedWords() {
        return this.reservedWords;
    }

    @Override
    public String quoteIdentifier(String id) {
        return this.reservedWords().contains((Object)id.toUpperCase()) ? new StringOps(Predef$.MODULE$.augmentString("%s%s%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifierQuote(), id, this.identifierQuote()})) : id;
    }

    @Override
    public String createTable(String name, List<Tuple2<String, DataType>> columns, Option<String> schemaName) {
        List createBlock = (List)columns.map((Function1 & Serializable & scala.Serializable)t -> new StringOps(Predef$.MODULE$.augmentString("%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.quoteIdentifier((String)t._1()), MODULE$.toSqlString((DataType)t._2())})), List$.MODULE$.canBuildFrom());
        String createString = new StringOps(Predef$.MODULE$.augmentString("%s %s (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableCreate(), this.quoteIdentifier(name), createBlock.mkString(", ")}));
        return createString;
    }

    @Override
    public String dropTable(String name, boolean cascade, Option<String> schemaName) {
        String fmtString = cascade ? new StringBuilder(6).append("%s %s ").append(this.tableCascade()).toString() : "%s %s";
        return new StringOps(Predef$.MODULE$.augmentString(fmtString)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableDrop(), this.quoteIdentifier(name)}));
    }

    @Override
    public boolean dropTable$default$2() {
        return false;
    }

    @Override
    public Option<String> dropTable$default$3() {
        return None$.MODULE$;
    }

    @Override
    public String truncate(String table, Option<String> schemaName) {
        return new StringOps(Predef$.MODULE$.augmentString("%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableTruncate(), this.quoteIdentifier(table)}));
    }

    @Override
    public Option<String> truncate$default$2() {
        return None$.MODULE$;
    }

    @Override
    public String commit() {
        return this.transactionCommit();
    }

    @Override
    public String rollback() {
        return this.transactionRollback();
    }

    @Override
    public String endTransaction() {
        return this.transactionEnd();
    }

    @Override
    public String startTransaction() {
        return this.transactionStart();
    }

    @Override
    public String insertRecord(String tableName, List<String> columnNames, Option<String> schemaName) {
        String valuesList = new StringOps(Predef$.MODULE$.augmentString("%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)List$.MODULE$.fill(columnNames.size(), (Function0 & Serializable & scala.Serializable)() -> "?")).mkString(",")}));
        String sqlString = new StringOps(Predef$.MODULE$.augmentString("%s %s (%s) %s (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.insertStatement(), this.quoteIdentifier(tableName), ((TraversableOnce)columnNames.map((Function1 & Serializable & scala.Serializable)n -> MODULE$.quoteIdentifier((String)n), List$.MODULE$.canBuildFrom())).mkString(","), this.insertValues(), valuesList}));
        return sqlString;
    }

    @Override
    public Option<String> insertRecord$default$3() {
        return None$.MODULE$;
    }

    @Override
    public String updateRecords(String tableName, List<String> columnNames, List<Tuple2<String, Object>> filter, Option<String> schemaName) {
        String setString = ((TraversableOnce)columnNames.map((Function1 & Serializable & scala.Serializable)i -> new StringOps(Predef$.MODULE$.augmentString("%s = ?")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.quoteIdentifier((String)i)})), List$.MODULE$.canBuildFrom())).mkString(", ");
        String whereString = filter.size() > 0 ? new StringOps(Predef$.MODULE$.augmentString("WHERE %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)filter.map((Function1 & Serializable & scala.Serializable)i -> new StringBuilder(4).append(MODULE$.quoteIdentifier((String)i._1())).append(" = ?").toString(), List$.MODULE$.canBuildFrom())).mkString(" AND ")})) : "";
        String sqlString = new StringOps(Predef$.MODULE$.augmentString("UPDATE %s SET %s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.quoteIdentifier(tableName), setString, whereString}));
        return sqlString;
    }

    @Override
    public Option<String> updateRecords$default$4() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String toSqlString(DataType dataType) {
        boolean bl;
        boolean bl2;
        boolean bl3 = false;
        DateTimeDataType dateTimeDataType = null;
        boolean bl4 = false;
        TimeDataType timeDataType = null;
        DataType dataType2 = dataType;
        if (IntegerDataType$.MODULE$.equals(dataType2)) {
            return "INTEGER";
        }
        if (SmallIntegerDataType$.MODULE$.equals(dataType2)) {
            return "SMALLINT";
        }
        if (TinyIntegerDataType$.MODULE$.equals(dataType2)) {
            return "SMALLINT";
        }
        if (dataType2 instanceof FloatDataType) {
            return "FLOAT";
        }
        if (dataType2 instanceof DecimalDataType) {
            DecimalDataType decimalDataType = (DecimalDataType)dataType2;
            int p = decimalDataType.precision();
            int s = decimalDataType.scale();
            return new StringOps(Predef$.MODULE$.augmentString("DECIMAL(%d,%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)p), BoxesRunTime.boxToInteger((int)s)}));
        }
        if (DateDataType$.MODULE$.equals(dataType2)) {
            return "DATE";
        }
        if (dataType2 instanceof DateTimeDataType) {
            bl3 = true;
            dateTimeDataType = (DateTimeDataType)dataType2;
            boolean bl5 = dateTimeDataType.withZone();
            if (bl5) {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        if (bl3 && !(bl2 = dateTimeDataType.withZone())) {
            return "TIMESTAMP";
        }
        if (dataType2 instanceof TimeDataType) {
            bl4 = true;
            timeDataType = (TimeDataType)dataType2;
            boolean bl6 = timeDataType.withZone();
            if (bl6) {
                return "TIME WITH TIME ZONE";
            }
        }
        if (bl4 && !(bl = timeDataType.withZone())) {
            return "TIME";
        }
        if (dataType2 instanceof CharacterDataType) {
            String string;
            CharacterDataType characterDataType = (CharacterDataType)dataType2;
            int length = characterDataType.length();
            boolean fixed = characterDataType.fixedWidth();
            if (fixed) {
                string = new StringOps(Predef$.MODULE$.augmentString("CHAR(%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)}));
                return string;
            } else {
                if (length > 0xA00000) {
                    return "TEXT";
                }
                string = new StringOps(Predef$.MODULE$.augmentString("VARCHAR(%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)}));
            }
            return string;
        }
        if (TextDataType$.MODULE$.equals(dataType2)) {
            return "TEXT";
        }
        if (BigBinaryDataType$.MODULE$.equals(dataType2)) {
            return "BLOB";
        }
        if (BooleanDataType$.MODULE$.equals(dataType2)) {
            return "INTEGER";
        }
        if (!BitDataType$.MODULE$.equals(dataType2)) return "";
        return "INTEGER";
    }

    public String productPrefix() {
        return "SqLiteDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SqLiteDialect$;
    }

    public int hashCode() {
        return 278966330;
    }

    public String toString() {
        return "SqLiteDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SqLiteDialect$() {
        MODULE$ = this;
        SqlDialect.$init$(this);
        Product.$init$((Product)this);
        this.identifierQuote = "\"";
        this.tableCreate = "CREATE TABLE";
        this.tableTruncate = "DELETE FROM";
        this.tableDrop = "DROP TABLE";
        this.tableCascade = "";
        this.insertStatement = "INSERT INTO";
        this.insertValues = "VALUES";
        this.transactionStart = "BEGIN TRANSACTION";
        this.transactionEnd = "END TRANSACTION";
        this.transactionCommit = "COMMIT";
        this.transactionRollback = "ROLLBACK";
        this.reservedWords = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ABORT", "ACTION", "ADD", "AFTER", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ATTACH", "AUTOINCREMENT", "BEFORE", "BEGIN", "BETWEEN", "BY", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONFLICT", "CONSTRAINT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DROP", "EACH", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXISTS", "EXPLAIN", "FAIL", "FOR", "FOREIGN", "FROM", "FULL", "GLOB", "GROUP", "HAVING", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "KEY", "LEFT", "LIKE", "LIMIT", "MATCH", "NATURAL", "NO", "NOT", "NOTNULL", "NULL", "OF", "OFFSET", "ON", "OR", "ORDER", "OUTER", "PLAN", "PRAGMA", "PRIMARY", "QUERY", "RAISE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "RIGHT", "ROLLBACK", "ROW", "SAVEPOINT", "SELECT", "SET", "TABLE", "TEMP", "TEMPORARY", "THEN", "TO", "TRANSACTION", "TRIGGER", "UNION", "UNIQUE", "UPDATE", "USING", "VACUUM", "VALUES", "VIEW", "VIRTUAL", "WHEN", "WHERE"}));
    }
}

