/*
 * Decompiled with CFR 0.152.
 */
package edu.chop.cbmi.dataExpress.backends;

import edu.chop.cbmi.dataExpress.backends.SqlDialect;
import edu.chop.cbmi.dataExpress.dataModels.DataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.BigBinaryDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.BitDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.BooleanDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.CharacterDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.DateDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.DateTimeDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.DecimalDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.FloatDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.IntegerDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.SmallIntegerDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.TextDataType$;
import edu.chop.cbmi.dataExpress.dataModels.sql.TimeDataType;
import edu.chop.cbmi.dataExpress.dataModels.sql.TinyIntegerDataType$;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MySqlDialect$
implements SqlDialect,
Product,
scala.Serializable {
    public static MySqlDialect$ MODULE$;
    private final String identifierQuote;
    private final String tableCreate;
    private final String tableTruncate;
    private final String tableDrop;
    private final String tableCascade;
    private final String insertStatement;
    private final String insertValues;
    private final String transactionStart;
    private final String transactionEnd;
    private final String transactionCommit;
    private final String transactionRollback;

    static {
        new MySqlDialect$();
    }

    @Override
    public Seq<DataType> mapDataTypes(Seq<String> column_names, ResultSetMetaData meta) {
        return SqlDialect.mapDataTypes$(this, column_names, meta);
    }

    public String identifierQuote() {
        return this.identifierQuote;
    }

    public String tableCreate() {
        return this.tableCreate;
    }

    public String tableTruncate() {
        return this.tableTruncate;
    }

    public String tableDrop() {
        return this.tableDrop;
    }

    public String tableCascade() {
        return this.tableCascade;
    }

    public String insertStatement() {
        return this.insertStatement;
    }

    public String insertValues() {
        return this.insertValues;
    }

    public String transactionStart() {
        return this.transactionStart;
    }

    public String transactionEnd() {
        return this.transactionEnd;
    }

    public String transactionCommit() {
        return this.transactionCommit;
    }

    public String transactionRollback() {
        return this.transactionRollback;
    }

    @Override
    public String quoteIdentifier(String id) {
        return new StringOps(Predef$.MODULE$.augmentString("%s%s%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifierQuote(), id, this.identifierQuote()}));
    }

    @Override
    public String createTable(String name, List<Tuple2<String, DataType>> columns, Option<String> schemaName) {
        String quotedSchemaPrefix = null;
        quotedSchemaPrefix = schemaName.isEmpty() ? "" : new StringBuilder(1).append(this.quoteIdentifier((String)schemaName.get())).append(".").toString();
        List createBlock = (List)columns.map((Function1 & Serializable & scala.Serializable)t -> new StringOps(Predef$.MODULE$.augmentString("%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.quoteIdentifier((String)t._1()), MODULE$.toSqlString((DataType)t._2())})), List$.MODULE$.canBuildFrom());
        String createString = new StringOps(Predef$.MODULE$.augmentString("%s %s%s (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableCreate(), quotedSchemaPrefix, this.quoteIdentifier(name), createBlock.mkString(", ")}));
        return createString;
    }

    @Override
    public String dropTable(String name, boolean cascade, Option<String> schemaName) {
        String quotedSchemaPrefix = null;
        quotedSchemaPrefix = schemaName.isEmpty() ? "" : new StringBuilder(1).append(this.quoteIdentifier((String)schemaName.get())).append(".").toString();
        String fmtString = cascade ? new StringBuilder(8).append("%s %s%s ").append(this.tableCascade()).toString() : "%s %s%s";
        return new StringOps(Predef$.MODULE$.augmentString(fmtString)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableDrop(), quotedSchemaPrefix, this.quoteIdentifier(name)}));
    }

    @Override
    public boolean dropTable$default$2() {
        return false;
    }

    @Override
    public Option<String> dropTable$default$3() {
        return None$.MODULE$;
    }

    @Override
    public String truncate(String table, Option<String> schemaName) {
        String quotedSchemaPrefix = null;
        quotedSchemaPrefix = schemaName.isEmpty() ? "" : new StringBuilder(1).append(this.quoteIdentifier((String)schemaName.get())).append(".").toString();
        return new StringOps(Predef$.MODULE$.augmentString("%s %s%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableTruncate(), quotedSchemaPrefix, this.quoteIdentifier(table)}));
    }

    @Override
    public Option<String> truncate$default$2() {
        return None$.MODULE$;
    }

    @Override
    public String commit() {
        return this.transactionCommit();
    }

    @Override
    public String rollback() {
        return this.transactionRollback();
    }

    @Override
    public String endTransaction() {
        return this.transactionEnd();
    }

    @Override
    public String startTransaction() {
        return this.transactionStart();
    }

    @Override
    public String insertRecord(String tableName, List<String> columnNames, Option<String> schemaName) {
        String valuesList = new StringOps(Predef$.MODULE$.augmentString("%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)List$.MODULE$.fill(columnNames.size(), (Function0 & Serializable & scala.Serializable)() -> "?")).mkString(",")}));
        String quotedSchemaPrefix = null;
        quotedSchemaPrefix = schemaName.isEmpty() ? "" : new StringBuilder(1).append(this.quoteIdentifier((String)schemaName.get())).append(".").toString();
        String sqlString = new StringOps(Predef$.MODULE$.augmentString("%s %s%s (%s) %s (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.insertStatement(), quotedSchemaPrefix, this.quoteIdentifier(tableName), ((TraversableOnce)columnNames.map((Function1 & Serializable & scala.Serializable)n -> MODULE$.quoteIdentifier((String)n), List$.MODULE$.canBuildFrom())).mkString(","), this.insertValues(), valuesList}));
        return sqlString;
    }

    @Override
    public Option<String> insertRecord$default$3() {
        return None$.MODULE$;
    }

    @Override
    public String updateRecords(String tableName, List<String> columnNames, List<Tuple2<String, Object>> filter, Option<String> schemaName) {
        String quotedSchemaPrefix = null;
        quotedSchemaPrefix = schemaName.isEmpty() ? "" : new StringBuilder(1).append(this.quoteIdentifier((String)schemaName.get())).append(".").toString();
        String setString = ((TraversableOnce)columnNames.map((Function1 & Serializable & scala.Serializable)i -> new StringOps(Predef$.MODULE$.augmentString("%s = ?")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.quoteIdentifier((String)i)})), List$.MODULE$.canBuildFrom())).mkString(", ");
        String whereString = filter.size() > 0 ? new StringOps(Predef$.MODULE$.augmentString("WHERE %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)filter.map((Function1 & Serializable & scala.Serializable)i -> new StringBuilder(4).append(MODULE$.quoteIdentifier((String)i._1())).append(" = ?").toString(), List$.MODULE$.canBuildFrom())).mkString(" AND ")})) : "";
        String sqlString = new StringOps(Predef$.MODULE$.augmentString("UPDATE %s%s SET %s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedSchemaPrefix, this.quoteIdentifier(tableName), setString, whereString}));
        return sqlString;
    }

    @Override
    public Option<String> updateRecords$default$4() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String toSqlString(DataType dataType) {
        boolean bl;
        boolean bl2;
        boolean bl3 = false;
        DateTimeDataType dateTimeDataType = null;
        boolean bl4 = false;
        TimeDataType timeDataType = null;
        DataType dataType2 = dataType;
        if (IntegerDataType$.MODULE$.equals(dataType2)) {
            return "INTEGER";
        }
        if (SmallIntegerDataType$.MODULE$.equals(dataType2)) {
            return "SMALLINT";
        }
        if (TinyIntegerDataType$.MODULE$.equals(dataType2)) {
            return "SMALLINT";
        }
        if (dataType2 instanceof FloatDataType) {
            FloatDataType floatDataType = (FloatDataType)dataType2;
            int p = floatDataType.precision();
            if (p > 53) return "FLOAT(53)";
            String string = new StringOps(Predef$.MODULE$.augmentString("FLOAT(%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)p)}));
            return string;
        }
        if (dataType2 instanceof DecimalDataType) {
            DecimalDataType decimalDataType = (DecimalDataType)dataType2;
            int p = decimalDataType.precision();
            int s = decimalDataType.scale();
            return new StringOps(Predef$.MODULE$.augmentString("DECIMAL(%d,%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)p), BoxesRunTime.boxToInteger((int)s)}));
        }
        if (DateDataType$.MODULE$.equals(dataType2)) {
            return "DATE";
        }
        if (dataType2 instanceof DateTimeDataType) {
            bl3 = true;
            dateTimeDataType = (DateTimeDataType)dataType2;
            boolean bl5 = dateTimeDataType.withZone();
            if (bl5) {
                return "TIMESTAMP";
            }
        }
        if (bl3 && !(bl2 = dateTimeDataType.withZone())) {
            return "TIMESTAMP";
        }
        if (dataType2 instanceof TimeDataType) {
            bl4 = true;
            timeDataType = (TimeDataType)dataType2;
            boolean bl6 = timeDataType.withZone();
            if (bl6) {
                return "TIME WITH TIME ZONE";
            }
        }
        if (bl4 && !(bl = timeDataType.withZone())) {
            return "TIME";
        }
        if (dataType2 instanceof CharacterDataType) {
            String string;
            CharacterDataType characterDataType = (CharacterDataType)dataType2;
            int length = characterDataType.length();
            boolean fixed = characterDataType.fixedWidth();
            if (fixed) {
                if (length > 255) return "TEXT";
                string = new StringOps(Predef$.MODULE$.augmentString("CHAR(%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)}));
                return string;
            } else {
                string = new StringOps(Predef$.MODULE$.augmentString("VARCHAR(%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)}));
            }
            return string;
        }
        if (TextDataType$.MODULE$.equals(dataType2)) {
            return "TEXT";
        }
        if (BigBinaryDataType$.MODULE$.equals(dataType2)) {
            return "BLOB";
        }
        if (BooleanDataType$.MODULE$.equals(dataType2)) {
            return "BOOLEAN";
        }
        if (!BitDataType$.MODULE$.equals(dataType2)) return "";
        return "BIT";
    }

    public String productPrefix() {
        return "MySqlDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySqlDialect$;
    }

    public int hashCode() {
        return -278334620;
    }

    public String toString() {
        return "MySqlDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MySqlDialect$() {
        MODULE$ = this;
        SqlDialect.$init$(this);
        Product.$init$((Product)this);
        this.identifierQuote = "`";
        this.tableCreate = "CREATE TABLE";
        this.tableTruncate = "TRUNCATE TABLE";
        this.tableDrop = "DROP TABLE";
        this.tableCascade = "CASCADE";
        this.insertStatement = "INSERT INTO";
        this.insertValues = "VALUES";
        this.transactionStart = "START TRANSACTION";
        this.transactionEnd = "COMMIT";
        this.transactionCommit = "COMMIT";
        this.transactionRollback = "ROLLBACK";
    }
}

