/*
 * Decompiled with CFR 0.152.
 */
package ecosmob.myarlib;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Toast;
import com.google.ar.core.Anchor;
import com.google.ar.core.ArCoreApk;
import com.google.ar.sceneform.AnchorNode;
import com.google.ar.sceneform.Node;
import com.google.ar.sceneform.NodeParent;
import com.google.ar.sceneform.assets.RenderableSource;
import com.google.ar.sceneform.rendering.ModelRenderable;
import com.google.ar.sceneform.rendering.Renderable;
import com.google.ar.sceneform.ux.ArFragment;
import com.google.ar.sceneform.ux.TransformableNode;
import ecosmob.myarlib.R;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;

public class MyArCameraActivity
extends AppCompatActivity {
    AnchorNode myAnchorNode;
    private ArFragment fragment;
    private ModelRenderable myRenderable;
    private ProgressDialog loadingProgressDialog;

    static void maybeEnableArButton(final Context context, final IsArSupported isArSupported) {
        ArCoreApk.Availability availability = ArCoreApk.getInstance().checkAvailability(context);
        if (Build.VERSION.SDK_INT >= 24) {
            if (availability.isTransient()) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MyArCameraActivity.maybeEnableArButton(context, isArSupported);
                    }
                }, 200L);
            }
            isArSupported.isArSupported(availability.isSupported());
        } else {
            isArSupported.isArSupported(false);
        }
    }

    public static void doesDeviceSupportAR(Context context, IsArSupported isArSupported) {
        MyArCameraActivity.maybeEnableArButton(context, isArSupported);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_my_ar_camera);
        this.fragment = (ArFragment)this.getSupportFragmentManager().findFragmentById(R.id.sceneform_fragment);
        if (this.fragment == null) {
            Toast.makeText((Context)this, (CharSequence)"Something went wrong!", (int)0).show();
            return;
        }
        this.fragment.setOnTapArPlaneListener((hitResult, plane, motionEvent) -> {
            if (this.myRenderable == null) {
                return;
            }
            this.addNodeToScene(this.fragment, hitResult.createAnchor(), (Renderable)this.myRenderable);
        });
        this.loadingProgressDialog = new ProgressDialog((Context)this);
        this.loadingProgressDialog.setMessage((CharSequence)"Please wait while we load the 3D model");
        this.loadingProgressDialog.setCancelable(false);
        this.loadingProgressDialog.show();
        ((CompletableFuture)((ModelRenderable.Builder)((ModelRenderable.Builder)ModelRenderable.builder().setSource((Context)this, (Callable)RenderableSource.builder().setSource((Context)this, Uri.parse((String)Builder.networkResourceUri), RenderableSource.SourceType.GLTF2).setScale(0.25f).setRecenterMode(RenderableSource.RecenterMode.ROOT).build())).setRegistryId((Object)Builder.networkResourceUri)).build().thenAccept(renderable -> {
            if (this.loadingProgressDialog.isShowing()) {
                this.loadingProgressDialog.dismiss();
            }
            this.myRenderable = renderable;
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"3D Model is loaded!", (int)0).show();
        })).exceptionally(throwable -> {
            if (this.loadingProgressDialog.isShowing()) {
                this.loadingProgressDialog.dismiss();
            }
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Error!").setMessage((CharSequence)("We are unable to load 3D Model.\n\nError: " + throwable.getMessage())).show();
            return null;
        });
    }

    private void addNodeToScene(ArFragment fragment, Anchor anchor, Renderable renderable) {
        if (this.myAnchorNode != null) {
            fragment.getArSceneView().getScene().removeChild((Node)this.myAnchorNode);
        }
        this.myAnchorNode = new AnchorNode(anchor);
        TransformableNode node = new TransformableNode(fragment.getTransformationSystem());
        node.setRenderable(renderable);
        node.setParent((NodeParent)this.myAnchorNode);
        fragment.getArSceneView().getScene().addChild((Node)this.myAnchorNode);
        node.getScaleController().setMinScale(0.5f);
        node.select();
        this.findViewById(R.id.ivRemoveModel).setVisibility(0);
    }

    public void onClickRemoveModel(View view) {
        if (this.fragment == null || this.myAnchorNode == null) {
            return;
        }
        this.fragment.getArSceneView().getScene().removeChild((Node)this.myAnchorNode);
        view.setVisibility(8);
    }

    public static class Builder {
        static String networkResourceUri;
        private Activity activity;

        public Builder(Activity activity) {
            this.activity = activity;
        }

        public Builder setNetworkResource(@NonNull String stringUri) {
            networkResourceUri = stringUri;
            return this;
        }

        @RequiresApi(api=24)
        public void launchArCameraActivity() {
            this.activity.startActivity(new Intent((Context)this.activity, MyArCameraActivity.class));
        }
    }

    public static interface IsArSupported {
        public void isArSupported(boolean var1);
    }
}

