/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;

public class FieldDeclarationPattern
extends SearchPattern {
    protected char[] name;
    protected char[] declaringQualification;
    protected char[] declaringSimpleName;
    protected char[] typeQualification;
    protected char[] typeSimpleName;
    protected char[] decodedName;

    public FieldDeclarationPattern(char[] name, int matchMode, boolean isCaseSensitive, char[] declaringQualification, char[] declaringSimpleName, char[] typeQualification, char[] typeSimpleName) {
        super(matchMode, isCaseSensitive);
        this.name = isCaseSensitive ? name : CharOperation.toLowerCase(name);
        this.declaringQualification = isCaseSensitive ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        this.declaringSimpleName = isCaseSensitive ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        this.typeQualification = isCaseSensitive ? typeQualification : CharOperation.toLowerCase(typeQualification);
        this.typeSimpleName = isCaseSensitive ? typeSimpleName : CharOperation.toLowerCase(typeSimpleName);
        this.needsResolve = this.needsResolve();
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        this.decodedName = CharOperation.subarray(word, IIndexConstants.FIELD_DECL.length, word.length);
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptFieldDeclaration(path, this.decodedName);
            }
            ++i;
        }
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestFieldDeclarationPrefix(this.name, this.matchMode, this.isCaseSensitive);
    }

    protected int matchContainer() {
        return 2;
    }

    public boolean matchesBinary(Object binaryInfo, Object enclosingBinaryInfo) {
        String fieldTypeSignature;
        if (!(binaryInfo instanceof IBinaryField)) {
            return false;
        }
        IBinaryField field = (IBinaryField)binaryInfo;
        if (!this.matchesName(this.name, field.getName())) {
            return false;
        }
        IBinaryType declaringType = (IBinaryType)enclosingBinaryInfo;
        if (declaringType != null) {
            char[] declaringTypeName = (char[])declaringType.getName().clone();
            CharOperation.replace(declaringTypeName, '/', '.');
            if (!this.matchesType(this.declaringSimpleName, this.declaringQualification, declaringTypeName)) {
                return false;
            }
        }
        return this.matchesType(this.typeSimpleName, this.typeQualification, Signature.toString(fieldTypeSignature = new String(field.getTypeName()).replace('/', '.')).toCharArray());
    }

    protected boolean matchIndexEntry() {
        if (this.name != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.name, this.decodedName, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.name, this.decodedName, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.name, this.decodedName, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean needsResolve() {
        if (this.declaringSimpleName != null || this.declaringQualification != null) {
            return true;
        }
        return this.typeSimpleName != null || this.typeQualification != null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("FieldDeclarationPattern: ");
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            buffer.append("*.");
        }
        if (this.name == null) {
            buffer.append("*");
        } else {
            buffer.append(this.name);
        }
        if (this.typeQualification != null) {
            buffer.append(" --> ").append(this.typeQualification).append('.');
        } else if (this.typeSimpleName != null) {
            buffer.append(" --> ");
        }
        if (this.typeSimpleName != null) {
            buffer.append(this.typeSimpleName);
        } else if (this.typeQualification != null) {
            buffer.append("*");
        }
        buffer.append(", ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    public int matchLevel(AstNode node, boolean resolve) {
        if (!(node instanceof FieldDeclaration)) {
            return 0;
        }
        FieldDeclaration field = (FieldDeclaration)node;
        if (resolve) {
            return this.matchLevel(field.binding);
        }
        if (!field.isField()) {
            return 0;
        }
        if (!this.matchesName(this.name, field.name)) {
            return 0;
        }
        TypeReference fieldType = field.type;
        char[][] fieldTypeName = fieldType.getTypeName();
        char[] sourceName = this.toArrayName(fieldTypeName[fieldTypeName.length - 1], fieldType.dimensions());
        if (!this.matchesName(this.typeSimpleName, sourceName)) {
            return 0;
        }
        return this.needsResolve ? 1 : 2;
    }

    public int matchLevel(Binding binding) {
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof FieldBinding)) {
            return 0;
        }
        FieldBinding field = (FieldBinding)binding;
        if (!this.matchesName(this.name, field.readableName())) {
            return 0;
        }
        ReferenceBinding declaringBinding = field.declaringClass;
        if (declaringBinding == null) {
            return 3;
        }
        int level = this.matchLevelForType(this.declaringSimpleName, this.declaringQualification, declaringBinding);
        if (level == 0) {
            return 0;
        }
        if (this.declaringSimpleName == null) {
            int newLevel = this.matchLevelForType(this.typeSimpleName, this.typeQualification, field.type);
            switch (newLevel) {
                case 0: {
                    return 0;
                }
                case 2: {
                    break;
                }
                default: {
                    level = newLevel;
                }
            }
        }
        return level;
    }
}

