/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.Util;

public abstract class JavaElement
extends PlatformObject
implements IJavaElement {
    public static final char JEM_JAVAPROJECT = '=';
    public static final char JEM_PACKAGEFRAGMENTROOT = '/';
    public static final char JEM_PACKAGEFRAGMENT = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_INITIALIZER = '|';
    public static final char JEM_COMPILATIONUNIT = '{';
    public static final char JEM_CLASSFILE = '(';
    public static final char JEM_TYPE = '[';
    public static final char JEM_PACKAGEDECLARATION = '%';
    public static final char JEM_IMPORTDECLARATION = '#';
    protected int fOccurrenceCount = 1;
    protected int fLEType = 0;
    protected IJavaElement fParent;
    protected String fName;
    protected static final Object NO_INFO = new Object();

    protected JavaElement(int type, IJavaElement parent, String name) throws IllegalArgumentException {
        if (type < 1 || type > 13) {
            throw new IllegalArgumentException(Util.bind("element.invalidType"));
        }
        this.fLEType = type;
        this.fParent = parent;
        this.fName = name;
    }

    public void close() throws JavaModelException {
        block6: {
            Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
            if (info == null) break block6;
            boolean wasVerbose = false;
            try {
                if (JavaModelManager.VERBOSE) {
                    System.out.println("CLOSING Element (" + Thread.currentThread() + "): " + this.toStringWithAncestors());
                    wasVerbose = true;
                    JavaModelManager.VERBOSE = false;
                }
                if (this instanceof IParent) {
                    IJavaElement[] children = ((JavaElementInfo)info).getChildren();
                    int i = 0;
                    int size = children.length;
                    while (i < size) {
                        JavaElement child = (JavaElement)children[i];
                        child.close();
                        ++i;
                    }
                }
                this.closing(info);
                JavaModelManager.getJavaModelManager().removeInfo(this);
                if (wasVerbose) {
                    System.out.println("-> Package cache size = " + JavaModelManager.getJavaModelManager().cache.pkgSize());
                    System.out.println("-> Openable cache filling ratio = " + JavaModelManager.getJavaModelManager().cache.openableFillingRatio() + "%");
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                JavaModelManager.VERBOSE = wasVerbose;
                throw throwable;
            }
            Object var7_9 = null;
            JavaModelManager.VERBOSE = wasVerbose;
        }
    }

    protected void closing(Object info) throws JavaModelException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.fParent == null) {
            return super.equals(o);
        }
        if (o instanceof JavaElement) {
            JavaElement other = (JavaElement)o;
            if (this.fLEType != other.fLEType) {
                return false;
            }
            return this.fName.equals(other.fName) && this.fParent.equals(other.fParent) && this.fOccurrenceCount == other.fOccurrenceCount;
        }
        return false;
    }

    protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
        return false;
    }

    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public IDOMNode findNode(IDOMCompilationUnit dom) {
        int type = this.getElementType();
        if (type == 5 || type == 8 || type == 13 || type == 10 || type == 9 || type == 11 || type == 7) {
            ArrayList<JavaElement> path = new ArrayList<JavaElement>();
            IJavaElement element = this;
            while (element != null && element.getElementType() != 5) {
                if (element.getElementType() != 12) {
                    path.add(0, (JavaElement)element);
                }
                element = element.getParent();
            }
            if (path.size() == 0) {
                try {
                    if (this.equalsDOMNode(dom)) {
                        return dom;
                    }
                    return null;
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            return ((JavaElement)path.get(0)).followPath(path, 0, dom.getFirstChild());
        }
        return null;
    }

    protected IDOMNode followPath(ArrayList path, int position, IDOMNode node) {
        try {
            if (this.equalsDOMNode(node)) {
                if (position == path.size() - 1) {
                    return node;
                }
                if (node.getFirstChild() != null) {
                    return ((JavaElement)path.get(++position)).followPath(path, position, node.getFirstChild());
                }
                return null;
            }
            if (node.getNextNode() != null) {
                return this.followPath(path, position, node.getNextNode());
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IJavaElement getAncestor(int ancestorType) {
        IJavaElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public IJavaElement[] getChildren() throws JavaModelException {
        return ((JavaElementInfo)this.getElementInfo()).getChildren();
    }

    public ArrayList getChildrenOfType(int type) throws JavaModelException {
        IJavaElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<JavaElement> list = new ArrayList<JavaElement>(size);
        int i = 0;
        while (i < size) {
            JavaElement elt = (JavaElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public IClassFile getClassFile() {
        return null;
    }

    public ICompilationUnit getCompilationUnit() {
        return null;
    }

    public Object getElementInfo() throws JavaModelException {
        JavaModelManager manager;
        IJavaProject project = this.getJavaProject();
        if (project != null && !project.isOpen()) {
            try {
                project.getResolvedClasspath(true);
            }
            catch (JavaModelException javaModelException) {}
        }
        JavaModelManager javaModelManager = manager = JavaModelManager.getJavaModelManager();
        synchronized (manager) {
            Object info = manager.getInfo(this);
            if (info == null) {
                this.openHierarchy();
                info = manager.getInfo(this);
                if (info == null) {
                    throw this.newNotPresentException();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return info;
        }
    }

    public String getElementName() {
        return this.fName;
    }

    public int getElementType() {
        return this.fLEType;
    }

    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.getElementName());
        return buff.toString();
    }

    protected abstract char getHandleMementoDelimiter();

    public IJavaModel getJavaModel() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaModel)) continue;
            return (IJavaModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IJavaProject getJavaProject() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaProject)) continue;
            return (IJavaProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected int getOccurrenceCount() {
        return this.fOccurrenceCount;
    }

    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.fParent);
    }

    public IJavaElement getParent() {
        return this.fParent;
    }

    protected IJavaElement getSourceElementAt(int position) throws JavaModelException {
        if (this instanceof ISourceReference) {
            IJavaElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                SourceRefElement child;
                ISourceRange range;
                IJavaElement aChild = children[i];
                if (aChild instanceof SourceRefElement && position < (range = (child = (SourceRefElement)children[i]).getSourceRange()).getOffset() + range.getLength() && position >= range.getOffset()) {
                    if (child instanceof IParent) {
                        return child.getSourceElementAt(position);
                    }
                    return child;
                }
                ++i;
            }
        } else {
            Assert.isTrue(false);
        }
        return this;
    }

    public SourceMapper getSourceMapper() {
        return ((JavaElement)this.getParent()).getSourceMapper();
    }

    public int hashCode() {
        if (this.fParent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.fName.hashCode(), this.fParent.hashCode());
    }

    protected boolean isAncestorOf(IJavaElement e) {
        IJavaElement parent = e.getParent();
        while (parent != null && !parent.equals(this)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isStructureKnown() throws JavaModelException {
        return ((JavaElementInfo)this.getElementInfo()).isStructureKnown();
    }

    protected JavaModelException newNotPresentException() {
        return new JavaModelException(new JavaModelStatus(969, this));
    }

    protected void openHierarchy() throws JavaModelException {
        if (this instanceof IOpenable) {
            ((Openable)this).openWhenClosed(null);
        } else {
            Openable openableParent = (Openable)this.getOpenableParent();
            if (openableParent != null) {
                JavaElementInfo openableParentInfo = (JavaElementInfo)JavaModelManager.getJavaModelManager().getInfo(openableParent);
                if (openableParentInfo == null) {
                    openableParent.openWhenClosed(null);
                } else {
                    throw this.newNotPresentException();
                }
            }
        }
    }

    protected void opening(Object info) {
    }

    public String readableName() {
        return this.getElementName();
    }

    protected void removeInfo() {
        Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
        if (info != null) {
            if (this instanceof IParent) {
                IJavaElement[] children = ((JavaElementInfo)info).getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    JavaElement child = (JavaElement)children[i];
                    child.removeInfo();
                    ++i;
                }
            }
            JavaModelManager.getJavaModelManager().removeInfo(this);
        }
    }

    public abstract IJavaElement rootedAt(IJavaProject var1);

    public static void runOperation(JavaModelOperation operation, IProgressMonitor monitor) throws JavaModelException {
        try {
            if (operation.isReadOnly() || ResourcesPlugin.getWorkspace().isTreeLocked()) {
                operation.run(monitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, monitor);
            }
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof JavaModelException) {
                throw (JavaModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof JavaModelException) {
                throw (JavaModelException)((Object)e);
            }
            throw new JavaModelException(ce);
        }
    }

    protected void setOccurrenceCount(int count) {
        this.fOccurrenceCount = count;
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        JavaElement parent = (JavaElement)this.getParent();
        if (parent != null && parent.getParent() != null) {
            buffer.append(" [in ");
            parent.toStringInfo(0, buffer, NO_INFO);
            parent.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof JavaElementInfo)) {
            return;
        }
        IJavaElement[] children = ((JavaElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((JavaElement)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append(this.getElementName());
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public abstract IResource getCorrespondingResource() throws JavaModelException;

    public abstract IPath getPath();

    public abstract IResource getResource();

    public abstract IResource getUnderlyingResource() throws JavaModelException;
}

