/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;

public class CompilationUnitProblemFinder
extends Compiler {
    protected CompilationUnitProblemFinder(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory, true);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, true, true, true, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return DefaultErrorHandlingPolicies.proceedWithAllProblems();
    }

    protected static INameEnvironment getNameEnvironment(ICompilationUnit sourceUnit) throws JavaModelException {
        return (SearchableEnvironment)((JavaProject)sourceUnit.getJavaProject()).getSearchableNameEnvironment();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    protected static IProblemFactory getProblemFactory(final char[] fileName, final IProblemRequestor problemRequestor, final IProgressMonitor monitor) {
        return new DefaultProblemFactory(Locale.getDefault()){

            public IProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new AbortCompilation(true, null);
                }
                IProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber);
                if (CharOperation.equals(originatingFileName, fileName)) {
                    if (JavaModelManager.VERBOSE) {
                        System.out.println("PROBLEM FOUND while reconciling : " + problem.getMessage());
                    }
                    problemRequestor.acceptProblem(problem);
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw new AbortCompilation(true, null);
                }
                return problem;
            }
        };
    }

    public static CompilationUnitDeclaration process(ICompilationUnit unitElement, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws JavaModelException {
        char[] fileName = unitElement.getElementName().toCharArray();
        IJavaProject project = unitElement.getJavaProject();
        CompilationUnitProblemFinder problemFinder = new CompilationUnitProblemFinder(CompilationUnitProblemFinder.getNameEnvironment(unitElement), CompilationUnitProblemFinder.getHandlingPolicy(), project.getOptions(true), CompilationUnitProblemFinder.getRequestor(), CompilationUnitProblemFinder.getProblemFactory(fileName, problemRequestor, monitor));
        CompilationUnitDeclaration unit = null;
        try {
            String encoding = project.getOption("org.eclipse.jdt.core.encoding", true);
            IPackageFragment packageFragment = (IPackageFragment)unitElement.getAncestor(4);
            char[][] expectedPackageName = null;
            if (packageFragment != null) {
                expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
            }
            CompilationUnitDeclaration compilationUnitDeclaration = unit = problemFinder.resolve(new BasicCompilationUnit(unitElement.getSource().toCharArray(), expectedPackageName, new String(fileName), encoding), true, true, true);
            Object var10_11 = null;
            if (unit != null) {
                unit.cleanUp();
            }
            problemFinder.lookupEnvironment.reset();
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (unit != null) {
                unit.cleanUp();
            }
            problemFinder.lookupEnvironment.reset();
            throw throwable;
        }
    }
}

