/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class MessageSend
extends Expression
implements InvocationSite {
    public Expression receiver;
    public char[] selector;
    public Expression[] arguments;
    public MethodBinding binding;
    public MethodBinding codegenBinding;
    public long nameSourcePosition;
    MethodBinding syntheticAccessor;
    public TypeBinding receiverType;
    public TypeBinding qualifyingType;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.receiver.analyseCode(currentScope, flowContext, flowInfo, !this.binding.isStatic()).unconditionalInits();
        if (this.arguments != null) {
            int length = this.arguments.length;
            int i = 0;
            while (i < length) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions != TypeConstants.NoExceptions) {
            flowContext.checkExceptionHandlers(thrownExceptions, (AstNode)this, flowInfo, currentScope);
        }
        this.manageSyntheticAccessIfNecessary(currentScope);
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        boolean isStatic = this.codegenBinding.isStatic();
        if (!isStatic && (this.bits & 0x1FE0) != 0 && this.receiver.isImplicitThis()) {
            ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
            Object[] path = currentScope.getEmulationPath(targetType, true, false);
            codeStream.generateOuterAccess(path, this, targetType, currentScope);
        } else {
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
        }
        if (this.arguments != null) {
            int i = 0;
            int max = this.arguments.length;
            while (i < max) {
                this.arguments[i].generateCode(currentScope, codeStream, true);
                ++i;
            }
        }
        if (this.syntheticAccessor == null) {
            if (isStatic) {
                codeStream.invokestatic(this.codegenBinding);
            } else if (this.receiver.isSuper() || this.codegenBinding.isPrivate()) {
                codeStream.invokespecial(this.codegenBinding);
            } else if (this.codegenBinding.declaringClass.isInterface()) {
                codeStream.invokeinterface(this.codegenBinding);
            } else {
                codeStream.invokevirtual(this.codegenBinding);
            }
        } else {
            codeStream.invokestatic(this.syntheticAccessor);
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            switch (this.binding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, (int)(this.nameSourcePosition >>> 32));
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope) {
        if (this.binding.isPrivate()) {
            if (currentScope.enclosingSourceType() != this.binding.declaringClass) {
                this.syntheticAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(this.binding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding destinationType = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticAccessor = destinationType.addSyntheticMethod(this.binding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(this.binding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding enclosingSourceType = currentScope.enclosingSourceType();
                if (this.binding.declaringClass.getPackage() != enclosingSourceType.getPackage()) {
                    SourceTypeBinding currentCompatibleType = (SourceTypeBinding)enclosingSourceType.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticAccessor = currentCompatibleType.addSyntheticMethod(this.binding, this.isSuperAccess());
                    currentScope.problemReporter().needToEmulateMethodAccess(this.binding, this);
                    return;
                }
            }
        }
        if (!(this.binding.declaringClass == this.qualifyingType || this.qualifyingType.isArrayType() || (currentScope.environment().options.targetJDK < 1 || this.receiver.isImplicitThis() && this.binding.isStatic() || this.binding.declaringClass.id == 1) && this.binding.declaringClass.canBeSeenBy(currentScope))) {
            this.codegenBinding = currentScope.enclosingSourceType().getUpdatedMethodBinding(this.binding, (ReferenceBinding)this.qualifyingType);
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = AstNode.NotAConstant;
        this.qualifyingType = this.receiverType = this.receiver.resolveType(scope);
        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                argumentTypes[i] = this.arguments[i].resolveType(scope);
                if (argumentTypes[i] == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                if (this.receiverType instanceof ReferenceBinding) {
                    this.codegenBinding = this.binding = scope.findMethod((ReferenceBinding)this.receiverType, this.selector, new TypeBinding[0], this);
                }
                return null;
            }
        }
        if (this.receiverType == null) {
            return null;
        }
        if (this.receiverType.isBaseType()) {
            scope.problemReporter().errorNoMethodFor(this, this.receiverType, argumentTypes);
            return null;
        }
        this.binding = this.receiver.isImplicitThis() ? scope.getImplicitMethod(this.selector, argumentTypes, this) : scope.getMethod(this.receiverType, this.selector, argumentTypes, this);
        this.codegenBinding = this.binding;
        if (!this.binding.isValidBinding()) {
            MethodBinding closestMatch;
            if (this.binding.declaringClass == null) {
                if (this.receiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.receiverType;
                } else {
                    scope.problemReporter().errorNoMethodFor(this, this.receiverType, argumentTypes);
                    return null;
                }
            }
            scope.problemReporter().invalidMethod(this, this.binding);
            if (this.binding instanceof ProblemMethodBinding && (closestMatch = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                this.codegenBinding = this.binding = closestMatch;
            }
            return this.binding == null ? null : this.binding.returnType;
        }
        if (!this.binding.isStatic()) {
            if (this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0) {
                scope.problemReporter().mustUseAStaticMethod(this, this.binding);
            }
        } else if (!(this.receiver.isImplicitThis() || this.receiver.isSuper() || this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0)) {
            scope.problemReporter().unnecessaryReceiverForStaticMethod(this, this.binding);
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                this.arguments[i].implicitWidening(this.binding.parameters[i], argumentTypes[i]);
                ++i;
            }
        }
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            scope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        this.resolvedType = this.binding.returnType;
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
        this.qualifyingType = receiverType;
    }

    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    public void setFieldIndex(int depth) {
    }

    public String toStringExpression() {
        String s = "";
        if (!this.receiver.isImplicitThis()) {
            s = String.valueOf(s) + this.receiver.toStringExpression() + ".";
        }
        s = String.valueOf(s) + new String(this.selector) + "(";
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + this.arguments[i].toStringExpression();
                if (i != this.arguments.length - 1) {
                    s = String.valueOf(s) + " , ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.receiver.traverse(visitor, blockScope);
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, blockScope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

