/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public abstract class BranchStatement
extends Statement {
    public char[] label;
    public Label targetLabel;
    public AstNode[] subroutines;

    public BranchStatement(char[] l, int s, int e) {
        this.label = l;
        this.sourceStart = s;
        this.sourceEnd = e;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.subroutines != null) {
            int i = 0;
            int max = this.subroutines.length;
            while (i < max) {
                AstNode sub = this.subroutines[i];
                if (sub instanceof SynchronizedStatement) {
                    codeStream.load(((SynchronizedStatement)sub).synchroVariable);
                    codeStream.monitorexit();
                } else {
                    TryStatement trySub = (TryStatement)sub;
                    if (trySub.subRoutineCannotReturn) {
                        codeStream.goto_(trySub.subRoutineStartLabel);
                        codeStream.recordPositionsFrom(pc, this.sourceStart);
                        return;
                    }
                    codeStream.jsr(trySub.subRoutineStartLabel);
                }
                ++i;
            }
        }
        codeStream.goto_(this.targetLabel);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resetStateForCodeGeneration() {
        if (this.targetLabel != null) {
            this.targetLabel.resetStateForCodeGeneration();
        }
    }

    public void resolve(BlockScope scope) {
    }
}

