/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.select;

import org.eclipse.jdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class SelectionOnMessageSend
extends MessageSend {
    private MethodBinding findNonDefaultAbstractMethod(MethodBinding binding) {
        ReferenceBinding[] itsInterfaces = binding.declaringClass.superInterfaces();
        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = 0;
            interfacesToVisit[lastPosition] = itsInterfaces;
            int i = 0;
            while (i <= lastPosition) {
                ReferenceBinding[] interfaces = interfacesToVisit[i];
                int j = 0;
                int length = interfaces.length;
                while (j < length) {
                    ReferenceBinding currentType = interfaces[j];
                    if ((currentType.tagBits & 0x800) == 0) {
                        currentType.tagBits |= 0x800;
                        MethodBinding[] methods = currentType.getMethods(binding.selector);
                        if (methods != null) {
                            int k = 0;
                            while (k < methods.length) {
                                if (binding.areParametersEqual(methods[k])) {
                                    return methods[k];
                                }
                                ++k;
                            }
                        }
                        if ((itsInterfaces = currentType.superInterfaces()) != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return binding;
    }

    public TypeBinding resolveType(BlockScope scope) {
        super.resolveType(scope);
        if (this.binding == null || !this.binding.isValidBinding() && this.binding.problemId() != 2 && this.binding.problemId() != 5 && this.binding.problemId() != 6 && this.binding.problemId() != 7) {
            throw new SelectionNodeFound();
        }
        if (this.binding.isDefaultAbstract()) {
            throw new SelectionNodeFound(this.findNonDefaultAbstractMethod(this.binding));
        }
        throw new SelectionNodeFound(this.binding);
    }

    public String toStringExpression() {
        String s = "<SelectOnMessageSend:";
        if (!this.receiver.isImplicitThis()) {
            s = String.valueOf(s) + this.receiver.toStringExpression() + ".";
        }
        s = String.valueOf(s) + new String(this.selector) + "(";
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + this.arguments[i].toStringExpression();
                if (i != this.arguments.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + ")>";
        return s;
    }
}

