/*
 * Decompiled with CFR 0.152.
 */
package echo.engineer.ee_pinnedheaderlistview;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import echo.engineer.ee_pinnedheaderlistview.SectionedBaseAdapter;

public class PinnedHeaderListView
extends ListView
implements AbsListView.OnScrollListener {
    private AbsListView.OnScrollListener mOnScrollListener;
    private View backUpView;
    private int viewCtrlPosition = 10;
    private PinnedSectionedHeaderAdapter mAdapter;
    private View mCurrentHeader;
    private int mCurrentHeaderViewType = 0;
    private float mHeaderOffset;
    private boolean mShouldPin = true;
    private int mCurrentSection = 0;
    private int mWidthMode;
    private int mHeightMode;
    int lastVisibleItemPosition;

    public void setBackUpView(View view, int position) {
        if (view == null) {
            return;
        }
        this.viewCtrlPosition = position;
        this.backUpView = view;
        this.backUpView.setVisibility(8);
        this.backUpView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PinnedHeaderListView.this.setSelection(0);
            }
        });
    }

    public PinnedHeaderListView(Context context) {
        super(context);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.initView();
    }

    public PinnedHeaderListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.initView();
    }

    public PinnedHeaderListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.initView();
    }

    private void initView() {
        this.setOverScrollMode(2);
    }

    public void setPinHeaders(boolean shouldPin) {
        this.mShouldPin = shouldPin;
    }

    public void setAdapter(ListAdapter adapter) {
        this.mCurrentHeader = null;
        this.mAdapter = (PinnedSectionedHeaderAdapter)adapter;
        super.setAdapter(adapter);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int section;
        this.lastVisibleItemPosition = firstVisibleItem;
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0 || !this.mShouldPin || firstVisibleItem < this.getHeaderViewsCount()) {
            this.mCurrentHeader = null;
            this.mHeaderOffset = 0.0f;
            for (int i = firstVisibleItem; i < firstVisibleItem + visibleItemCount; ++i) {
                View header = this.getChildAt(i);
                if (header == null) continue;
                header.setVisibility(0);
            }
            return;
        }
        int viewType = this.mAdapter.getSectionHeaderViewType(section = this.mAdapter.getSectionForPosition(firstVisibleItem -= this.getHeaderViewsCount()));
        this.mCurrentHeader = this.getSectionHeaderView(section, this.mCurrentHeaderViewType != viewType ? null : this.mCurrentHeader);
        this.ensurePinnedHeaderLayout(this.mCurrentHeader);
        this.mCurrentHeaderViewType = viewType;
        this.mHeaderOffset = 0.0f;
        for (int i = firstVisibleItem; i < firstVisibleItem + visibleItemCount; ++i) {
            if (!this.mAdapter.isSectionHeader(i)) continue;
            View header = this.getChildAt(i - firstVisibleItem);
            float headerTop = header.getTop();
            float pinnedHeaderHeight = this.mCurrentHeader.getMeasuredHeight();
            header.setVisibility(0);
            if (pinnedHeaderHeight >= headerTop && headerTop > 0.0f) {
                this.mHeaderOffset = headerTop - (float)header.getHeight();
                continue;
            }
            if (!(headerTop <= 0.0f)) continue;
            header.setVisibility(4);
        }
        this.invalidate();
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.backUpView != null) {
            if (this.lastVisibleItemPosition > this.viewCtrlPosition) {
                this.backUpView.setVisibility(0);
            } else {
                this.backUpView.setVisibility(8);
            }
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    private View getSectionHeaderView(int section, View oldView) {
        boolean shouldLayout = section != this.mCurrentSection || oldView == null;
        View view = this.mAdapter.getSectionHeaderView(section, oldView, (ViewGroup)this);
        if (shouldLayout) {
            this.ensurePinnedHeaderLayout(view);
            this.mCurrentSection = section;
        }
        return view;
    }

    private void ensurePinnedHeaderLayout(View header) {
        if (header.isLayoutRequested()) {
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)this.mWidthMode);
            ViewGroup.LayoutParams layoutParams = header.getLayoutParams();
            int heightSpec = layoutParams != null && layoutParams.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            header.measure(widthSpec, heightSpec);
            header.layout(0, 0, header.getMeasuredWidth(), header.getMeasuredHeight());
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mAdapter == null || !this.mShouldPin || this.mCurrentHeader == null) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate(0.0f, this.mHeaderOffset);
        canvas.clipRect(0, 0, this.getWidth(), this.mCurrentHeader.getMeasuredHeight());
        this.mCurrentHeader.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOnScrollListener = l;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        this.mHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        super.setOnItemClickListener((AdapterView.OnItemClickListener)listener);
    }

    public static abstract class OnItemClickListener
    implements AdapterView.OnItemClickListener {
        public void onItemClick(AdapterView<?> adapterView, View view, int rawPosition, long id) {
            SectionedBaseAdapter adapter;
            if (adapterView.getAdapter().getClass().equals(HeaderViewListAdapter.class)) {
                HeaderViewListAdapter wrapperAdapter = (HeaderViewListAdapter)adapterView.getAdapter();
                adapter = (SectionedBaseAdapter)wrapperAdapter.getWrappedAdapter();
            } else {
                adapter = (SectionedBaseAdapter)adapterView.getAdapter();
            }
            int section = adapter.getSectionForPosition(rawPosition);
            int position = adapter.getPositionInSectionForPosition(rawPosition);
            if (position == -1) {
                this.onSectionClick(adapterView, view, section, id);
            } else {
                this.onItemClick(adapterView, view, section, position, id);
            }
        }

        public abstract void onItemClick(AdapterView<?> var1, View var2, int var3, int var4, long var5);

        public abstract void onSectionClick(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static interface PinnedSectionedHeaderAdapter {
        public boolean isSectionHeader(int var1);

        public int getSectionForPosition(int var1);

        public View getSectionHeaderView(int var1, View var2, ViewGroup var3);

        public int getSectionHeaderViewType(int var1);

        public int getCount();
    }
}

