/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.easymock.MockControl;
import org.easymock.classextension.MockClassControl;
import org.easymock.internal.RecordState;

public final class DefaultClassInstantiator {
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$ObjectStreamClass;

    private DefaultClassInstantiator() {
    }

    public static Object newInstance(Class c) throws InstantiationException {
        if (DefaultClassInstantiator.isSerializable(c)) {
            try {
                return DefaultClassInstantiator.readObject(DefaultClassInstantiator.getSerializedBytes(c));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to instantiate " + c.getName() + "'s mock: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to instantiate " + c.getName() + "'s mock: " + e.getMessage());
            }
        }
        Constructor constructor = DefaultClassInstantiator.getConstructorToUse(c);
        Object[] params = DefaultClassInstantiator.getArgsForTypes(constructor.getParameterTypes());
        try {
            return constructor.newInstance(params);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to instantiate " + c.getName() + "'s mock: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to instantiate " + c.getName() + "'s mock: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate " + c.getName() + "'s mock: " + e.getMessage());
        }
    }

    private static boolean isSerializable(Class clazz) {
        return (class$java$io$Serializable == null ? (class$java$io$Serializable = DefaultClassInstantiator.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz);
    }

    private static Constructor getConstructorToUse(Class clazz) {
        try {
            return clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getConstructors().length == 0) {
                throw new IllegalArgumentException("No visible constructors in class " + clazz.getName());
            }
            return clazz.getConstructors()[0];
        }
    }

    private static Object[] getArgsForTypes(Class[] methodTypes) throws InstantiationException {
        Object[] methodArgs = new Object[methodTypes.length];
        for (int i = 0; i < methodTypes.length; ++i) {
            if (methodTypes[i].isPrimitive()) {
                methodArgs[i] = RecordState.emptyReturnValueFor((Class)methodTypes[i]);
                continue;
            }
            if (Modifier.isFinal(methodTypes[i].getModifiers())) {
                methodArgs[i] = DefaultClassInstantiator.newInstance(methodTypes[i]);
                continue;
            }
            MockControl ctrl = MockClassControl.createNiceControl(methodTypes[i]);
            ctrl.replay();
            methodArgs[i] = ctrl.getMock();
        }
        return methodArgs;
    }

    private static byte[] getSerializedBytes(Class clazz) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(baos);
        data.writeShort(-21267);
        data.writeShort(5);
        data.writeByte(115);
        data.writeByte(114);
        data.writeUTF(clazz.getName());
        Long suid = DefaultClassInstantiator.getSerializableUID(clazz);
        data.writeLong(suid);
        data.writeByte(2);
        data.writeShort(0);
        data.writeByte(120);
        data.writeByte(112);
        return baos.toByteArray();
    }

    private static Long getSerializableUID(Class clazz) {
        try {
            Field f = clazz.getDeclaredField("serialVersionUID");
            int mask = 24;
            if ((f.getModifiers() & 0x18) == 24) {
                f.setAccessible(true);
                return new Long(f.getLong(null));
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Should have been able to get serialVersionUID since it's there");
        }
        return DefaultClassInstantiator.callLongMethod(clazz, DefaultClassInstantiator.is1_3Specifications() ? "computeSerialVersionUID" : "computeDefaultSUID");
    }

    private static boolean is1_3Specifications() {
        return System.getProperty("java.specification.version").equals("1.3");
    }

    private static Long callLongMethod(Class clazz, String methodName) {
        Long suid;
        Method method;
        try {
            method = (class$java$io$ObjectStreamClass == null ? (class$java$io$ObjectStreamClass = DefaultClassInstantiator.class$("java.io.ObjectStreamClass")) : class$java$io$ObjectStreamClass).getDeclaredMethod(methodName, class$java$lang$Class == null ? (class$java$lang$Class = DefaultClassInstantiator.class$("java.lang.Class")) : class$java$lang$Class);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("ObjectStreamClass." + methodName + " seems to have vanished");
        }
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        try {
            suid = (Long)method.invoke(null, clazz);
        }
        catch (IllegalAccessException e) {
            throw new InternalError("ObjectStreamClass." + methodName + " should have been accessible");
        }
        catch (InvocationTargetException e) {
            throw new InternalError("ObjectStreamClass." + methodName + " failled to be called: " + e.getMessage());
        }
        method.setAccessible(accessible);
        return suid;
    }

    private static Object readObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return in.readObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

