/*
 * Decompiled with CFR 0.152.
 */
package org.nexage.sourcekit.vast;

import android.app.Activity;
import android.content.Context;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.nexage.sourcekit.util.DefaultMediaPicker;
import org.nexage.sourcekit.util.NetworkTools;
import org.nexage.sourcekit.util.VASTLog;
import org.nexage.sourcekit.vast.model.VASTModel;
import org.nexage.sourcekit.vast.processor.VASTProcessor;

public class VASTPlayer {
    private static final String TAG = "VASTPlayer";
    public static final String VERSION = "1.3";
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NO_NETWORK = 1;
    public static final int ERROR_XML_OPEN_OR_READ = 2;
    public static final int ERROR_XML_PARSE = 3;
    public static final int ERROR_SCHEMA_VALIDATION = 4;
    public static final int ERROR_POST_VALIDATION = 5;
    public static final int ERROR_EXCEEDED_WRAPPER_LIMIT = 6;
    public static final int ERROR_VIDEO_PLAYBACK = 7;
    private Context context;
    public static VASTPlayerListener lastListener;
    public VASTPlayerListener listener;
    private VASTModel vastModel;

    public VASTPlayer(Context context, VASTPlayerListener listener) {
        this.context = context;
        this.listener = listener;
        lastListener = listener;
    }

    public void loadVideoWithUrl(final String urlString) {
        VASTLog.d(TAG, "loadVideoWithUrl " + urlString);
        this.vastModel = null;
        if (NetworkTools.connectedToInternet(this.context)) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuffer sb;
                    BufferedReader in = null;
                    try {
                        String line;
                        URL url = new URL(urlString);
                        in = new BufferedReader(new InputStreamReader(url.openStream()));
                        sb = new StringBuffer();
                        while ((line = in.readLine()) != null) {
                            sb.append(line).append(System.getProperty("line.separator"));
                        }
                    }
                    catch (Exception e) {
                        VASTPlayer.this.sendError(2);
                        VASTLog.e(VASTPlayer.TAG, e.getMessage(), e);
                        return;
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    VASTPlayer.this.loadVideoWithData(sb.toString());
                }
            }).start();
        } else {
            this.sendError(1);
        }
    }

    public VASTModel getVastModel() {
        return this.vastModel;
    }

    public void loadVideoWithData(final String xmlData) {
        VASTLog.v(TAG, "loadVideoWithData\n" + xmlData);
        this.vastModel = null;
        if (NetworkTools.connectedToInternet(this.context)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DefaultMediaPicker mediaPicker = new DefaultMediaPicker(VASTPlayer.this.context);
                    VASTProcessor processor = new VASTProcessor(mediaPicker);
                    int error = processor.process(xmlData);
                    if (error == 0) {
                        VASTPlayer.this.vastModel = processor.getModel();
                        VASTPlayer.this.sendReady();
                    } else {
                        VASTPlayer.this.sendError(error);
                    }
                }
            }).start();
        } else {
            this.sendError(1);
        }
    }

    private void sendReady() {
        VASTLog.d(TAG, "sendReady");
        if (this.listener != null) {
            ((Activity)this.context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VASTPlayer.this.listener.vastReady();
                }
            });
        }
    }

    private void sendError(final int error) {
        VASTLog.d(TAG, "sendError");
        if (this.listener != null) {
            ((Activity)this.context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VASTPlayer.this.listener.vastError(error);
                }
            });
        }
    }

    public static interface VASTPlayerListener {
        public void vastReady();

        public void vastError(int var1);

        public void vastClick();

        public void vastComplete();

        public void vastDismiss();
    }
}

