/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.view;

import android.content.Context;
import android.graphics.Rect;
import android.media.MediaPlayer;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.scriptedpapers.mediabutton.MaterialPlayPauseButton;
import eanative.android.R;
import eanative.android.util.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.nexage.sourcekit.util.HttpTools;
import org.nexage.sourcekit.vast.VASTPlayer;
import org.nexage.sourcekit.vast.model.TRACKING_EVENTS_TYPE;
import org.nexage.sourcekit.vast.model.VASTModel;

public class EAVastPlayerView
extends RelativeLayout
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
SurfaceHolder.Callback {
    private static String TAG = "VastTeaserView";
    private static boolean isVideoPlaying = false;
    private static final long TOOLBAR_HIDE_DELAY = 3000L;
    private static final long QUARTILE_TIMER_INTERVAL = 250L;
    private static final long VIDEO_PROGRESS_TIMER_INTERVAL = 250L;
    private Timer mToolBarTimer;
    private Timer mTrackingEventTimer;
    private Timer mStartVideoProgressTimer;
    private LinkedList<Integer> mVideoProgressTracker = null;
    private final int mMaxProgressTrackingPoints = 20;
    private Handler mHandler;
    private Handler mViewPositionHandler;
    private VASTModel mVastModel = null;
    private VASTPlayer mVastPlayer;
    private HashMap<TRACKING_EVENTS_TYPE, List<String>> mTrackingEventMap;
    private MediaPlayer mMediaPlayer;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    private MaterialPlayPauseButton mPlayPauseButton;
    private ImageButton mCloseButton;
    private int mVideoHeight;
    private int mVideoWidth;
    private int mScreenWidth;
    private int mScreenHeight;
    private boolean mIsVideoPaused = false;
    private boolean mIsPlayBackError = false;
    private boolean mIsProcessedImpressions = false;
    private boolean mIsCompleted = false;
    private boolean mIsToolbarVisible = true;
    private boolean mDoNotConsiderTouchUp = false;
    private boolean autoPlay = true;
    private boolean manualUserInteraction = false;
    private int mCurrentVideoPosition;
    private int mQuartile = 0;
    private ProgressBar mProgressBar;
    private int volume = 1;
    private double classId = Math.random();
    private boolean mediaSourceSet;
    Runnable checkIfViewIsVisibleRunnable = new Runnable(){

        @Override
        public void run() {
            EAVastPlayerView.this.mViewPositionHandler.postDelayed((Runnable)this, 250L);
            EAVastPlayerView.this.checkIfViewIsVisible();
        }
    };

    public EAVastPlayerView(Context context, VASTModel vastModel) {
        super(context);
        this.mVastModel = vastModel;
        this.mTrackingEventMap = this.mVastModel.getTrackingUrls();
        this.createUIComponents();
    }

    protected void onMediaStart() {
    }

    protected void onMediaComplete() {
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.isPlaying()) {
            this.mPlayPauseButton.setToPause();
        } else {
            this.mPlayPauseButton.setToPlay();
        }
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        Logger.debug("entered onVideoSizeChanged -- (MediaPlayer callback)", new Object[0]);
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        Logger.debug("video size: " + this.mVideoWidth + "x" + this.mVideoHeight, new Object[0]);
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        Logger.debug("entered onCOMPLETION -- (MediaPlayer callback)", new Object[0]);
        this.stopVideoProgressTimer();
        this.stopViewPositionTimer();
        this.stopToolBarTimer();
        isVideoPlaying = false;
        this.mPlayPauseButton.setToPlay();
        if (!this.mIsPlayBackError && !this.mIsCompleted) {
            this.mIsCompleted = true;
            this.processEvent(TRACKING_EVENTS_TYPE.complete);
        }
        this.onMediaComplete();
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int arg1, int arg2, int arg3) {
        Logger.debug("entered surfaceChanged -- (SurfaceHolder callback) %s", surfaceHolder == this.mSurfaceHolder);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Logger.debug("entered surfaceDestroyed -- (SurfaceHolder callback)", new Object[0]);
    }

    public void onPrepared(MediaPlayer mp) {
        Logger.debug("entered onPrepared called --(MediaPlayer callback) ....about to play %s %s", this.classId, isVideoPlaying);
        this.calculateAspectRatio();
        if (this.autoPlay) {
            Logger.debug("on prepared is view visibile %s", this.isViewVisible());
            if (this.isViewVisible()) {
                this.startMediaPlayer();
                if (this.mIsVideoPaused) {
                    this.mMediaPlayer.pause();
                    this.mPlayPauseButton.setToPlay();
                } else {
                    this.startVideoProgressTimer();
                    this.mPlayPauseButton.setToPause();
                }
            } else {
                this.mMediaPlayer.seekTo(1);
            }
            this.startViewPositionTimer();
        } else {
            this.mPlayPauseButton.setToPlay();
        }
        this.hideProgressBar();
        Logger.debug("current location in video:" + this.mCurrentVideoPosition, new Object[0]);
        if (this.mCurrentVideoPosition > 0) {
            Logger.debug("seeking to location:" + this.mCurrentVideoPosition, new Object[0]);
            this.mMediaPlayer.seekTo(this.mCurrentVideoPosition);
        }
        this.startQuartileTimer();
        this.mPlayPauseButton.setVisibility(0);
    }

    public void cleanPlayerUp() {
        this.mHandler = null;
        Logger.debug("entered cleanPlayerUp", new Object[0]);
        this.cleanUpMediaPlayer();
        this.stopQuartileTimer();
        this.stopVideoProgressTimer();
        this.stopViewPositionTimer();
    }

    public void play() {
        this.processPlaySteps();
    }

    public void pause() {
        this.manualUserInteraction = true;
        this.stopViewPositionTimer();
        this.processPauseSteps();
    }

    public int getCurrentPosition() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public int getDuration() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getDuration();
        }
        return 0;
    }

    public boolean isPlaying() {
        if (this.mMediaPlayer != null) {
            try {
                return this.mMediaPlayer.isPlaying();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return false;
    }

    public void start() {
        this.startMediaPlayer();
    }

    private void createUIComponents() {
        this.createSurface();
        this.createMediaPlayer();
        this.createPlayPauseButton();
        this.createProgressBar();
    }

    protected void startMediaPlayer() {
        if (!this.isPlaying()) {
            this.mMediaPlayer.start();
            isVideoPlaying = true;
            this.onMediaStart();
            this.mMediaPlayer.setVolume((float)this.volume, (float)this.volume);
            if (!this.mIsProcessedImpressions) {
                this.processImpressions();
            }
        }
    }

    private void createProgressBar() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(13);
        this.mProgressBar = new ProgressBar(this.getContext());
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.mProgressBar);
        this.mProgressBar.setVisibility(8);
    }

    private void showProgressBar() {
        this.mProgressBar.setVisibility(0);
    }

    private void hideProgressBar() {
        this.mProgressBar.setVisibility(8);
    }

    private void createSurface() {
        this.mSurfaceView = new SurfaceView(this.getContext());
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.addView((View)this.mSurfaceView);
    }

    private void createMediaPlayer() {
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mMediaPlayer.setAudioStreamType(3);
        this.mediaSourceSet = false;
    }

    private void createPlayPauseButton() {
        this.mPlayPauseButton = new MaterialPlayPauseButton(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.video_play_pause_width), (int)this.getResources().getDimension(R.dimen.video_play_pause_height));
        params.addRule(13, -1);
        this.mPlayPauseButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mPlayPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EAVastPlayerView.this.playPauseButtonClicked();
            }
        });
        this.addView(this.mPlayPauseButton);
    }

    public void activateButtons(boolean active) {
        this.mIsToolbarVisible = active;
        this.mPlayPauseButton.animate().alpha(active ? 1.0f : 0.0f);
    }

    public void closeStreaming() {
        Logger.debug("entered closestreaming()", new Object[0]);
        this.cleanPlayerUp();
        if (!this.mIsPlayBackError) {
            this.processEvent(TRACKING_EVENTS_TYPE.close);
        }
        Logger.debug("leaving closeClicked()", new Object[0]);
    }

    private void playPauseButtonClicked() {
        this.manualUserInteraction = true;
        Logger.debug("entered playPauseClicked", new Object[0]);
        if (this.mMediaPlayer == null) {
            Logger.debug("mMediaPlayer is null when playPauseButton was clicked", new Object[0]);
            return;
        }
        boolean isPlaying = this.mMediaPlayer.isPlaying();
        Logger.debug("isPlaying:" + isPlaying, new Object[0]);
        if (isPlaying) {
            this.pause();
        } else if (this.mIsVideoPaused) {
            this.play();
            if (!this.mIsCompleted) {
                this.processEvent(TRACKING_EVENTS_TYPE.resume);
            }
        } else {
            this.processPlaySteps();
            this.mQuartile = 0;
            this.startQuartileTimer();
        }
    }

    private void processPauseSteps() {
        this.mIsVideoPaused = true;
        isVideoPlaying = false;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.pause();
        }
        Logger.debug("entered process pause steps", new Object[0]);
        this.stopVideoProgressTimer();
        this.stopToolBarTimer();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                EAVastPlayerView.this.mPlayPauseButton.setToPlay();
            }
        }, 10L);
        if (!this.mIsCompleted) {
            this.processEvent(TRACKING_EVENTS_TYPE.pause);
        }
    }

    private void processPlaySteps() {
        this.mIsVideoPaused = false;
        isVideoPlaying = true;
        this.startMediaPlayer();
        this.mPlayPauseButton.setToPause();
        this.startVideoProgressTimer();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Logger.debug("surfaceCreated -- (SurfaceHolder callback)", new Object[0]);
        try {
            if (this.mMediaPlayer == null) {
                this.showProgressBar();
                this.createMediaPlayer();
            }
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            if (!this.mediaSourceSet) {
                String url = this.mVastModel.getPickedMediaFileURL();
                Logger.debug("URL for media file:" + url, new Object[0]);
                this.mMediaPlayer.setDataSource(url);
                this.mMediaPlayer.prepareAsync();
                this.mediaSourceSet = true;
            } else if (this.autoPlay) {
                this.play();
            } else {
                this.activateButtons(true);
            }
        }
        catch (Exception e) {
            Logger.debug("surface created error: %s", e.getMessage());
        }
    }

    private void calculateAspectRatio() {
        Logger.debug("entered calculateAspectRatio", new Object[0]);
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            Logger.debug("mVideoWidth or mVideoHeight is 0, skipping calculateAspectRatio", new Object[0]);
            return;
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mScreenWidth = this.getWidth();
        this.mScreenHeight = this.getHeight();
        Logger.debug("calculating aspect ratio", new Object[0]);
        double widthRatio = 1.0 * (double)this.mScreenWidth / (double)this.mVideoWidth;
        double heightRatio = 1.0 * (double)this.mScreenHeight / (double)this.mVideoHeight;
        double scale = Math.min(widthRatio, heightRatio);
        int surfaceWidth = (int)(scale * (double)this.mVideoWidth);
        int surfaceHeight = (int)(scale * (double)this.mVideoHeight);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(surfaceWidth, surfaceHeight);
        params.addRule(13);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSurfaceHolder.setFixedSize(surfaceWidth, surfaceHeight);
        Logger.debug(" screen size: " + this.mScreenWidth + "x" + this.mScreenHeight, new Object[0]);
        Logger.debug(" video size:  " + this.mVideoWidth + "x" + this.mVideoHeight, new Object[0]);
        Logger.debug(" widthRatio:   " + widthRatio, new Object[0]);
        Logger.debug(" heightRatio:   " + heightRatio, new Object[0]);
        Logger.debug("surface size: " + surfaceWidth + "x" + surfaceHeight, new Object[0]);
    }

    private void cleanUpMediaPlayer() {
        Logger.debug("entered cleanUpMediaPlayer ", new Object[0]);
        if (this.mMediaPlayer != null) {
            if (this.isPlaying()) {
                isVideoPlaying = false;
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.setOnCompletionListener(null);
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnPreparedListener(null);
            this.mMediaPlayer.setOnVideoSizeChangedListener(null);
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        Logger.debug("entered onError -- (MediaPlayer callback)", new Object[0]);
        this.mIsPlayBackError = true;
        Logger.debug("Shutting down Activity due to Media Player errors: WHAT:" + what + ": EXTRA:" + extra + ":", new Object[0]);
        this.processErrorEvent();
        this.closeStreaming();
        return true;
    }

    private void processErrorEvent() {
        Logger.debug("entered processErrorEvent", new Object[0]);
        List<String> errorUrls = this.mVastModel.getErrorUrl();
        this.fireUrls(errorUrls);
    }

    private void processImpressions() {
        Logger.debug("entered processImpressions", new Object[0]);
        this.mIsProcessedImpressions = true;
        List<String> impressions = this.mVastModel.getImpressions();
        this.fireUrls(impressions);
    }

    private void fireUrls(List<String> urls) {
        Logger.debug("entered fireUrls", new Object[0]);
        if (urls != null) {
            for (String url : urls) {
                Logger.debug("\tfiring url:%s", url);
                HttpTools.httpGetURL(url);
            }
        } else {
            Logger.debug("\turl list is null", new Object[0]);
        }
    }

    private void startQuartileTimer() {
        Logger.debug("entered startQuartileTimer", new Object[0]);
        this.stopQuartileTimer();
        if (this.mIsCompleted) {
            Logger.debug("ending quartileTimer because the video has been replayed", new Object[0]);
            return;
        }
        final int videoDuration = this.mMediaPlayer.getDuration();
        this.mTrackingEventTimer = new Timer();
        this.mTrackingEventTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                int percentage = 0;
                if (EAVastPlayerView.this.mMediaPlayer != null) {
                    try {
                        int curPos = EAVastPlayerView.this.mMediaPlayer.getCurrentPosition();
                        if (curPos == 0) {
                            return;
                        }
                        percentage = 100 * curPos / videoDuration;
                    }
                    catch (Exception e) {
                        Logger.error("mediaPlayer.getCurrentPosition exception: %s", e.getMessage());
                        this.cancel();
                        return;
                    }
                } else {
                    return;
                }
                if (percentage >= 25 * EAVastPlayerView.this.mQuartile) {
                    if (EAVastPlayerView.this.mQuartile == 0) {
                        Logger.debug("Video at start: (%s%%)", percentage);
                        EAVastPlayerView.this.processEvent(TRACKING_EVENTS_TYPE.start);
                    } else if (EAVastPlayerView.this.mQuartile == 1) {
                        Logger.debug("Video at first quartile: (%s%%)", percentage);
                        EAVastPlayerView.this.processEvent(TRACKING_EVENTS_TYPE.firstQuartile);
                    } else if (EAVastPlayerView.this.mQuartile == 2) {
                        Logger.debug("Video at midpoint: (%s%%)", percentage);
                        EAVastPlayerView.this.processEvent(TRACKING_EVENTS_TYPE.midpoint);
                    } else if (EAVastPlayerView.this.mQuartile == 3) {
                        Logger.debug("Video at third quartile: (%s%%)", percentage);
                        EAVastPlayerView.this.processEvent(TRACKING_EVENTS_TYPE.thirdQuartile);
                        EAVastPlayerView.this.stopQuartileTimer();
                    }
                    EAVastPlayerView.this.mQuartile++;
                }
            }
        }, 0L, 250L);
    }

    private void stopQuartileTimer() {
        if (this.mTrackingEventTimer != null) {
            this.mTrackingEventTimer.cancel();
            this.mTrackingEventTimer = null;
        }
    }

    private void startVideoProgressTimer() {
        Logger.debug("entered startVideoProgressTimer", new Object[0]);
        this.mStartVideoProgressTimer = new Timer();
        this.mVideoProgressTracker = new LinkedList();
        this.mStartVideoProgressTimer.schedule(new TimerTask(){
            int maxAmountInList = 19;

            @Override
            public void run() {
                if (EAVastPlayerView.this.mMediaPlayer == null) {
                    return;
                }
                if (EAVastPlayerView.this.mVideoProgressTracker.size() == this.maxAmountInList) {
                    int firstPosition = (Integer)EAVastPlayerView.this.mVideoProgressTracker.getFirst();
                    int lastPosition = (Integer)EAVastPlayerView.this.mVideoProgressTracker.getLast();
                    if (lastPosition > firstPosition) {
                        Logger.verbose("video progressing (position:" + lastPosition + ") %s", EAVastPlayerView.this.classId);
                        EAVastPlayerView.this.mVideoProgressTracker.removeFirst();
                    } else {
                        Logger.debug("detected video hang", new Object[0]);
                        EAVastPlayerView.this.mIsPlayBackError = true;
                        EAVastPlayerView.this.stopVideoProgressTimer();
                        EAVastPlayerView.this.processErrorEvent();
                        EAVastPlayerView.this.closeStreaming();
                    }
                }
                try {
                    int curPos = EAVastPlayerView.this.mMediaPlayer.getCurrentPosition();
                    EAVastPlayerView.this.mVideoProgressTracker.addLast(curPos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 250L);
    }

    private void stopToolBarTimer() {
        Logger.debug("entered stopToolBarTimer", new Object[0]);
        if (this.mToolBarTimer != null) {
            this.mToolBarTimer.cancel();
            this.mToolBarTimer = null;
        }
    }

    private void stopVideoProgressTimer() {
        Logger.debug("entered stopVideoProgressTimer", new Object[0]);
        if (this.mStartVideoProgressTimer != null) {
            this.mStartVideoProgressTimer.cancel();
        }
    }

    private void startViewPositionTimer() {
        Logger.debug("entered startViewPositionTimer,%s", this.classId);
        this.mViewPositionHandler = new Handler();
        this.mViewPositionHandler.postDelayed(this.checkIfViewIsVisibleRunnable, 250L);
    }

    private void stopViewPositionTimer() {
        Logger.debug("entered stopViewPositionTimer", new Object[0]);
        if (this.mViewPositionHandler != null) {
            this.mViewPositionHandler.removeCallbacks(this.checkIfViewIsVisibleRunnable);
        }
    }

    private boolean isViewVisible() {
        if (this.isShown()) {
            Rect visibleRect = new Rect();
            Boolean isVisible = this.getGlobalVisibleRect(visibleRect);
            if (!isVisible.booleanValue()) {
                return false;
            }
            Rect viewRect = new Rect();
            this.getDrawingRect(viewRect);
            return (double)(visibleRect.width() * visibleRect.height()) > (double)(viewRect.width() * viewRect.height()) * 0.9;
        }
        return false;
    }

    private void checkIfViewIsVisible() {
        if (!this.isViewVisible()) {
            if (this.isPlaying()) {
                this.processPauseSteps();
            }
        } else if (this.autoPlay && !this.isPlaying() && !this.manualUserInteraction && !isVideoPlaying) {
            this.processPlaySteps();
        }
    }

    private void processEvent(TRACKING_EVENTS_TYPE eventName) {
        Logger.debug("entered Processing Event: " + (Object)((Object)eventName), new Object[0]);
        List<String> urls = this.mTrackingEventMap.get((Object)eventName);
        this.fireUrls(urls);
    }

    public boolean isAutoPlay() {
        return this.autoPlay;
    }

    public void setAutoPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
    }

    public void setVolume(int volume) {
        this.volume = volume;
        this.mMediaPlayer.setVolume((float)volume, (float)volume);
    }
}

