/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.VolleyImageView;
import eanative.android.R;
import eanative.android.ad.AdData;
import eanative.android.events.EANativeEvent;
import eanative.android.events.EANativeEventListener;
import eanative.android.util.EAImageLoader;
import eanative.android.util.Utils;

public class EAImageGallery
extends HorizontalScrollView {
    private final AdClickListener adClickListener;
    protected LinearLayout imagesContainer;
    private AdData adData;

    public EAImageGallery(Context context) {
        super(context);
        this.imagesContainer = new LinearLayout(context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
        int padding = (int)this.getResources().getDimension(R.dimen.media_images_distance);
        this.imagesContainer.setPadding(padding, 0, 0, 0);
        this.imagesContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.imagesContainer);
        this.adClickListener = new AdClickListener();
        this.setHorizontalScrollBarEnabled(false);
    }

    public void setNativeAd(AdData ad, String tagName, ImageLoader imageLoader) {
        this.adData = ad;
        String[] imagesHash = ad.getAdImageTag(tagName);
        this.imagesContainer.removeAllViews();
        for (int i = 0; i < imagesHash.length; ++i) {
            VolleyImageView imageView = new VolleyImageView(this.getContext()){

                public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                    int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
                    this.setMeasuredDimension(height, height);
                }
            };
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
            int margin = (int)this.getResources().getDimension(R.dimen.media_images_distance);
            params.setMargins(0, 0, margin, 0);
            imageView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.imagesContainer.addView((View)imageView);
            imageView.setOnClickListener(this.adClickListener);
            EAImageLoader eaImageLoader = new EAImageLoader();
            eaImageLoader.setNativeAd((View)imageView, ad, tagName, imageLoader);
            eaImageLoader.registerEventListener(EANativeEvent.COMPLETE, new EANativeEventListener(){

                @Override
                public void handleMessage(String event, Object eaImageLoader) {
                    View imageView = ((EAImageLoader)eaImageLoader).getView();
                    Utils.fadeInView(imageView);
                }
            });
            eaImageLoader.loadImage(false, i);
        }
    }

    private final class AdClickListener
    implements View.OnClickListener {
        private AdClickListener() {
        }

        @TargetApi(value=15)
        public void onClick(View view) {
            EAImageGallery.this.callOnClick();
        }
    }
}

