/*
 * Decompiled with CFR 0.152.
 */
package eanative.android.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import eanative.android.events.EANativeEvent;
import eanative.android.events.EventDispatcher;
import eanative.android.util.AndroidAdvertisingIDUtil;
import eanative.android.util.GPSTracker;
import eanative.android.util.Logger;

public class EANSettings
extends EventDispatcher {
    public String carrier = null;
    public String nativeAppKey;
    public final String deviceMake = Build.MANUFACTURER;
    public final String deviceModel = Build.MODEL;
    public String app_id = null;
    public String ua = null;
    public String sdkVersion = "1.18";
    public String marketAppId;
    public String marketAppVersion;
    public String androidAdvertisingID = "";
    public String mcc;
    public String mnc;
    public String ip;
    public boolean aaidProcessFinished = false;
    public boolean isLimitAdTrackingEnabled = true;
    public boolean locationEnabled = true;
    public GPSTracker currentLocation;
    private static EANSettings settings_instance = null;

    public static EANSettings getSettings() {
        if (settings_instance == null) {
            settings_instance = new EANSettings();
        }
        return settings_instance;
    }

    private EANSettings() {
    }

    public static String getCarrier(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        return manager.getNetworkOperatorName();
    }

    public static String getMarketAppVersion(Context context, String marketAppId) {
        PackageInfo info = null;
        try {
            info = context.getPackageManager().getPackageInfo(marketAppId, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Unable to read package version", new Object[0]);
        }
        if (info != null) {
            return info.versionName;
        }
        return "";
    }

    public static void getAAID(Context context) {
        AndroidAdvertisingIDUtil util = new AndroidAdvertisingIDUtil(){

            @Override
            public void onRetrievedID(String androidAdvertisingID, boolean isLimitAdTrackingEnabled) {
                EANSettings.getSettings().setAAID(androidAdvertisingID, isLimitAdTrackingEnabled);
            }

            @Override
            public void onFailedToRetrieveID() {
                EANSettings.getSettings().setAAID(null, false);
            }
        };
        util.getID(context);
    }

    public String getLocation() {
        if (this.currentLocation != null) {
            return this.currentLocation.getLatitude() + "," + this.currentLocation.getLongitude();
        }
        return "";
    }

    public void setAAID(String androidAdvertisingID, boolean isLimitAdTrackingEnabled) {
        this.androidAdvertisingID = androidAdvertisingID;
        this.isLimitAdTrackingEnabled = isLimitAdTrackingEnabled;
        this.aaidProcessFinished = true;
        this.dispatchEvent(EANativeEvent.AAID_PROCESS_COMPLETE, androidAdvertisingID);
    }
}

